/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import java.awt.BorderLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class AnimalStartUpProgress
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int currentState = -1;
    private JProgressBar startUpBar = null;
    private JTextArea taskOutput;
    private String[] steps;
    private JFrame progressFrame;
    private double percentage = 0.0;

    public AnimalStartUpProgress(String title, String[] labels) {
        this.steps = labels;
        this.setLayout(new BorderLayout());
        this.progressFrame = new JFrame(title);
        this.progressFrame.getContentPane().add(this);
        this.startUpBar = new JProgressBar(0, 100);
        this.startUpBar.setValue(0);
        this.percentage = 0.0;
        this.startUpBar.setStringPainted(true);
        this.taskOutput = new JTextArea();
        this.add("North", this.startUpBar);
        this.add("Center", new JScrollPane(this.taskOutput));
        this.progressFrame.setSize(300, 250);
        this.progressFrame.setVisible(true);
    }

    public void nextState(double percentage) {
        this.setState(this.currentState + 1, percentage);
    }

    public void setInvisible() {
        this.progressFrame.setVisible(false);
        this.progressFrame.dispose();
    }

    public void setPercentage(double percent) {
        if (percent < 0.0 || percent > 100.0) {
            return;
        }
        this.percentage = percent;
        this.startUpBar.setValue((int)Math.round(this.percentage));
    }

    public void addPercentage(double percent) {
        this.setPercentage(percent + this.percentage);
    }

    public double getCurrentPercentage() {
        return this.startUpBar.getValue();
    }

    public void setState(int targetState, double percentage) {
        if (this.steps == null || targetState < 0 || targetState >= this.steps.length) {
            return;
        }
        ++this.currentState;
        this.addPercentage(percentage);
        this.addText(this.steps[this.currentState]);
        if (this.currentState == this.steps.length) {
            this.setInvisible();
        }
    }

    public void addText(String text) {
        this.taskOutput.append(text);
        this.taskOutput.append("\n");
        this.taskOutput.setCaretPosition(this.taskOutput.getDocument().getLength());
    }
}

