/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.meta.PolygonalShape;
import animal.misc.XProperties;
import java.awt.Point;

public class PTTriangle
extends PolygonalShape {
    public static final String TRIANGLE_TYPE = "Triangle";
    private static final long serialVersionUID = 5793183274737251118L;

    public PTTriangle() {
        this(4, 2, 0, 0, 0, 0);
    }

    public PTTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        this(new Point(x1, y1), new Point(x2, y2), new Point(x3, y3));
    }

    public PTTriangle(Point first, Point second, Point third) {
        this.initializeWithDefaults(this.getType());
        this.fillNodesVector(3);
        this.setNode(0, first);
        this.setNode(1, second);
        this.setNode(2, third);
    }

    @Override
    public int getFileVersion() {
        return 1;
    }

    public Point getFirstNode() {
        return this.getNodeAsPoint(0);
    }

    public Point getSecondNode() {
        return this.getNodeAsPoint(1);
    }

    public Point getThirdNode() {
        return this.getNodeAsPoint(2);
    }

    @Override
    public String getType() {
        return TRIANGLE_TYPE;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{TRIANGLE_TYPE};
    }

    public void setFirstNode(int x, int y) {
        this.setNode(0, x, y);
    }

    public void setFirstNode(Point node) {
        this.setNode(0, node);
    }

    public void setSecondNode(int x, int y) {
        this.setNode(1, x, y);
    }

    public void setSecondNode(Point node) {
        this.setNode(1, node);
    }

    public void setThirdNode(int x, int y) {
        this.setNode(2, x, y);
    }

    public void setThirdNode(Point node) {
        this.setNode(2, node);
    }

    public String toString() {
        return this.toString(this.getType());
    }

    @Override
    public Object clone() {
        PTTriangle triangle = new PTTriangle();
        this.cloneCommonFeaturesInto(triangle);
        return triangle;
    }

    @Override
    public void useAsMoveBase() {
    }

    @Override
    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".node2", this.getSecondNode());
        defaultProperties.put(String.valueOf(this.getType()) + ".node3", this.getThirdNode());
    }
}

