/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTPoint;
import animal.graphics.meta.PolygonalShape;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.Point;
import java.awt.Rectangle;

public class PTSquare
extends PolygonalShape {
    public static final String SQUARE_TYPE = "Square";
    private static final long serialVersionUID = 5793164474737251118L;
    private int size = 0;

    public PTSquare() {
        this(0, 0, 5);
    }

    public PTSquare(Point node, int squareSize) {
        this(node.x, node.y, squareSize);
    }

    public PTSquare(int x, int y, int squareSize) {
        this.initializeWithDefaults(this.getType());
        this.fillNodesVector(4);
        this.size = squareSize;
        this.setSquareNode(x, y);
    }

    @Override
    public int getFileVersion() {
        return 1;
    }

    public int getSize() {
        return this.size;
    }

    public PTPoint getSquareNode() {
        return this.getNodeAt(0);
    }

    public Point getSquareNodeAsPoint() {
        PTPoint node = this.getNodeAt(0);
        if (node != null) {
            return node.toPoint();
        }
        return new Point(0, 0);
    }

    @Override
    public String getType() {
        return SQUARE_TYPE;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{SQUARE_TYPE};
    }

    public void setSize(int newSize) {
        this.size = newSize;
        this.updateShape();
    }

    public void setSquareNode(int x, int y) {
        this.nodes.clear();
        this.nodes.setSize(4);
        this.nodes.set(0, new PTPoint(x, y));
        this.updateShape();
    }

    public void setSquareNode(Point p) {
        if (p == null) {
            return;
        }
        this.setSquareNode(p.x, p.y);
    }

    public void setSquareNode(PTPoint p) {
        if (p == null) {
            return;
        }
        this.setSquareNode(p.getX(), p.getY());
    }

    @Override
    protected void updateShape() {
        Point node = this.getSquareNodeAsPoint();
        int x = node.x;
        int y = node.y;
        this.nodes.set(1, new PTPoint(x + this.size, y));
        this.nodes.set(2, new PTPoint(x + this.size, y + this.size));
        this.nodes.set(3, new PTPoint(x, y + this.size));
    }

    @Override
    public void scale(double scaleX, double scaleY) {
        if (scaleX != scaleY) {
            MessageDisplay.errorMsg("invalidScaleFactor", new Double[]{scaleX, scaleY}, 4);
        } else {
            super.scale(scaleX, scaleY);
            this.size = (int)((double)this.size * scaleX);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder(120);
        result.append("PTSquare ");
        String name = this.getObjectName();
        if (name != null) {
            result.append("\"").append(name).append("\" ");
        } else {
            result.append("\"").append(this.getNum(false)).append("\" ");
        }
        result.append(this.nodeToString(this.getSquareNodeAsPoint()));
        result.append("size ").append(this.size);
        return result.toString();
    }

    @Override
    public Object clone() {
        PTSquare square = new PTSquare();
        this.cloneCommonFeaturesInto(square);
        return square;
    }

    protected void cloneCommonFeaturesInto(PTSquare targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setSize(this.size);
    }

    @Override
    public int getLength() {
        return this.size * 4;
    }

    @Override
    public Point getPointAtLength(int length) {
        int remainingLength = length;
        int nrSide = 0;
        while (remainingLength > this.size) {
            remainingLength -= this.size;
            ++nrSide;
        }
        nrSide %= 4;
        Point node = this.getSquareNodeAsPoint();
        if (node == null) {
            node = new Point(0, 0);
        }
        switch (nrSide) {
            case 1: {
                return new Point(node.x + this.size, node.y + remainingLength);
            }
            case 2: {
                return new Point(node.x + this.size - remainingLength, node.y);
            }
            case 3: {
                return new Point(node.x, node.y + this.size - remainingLength);
            }
        }
        return new Point(node.x + remainingLength, node.y);
    }

    @Override
    public Rectangle getBoundingBox() {
        return new Rectangle(this.getSquareNodeAsPoint().x, this.getSquareNodeAsPoint().y, this.size, this.size);
    }

    @Override
    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".size", this.getSize());
    }
}

