/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTPoint;
import animal.graphics.meta.OpenLineBasedShape;
import java.awt.Point;
import java.util.Vector;

public class PTPolyline
extends OpenLineBasedShape {
    public static final String POLYLINE_TYPE = "Polyline";
    private static final long serialVersionUID = 5793164474737251118L;

    public PTPolyline() {
        this.initializeWithDefaults(this.getType());
        this.nodes = new Vector(20, 10);
    }

    public PTPolyline(int[] xCoords, int[] yCoords) {
        this();
        if (xCoords != null && yCoords != null && xCoords.length == yCoords.length) {
            int nrNodes = xCoords.length;
            int nodeNr = 0;
            while (nodeNr < nrNodes) {
                this.addNode(new PTPoint(xCoords[nodeNr], yCoords[nodeNr]));
                ++nodeNr;
            }
        }
    }

    public PTPolyline(Point[] edges) {
        this();
        int i = 0;
        while (i < edges.length) {
            this.addNode(new PTPoint(edges[i]));
            ++i;
        }
    }

    public PTPolyline(PTPoint[] edges) {
        this();
        int i = 0;
        while (i < edges.length) {
            this.addNode(edges[i]);
            ++i;
        }
    }

    @Override
    public int getFileVersion() {
        return 5;
    }

    @Override
    public String getType() {
        return POLYLINE_TYPE;
    }

    public void addNode(PTPoint node) {
        this.nodes.addElement(node);
    }

    public void addNode(Point node) {
        this.nodes.addElement(new PTPoint(node));
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{POLYLINE_TYPE};
    }

    public int getDifferentNodesCount() {
        int c = this.nodes.size();
        if (c > 0 && this.nodes.elementAt(0) == this.nodes.elementAt(c - 1)) {
            return c - 1;
        }
        return c;
    }

    public void translate(boolean[] moveTheseOnly, int deltaX, int deltaY) {
        int maxIndex = this.getDifferentNodesCount();
        int nodeNr = 0;
        while (nodeNr < maxIndex) {
            if (this.nodes.elementAt(nodeNr) != null && moveTheseOnly[nodeNr]) {
                ((PTPoint)this.nodes.elementAt(nodeNr)).translate(deltaX, deltaY);
            }
            ++nodeNr;
        }
    }

    public String toString() {
        return this.toString(this.getType());
    }

    public Vector<PTPoint> getNodes() {
        return this.nodes;
    }

    @Override
    public PTPoint getNodeAt(int index) {
        if (index < 0 || index >= this.nodes.size()) {
            return new PTPoint(0, 0);
        }
        PTPoint node = (PTPoint)this.nodes.get(index);
        if (node == null) {
            return new PTPoint(0, 0);
        }
        return node;
    }

    @Override
    public Point getNodeAsPoint(int index) {
        return this.getNodeAt(index).toPoint();
    }

    public void setNodes(Vector<PTPoint> newNodes) {
        this.nodes = newNodes;
    }

    @Override
    public void setNode(int index, PTPoint p) {
        if (index >= this.nodes.size()) {
            this.addNode(p);
        } else if (index == 0) {
            this.nodes.setElementAt(p, 0);
            this.nodes.setElementAt(p, this.nodes.size() - 1);
        } else {
            this.nodes.setElementAt(p, index);
        }
    }

    void removeNodes() {
        if (this.nodes == null) {
            this.nodes = new Vector(20, 10);
        } else {
            this.nodes.clear();
        }
    }

    public void removeNode(int index) {
        this.nodes.removeElementAt(index);
    }

    @Override
    public Object clone() {
        PTPolyline targetShape = new PTPolyline();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    @Override
    public boolean operationRequiresSpecialSelector(String operation) {
        return operation != null && operation.indexOf("Nodes") != -1;
    }

    @Override
    public String baseOperationName(String methodName) {
        if (methodName.endsWith("...")) {
            return methodName.substring(0, methodName.indexOf(46));
        }
        if (methodName.indexOf("Nodes") != 0) {
            return methodName.substring(0, methodName.indexOf(32));
        }
        return methodName;
    }

    @Override
    public boolean enableMultiSelectionFor(String operation) {
        return operation != null && operation.indexOf("Nodes") != -1;
    }

    public boolean compatibleMethod(String method) {
        return method != null && method.indexOf("Nodes") != -1;
    }
}

