/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.meta.CircularShape;
import animal.graphics.meta.OpenArcBasedShape;
import animal.misc.XProperties;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class PTOpenCircleSegment
extends OpenArcBasedShape
implements CircularShape {
    public static final String OPEN_CIRCLE_SEGMENT_TYPE = "OpenCircleSegment";
    private static final long serialVersionUID = 1311724437159551059L;
    private int radius;

    public PTOpenCircleSegment() {
        this.initializeWithDefaults(this.getType());
    }

    public int getAngle(Point p) {
        return this.getAngle(p, this.radius, this.radius);
    }

    @Override
    public Rectangle getBoundingBox() {
        return this.getBoundingBox(this.radius, this.radius);
    }

    @Override
    public int getFileVersion() {
        return 1;
    }

    @Override
    public Point getPointAtLength(int alpha) {
        return this.getPointAtLength(this.getStartAngle() + (this.isClockwise ? -alpha : alpha), this.radius, this.radius);
    }

    @Override
    public int getRadius() {
        return this.radius;
    }

    @Override
    public String getType() {
        return OPEN_CIRCLE_SEGMENT_TYPE;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{OPEN_CIRCLE_SEGMENT_TYPE};
    }

    @Override
    public void setRadius(int r) {
        this.radius = r;
    }

    public String toString() {
        return this.toString(this.getType(), true, this.radius, this.radius);
    }

    @Override
    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".radius", this.getRadius());
    }

    @Override
    public void paint(Graphics g) {
        this.paint(g, this.radius, this.radius);
    }

    @Override
    public Object clone() {
        PTOpenCircleSegment targetShape = new PTOpenCircleSegment();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    protected void cloneCommonFeaturesInto(PTOpenCircleSegment targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setRadius(this.getRadius());
    }
}

