/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTArc;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTText;
import animal.graphics.meta.ImmediateTextContainer;
import animal.main.Animal;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class PTNode
extends PTGraphicObject
implements ImmediateTextContainer {
    public static final String TYPE_LABEL = "Node";
    private Font myFont;
    private FontMetrics fm;
    private PTText entry;
    private PTArc node;
    private int[] connections;

    public PTNode() {
        this.initializeWithDefaults(this.getType());
    }

    public PTNode(String s) {
        this();
        this.enterValue(s);
    }

    @Override
    public void setDepth(int newDepth) {
        int theDepth = newDepth < 2 ? 2 : newDepth;
        super.setDepth(theDepth);
        if (this.entry != null) {
            this.entry.setDepth(theDepth - 2);
            this.node.setDepth(theDepth);
        }
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public void setBGColor(Color c) {
        this.node.setFillColor(c);
    }

    @Override
    public void setFont(Font f) {
        this.myFont = f;
        int textOffset = -this.fm.getAscent();
        int heightOffset = -this.fm.getAscent() - this.fm.getDescent();
        this.fm = Animal.getConcreteFontMetrics(f);
        textOffset += this.fm.getAscent();
        heightOffset = heightOffset + this.fm.getAscent() + this.fm.getDescent();
        this.entry.setFont(f);
    }

    @Override
    public Font getFont() {
        if (this.myFont == null) {
            this.myFont = this.getEntry().getFont();
        }
        return this.myFont;
    }

    public Color getBGColor() {
        return this.getNode().getFillColor();
    }

    public PTText getEntry() {
        if (this.entry == null) {
            this.entry = new PTText(".", new Point(10, 10), this.getFont());
        }
        return this.entry;
    }

    public void setFontColor(Color c) {
        this.entry.setColor(c);
    }

    public Color getFontColor() {
        return this.getEntry().getColor();
    }

    public PTArc getNode() {
        if (this.node == null) {
            this.node = new PTArc();
        }
        return this.node;
    }

    public void setOutlineColor(Color c) {
        this.node.setColor(c);
    }

    public Color getOutlineColor() {
        return this.getNode().getColor();
    }

    public void enterValue(String val) {
        this.entry.setText(val);
    }

    public String getValue() {
        return this.entry.getText();
    }

    @Override
    public void translate(int dx, int dy) {
    }

    @Override
    public Rectangle getBoundingBox() {
        return new Rectangle(0, 0, 10, 10);
    }

    public Point getArrowPoint(int i) {
        return new Point(-1, -1);
    }

    @Override
    public String getType() {
        return TYPE_LABEL;
    }

    @Override
    public Object clone() {
        PTNode targetShape = new PTNode();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    protected void cloneCommonFeaturesInto(PTNode targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setText(new String(this.getText()));
        targetShape.setFont(new Font(this.getFont().getFamily(), this.getFont().getStyle(), this.getFont().getSize()));
        targetShape.node = (PTArc)this.node.clone();
    }

    public String toString() {
        String toString = new String();
        toString = this.getType();
        if (this.getObjectName() != null) {
            toString.concat(" '" + this.getObjectName() + "'");
        }
        toString.concat(" connected to");
        int c = 0;
        while (c < this.connections.length) {
            toString.concat(" " + this.connections[c]);
            if (c < this.connections.length - 2) {
                toString.concat(",");
            } else if (c == this.connections.length - 2) {
                toString.concat(" and");
            }
            ++c;
        }
        return toString;
    }

    @Override
    public int getFileVersion() {
        return 1;
    }

    private void updateEdges() {
    }

    @Override
    public void paint(Graphics g) {
        this.updateEdges();
        this.node.paint(g);
        this.entry.paint(g);
    }

    @Override
    public String getText() {
        return this.getValue();
    }

    @Override
    public void setText(String targetText) {
        this.enterValue(targetText);
    }

    @Override
    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        Font f = this.getFont();
        defaultProperties.put(String.valueOf(this.getType()) + ".bold", f.isBold());
        defaultProperties.put(String.valueOf(this.getType()) + ".font", f);
        defaultProperties.put(String.valueOf(this.getType()) + ".fontName", f.getFamily());
        defaultProperties.put(String.valueOf(this.getType()) + ".fontSize", f.getSize());
        defaultProperties.put(String.valueOf(this.getType()) + ".italic", f.isItalic());
        defaultProperties.put(String.valueOf(this.getType()) + ".text", this.getText());
    }
}

