/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTMatrix;
import animal.graphics.PTText;
import animal.graphics.meta.FillablePrimitive;
import animal.graphics.meta.IndexableContentContainer;
import animal.misc.MessageDisplay;
import java.util.Vector;

public class PTIntMatrix
extends PTMatrix
implements FillablePrimitive,
IndexableContentContainer {
    public static final String TYPE_LABEL = "IntMatrix";
    private Vector<Vector<Integer>> vdata = new Vector();

    public PTIntMatrix() {
        this(1, 1);
    }

    public PTIntMatrix(int[][] newdata) {
        if (newdata != null && newdata[0] != null) {
            this.init();
            this.setSize(newdata.length, newdata[0].length);
            int r = 0;
            while (r < newdata.length) {
                int c = 0;
                while (c < newdata[r].length) {
                    this.vdata.get(r).set(c, new Integer(newdata[r][c]));
                    ++c;
                }
                ++r;
            }
            this.updateTextualRepresentation();
        }
    }

    public PTIntMatrix(int rowcnt, int columncnt) {
        this.init();
        this.setSize(rowcnt, columncnt);
    }

    @Override
    public int getFileVersion() {
        return 1;
    }

    @Override
    public String getType() {
        return TYPE_LABEL;
    }

    @Override
    public int getRowCount() {
        return this.vdata.size();
    }

    @Override
    public int getColumnCount(int row) {
        if (row >= 0 && row < this.getRowCount()) {
            return this.vdata.get(row).size();
        }
        return 0;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    @Override
    public String getElementAt(int r, int c) {
        if (this.indicesAreInRange(r, c)) {
            return String.valueOf(this.vdata.get(r).get(c));
        }
        return String.valueOf(0);
    }

    public int getDataAt(int r, int c) {
        if (this.indicesAreInRange(r, c)) {
            return this.vdata.get(r).get(c);
        }
        return 0;
    }

    public void setDataAt(int r, int c, int value) {
        if (this.indicesAreInRange(r, c)) {
            this.vdata.get(r).set(c, value);
            this.setTextDataAt(r, c, String.valueOf(value));
        }
    }

    public void setDiagonalData(int r, int c, int value, boolean down) {
        block6: {
            int maxcolumncount = this.getMaxColumnCount();
            int rowcount = this.getRowCount();
            if (r < 0 || r >= rowcount || c < 0 || c >= maxcolumncount) break block6;
            if (down) {
                int x = c;
                int y = r;
                while (x < maxcolumncount && y < rowcount) {
                    if (x < this.getColumnCount(y)) {
                        this.setDataAt(y, x, value);
                        this.setTextDataAt(y, x, String.valueOf(value));
                    }
                    ++x;
                    ++y;
                }
            } else {
                int x = c;
                int y = r;
                while (x < maxcolumncount && y >= 0) {
                    if (x < this.getColumnCount(y)) {
                        this.setDataAt(y, x, value);
                        this.setTextDataAt(y, x, String.valueOf(value));
                    }
                    ++x;
                    --y;
                }
            }
        }
    }

    @Override
    public Object clone() {
        PTIntMatrix targetShape = new PTIntMatrix();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    protected void cloneCommonFeaturesInto(PTIntMatrix targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        int rowcount = this.getRowCount();
        targetShape.setRowCount(rowcount);
        int r = 0;
        while (r < rowcount) {
            int columncount = this.getColumnCount(r);
            targetShape.setColumnCount(r, columncount);
            int c = 0;
            while (c < columncount) {
                targetShape.setDataAt(r, c, this.getDataAt(r, c));
                ++c;
            }
            ++r;
        }
    }

    @Override
    protected void updateTextualRepresentation() {
        int r = 0;
        while (r < this.vdata.size()) {
            int c = 0;
            while (c < this.vdata.get(r).size()) {
                ((PTText)((Vector)this.vTextData.get(r)).get(c)).setText(String.valueOf(this.vdata.get(r).get(c)));
                ++c;
            }
            ++r;
        }
    }

    @Override
    protected void addDataItem(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.vdata.size()) {
            this.vdata.get(rowIndex).add(0);
        }
    }

    @Override
    protected void addDataRow() {
        this.vdata.add(new Vector());
    }

    @Override
    protected PTMatrix getPreClone() {
        return new PTIntMatrix();
    }

    @Override
    protected void setDataRowCount(int value) {
        this.vdata.setSize(value);
    }

    @Override
    protected void shrinkDataRow(int rowIndex, int value) {
        if (rowIndex >= 0 && rowIndex < this.getRowCount()) {
            this.vdata.get(rowIndex).setSize(value);
        }
    }

    @Override
    protected void setDataOfSpecialType(int r, int c, String value) {
        try {
            Integer intval = Integer.valueOf(value);
            this.vdata.get(r).set(c, intval);
        }
        catch (NumberFormatException e) {
            MessageDisplay.errorMsg(e.getMessage(), 4);
        }
    }
}

