/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalscript2;

import algoanim.primitives.CircleSeg;
import algoanim.primitives.generators.Language;
import algoanim.properties.CircleSegProperties;
import algoanim.util.Coordinates;
import algoanim.util.Node;
import algoanim.util.Timing;
import animal.exchange.animalscript2.PTGraphicObjectExporter;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTOpenCircleSegment;

public class PTOpenCircleSegmentExporter
extends PTGraphicObjectExporter {
    @Override
    public void export(Language lang, PTGraphicObject ptgo, boolean isVisible, int offset, int duration, boolean timeUnitIsTicks) {
        PTOpenCircleSegment shape = (PTOpenCircleSegment)ptgo;
        if (PTOpenCircleSegmentExporter.getExportStatus(shape)) {
            lang.addLine("# previously exported: '" + shape.getNum(false) + "/" + shape.getObjectName());
        }
        Coordinates center = Node.convertToNode(shape.getCenter());
        CircleSegProperties cp = new CircleSegProperties();
        this.installStandardProperties(cp, shape, isVisible);
        cp.set("angle", shape.getTotalAngle());
        cp.set("startAngle", shape.getStartAngle());
        cp.set("clockwise", shape.isClockwise());
        cp.set("counterclockwise", !shape.isClockwise());
        cp.set("closed", false);
        cp.set("fwArrow", shape.hasFWArrow());
        cp.set("bwArrow", shape.hasBWArrow());
        Timing t = this.createTiming(lang, offset, timeUnitIsTicks);
        CircleSeg result = lang.newCircleSeg(center, shape.getRadius(), shape.getObjectName(), t, cp);
        hasBeenExported.put(shape.getNum(false), result);
    }
}

