/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalscript2;

import algoanim.primitives.ListElement;
import algoanim.primitives.generators.Language;
import algoanim.properties.ListElementProperties;
import algoanim.util.Coordinates;
import algoanim.util.Node;
import algoanim.util.Timing;
import animal.exchange.animalscript2.PTGraphicObjectExporter;
import animal.graphics.PTBoxPointer;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTLine;
import animal.graphics.PTRectangle;
import java.util.LinkedList;

public class PTBoxPointerExporter
extends PTGraphicObjectExporter {
    @Override
    public void export(Language lang, PTGraphicObject ptgo, boolean isVisible, int offset, int duration, boolean timeUnitIsTicks) {
        PTBoxPointer shape = (PTBoxPointer)ptgo;
        if (PTBoxPointerExporter.getExportStatus(shape)) {
            lang.addLine("# previously exported: '" + shape.getNum(false) + "/" + shape.getObjectName());
        }
        Coordinates upperLeft = Node.convertToNode(shape.getPosition());
        ListElementProperties lep = new ListElementProperties();
        this.installStandardProperties(lep, shape, isVisible);
        lep.set("text", shape.getText());
        lep.set("position", shape.getPointerPosition());
        lep.set("boxFillColor", shape.getFillColor());
        PTRectangle pointerArea = shape.getPointerArea();
        if (pointerArea != null) {
            lep.set("pointerAreaColor", pointerArea.getColor());
            lep.set("pointerAreaFillColor", pointerArea.getFillColor());
        }
        if (shape.getTextComponent() != null) {
            lep.set("textColor", shape.getTextComponent().getColor());
        }
        Timing t = this.createTiming(lang, offset, timeUnitIsTicks);
        LinkedList<Object> ptrLocations = new LinkedList<Object>();
        for (PTLine pointer : shape.getPointers()) {
            ptrLocations.add(pointer);
        }
        ListElement result = lang.newListElement(upperLeft, shape.getPointerCount(), ptrLocations, null, null, shape.getObjectName(), t, lep);
        hasBeenExported.put(shape.getNum(false), result);
    }
}

