/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalscript2;

import algoanim.primitives.generators.Language;
import animal.animator.Animator;
import animal.exchange.animalscript2.Exporter;
import animal.exchange.animalscript2.PTGraphicObjectExporter;
import animal.graphics.PTGraphicObject;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AnimatorExporter
implements Exporter {
    static PTGraphicObject[] graphicObjects = null;
    static Hashtable<String, Exporter> objectExporters = new Hashtable(53);

    public static void setGraphicObjects(Vector<PTGraphicObject> objects) {
        int nrOfGraphicObjects = objects.size();
        PTGraphicObject lastGO = objects.lastElement();
        int lastObjectNumber = -1;
        int i = 0;
        while (i < nrOfGraphicObjects) {
            lastGO = objects.elementAt(i);
            if (lastGO.getNum(false) > lastObjectNumber) {
                lastObjectNumber = lastGO.getNum(false);
            }
            ++i;
        }
        graphicObjects = new PTGraphicObject[lastObjectNumber + 1];
        PTGraphicObject currentObject = null;
        int i2 = 0;
        while (i2 < nrOfGraphicObjects) {
            currentObject = objects.elementAt(i2);
            if (currentObject != null) {
                AnimatorExporter.graphicObjects[currentObject.getNum((boolean)false)] = currentObject;
            }
            ++i2;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(2048);
        int i = 0;
        while (i < graphicObjects.length) {
            sb.append("@").append(i).append(": ").append(graphicObjects[i].getNum(false));
            ++i;
        }
        return sb.toString();
    }

    public abstract void export(Language var1, Animator var2);

    public void exportObjectIDs(Language lang, Animator animator) {
        int[] objectNums = animator.getObjectNums();
        this.exportObjectIDs(lang, objectNums);
    }

    public void exportObjectIDs(Language lang, int objectNum) {
        this.exportObjectIDs(lang, new int[]{objectNum});
    }

    public void exportUsedObjects(Language lang, int objectNum) {
        this.exportUsedObjects(lang, new int[]{objectNum}, true, 0, 0, true);
    }

    public void exportUsedObjects(Language lang, int[] objectNums) {
        this.exportUsedObjects(lang, objectNums, true, 0, 0, true);
    }

    public void exportUsedObjects(Language lang, int[] objectNums, boolean isVisible) {
        this.exportUsedObjects(lang, objectNums, isVisible, 0, 0, true);
    }

    public void exportUsedObjects(Language lang, int[] objectNums, boolean isVisible, int offset, int duration, boolean timeUnitIsTicks) {
        PTGraphicObject ptgo = null;
        String className = null;
        String subName = null;
        int i = 0;
        while (i < objectNums.length) {
            ptgo = graphicObjects[objectNums[i]];
            if (ptgo != null && !PTGraphicObjectExporter.getExportStatus(ptgo)) {
                className = ptgo.getClass().getName();
                try {
                    if (!objectExporters.containsKey(className)) {
                        StringBuilder handlerName = new StringBuilder("animal.exchange.animalscript2.");
                        handlerName.append(className.substring(className.lastIndexOf(46) + 1));
                        handlerName.append("Exporter");
                        subName = handlerName.toString();
                        Class<?> c = Class.forName(subName);
                        PTGraphicObjectExporter handler = (PTGraphicObjectExporter)c.newInstance();
                        objectExporters.put(className, handler);
                    }
                    PTGraphicObjectExporter localHandler = (PTGraphicObjectExporter)objectExporters.get(className);
                    localHandler.export(lang, ptgo, isVisible, offset, duration, timeUnitIsTicks);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    public String exportObjectIDs(Language lang, int[] objectNums) {
        PTGraphicObject ptgo = null;
        String currentName = null;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (objectNums != null && i < objectNums.length) {
            sb.append(" \"");
            ptgo = graphicObjects[objectNums[i]];
            currentName = ptgo.getObjectName();
            if (currentName == null) {
                currentName = String.valueOf(ptgo.getNum(false));
            }
            sb.append(currentName);
            sb.append("\"");
            ++i;
        }
        return sb.toString();
    }
}

