/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.animalascii.PTGraphicObjectImporter;
import animal.graphics.PTPoint;
import animal.graphics.PTPolyline;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animalscript.core.AnimalParseSupport;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Vector;

public class PTPolylineImporter
extends PTGraphicObjectImporter {
    @Override
    public Object importFrom(int version, StreamTokenizer stok) {
        PTPolyline shape = new PTPolyline();
        try {
            if (version > shape.getFileVersion()) {
                ParseSupport.formatException2("fileVersionMismatch", new Object[]{String.valueOf(version), String.valueOf(shape.getFileVersion()), stok.toString()});
            }
            shape.setColor(ParseSupport.parseColor(stok, "Polyline color"));
            shape.setFWArrow(ParseSupport.parseOptionalWord(stok, "Polyline fwArrow", "fwArrow"));
            shape.setBWArrow(ParseSupport.parseOptionalWord(stok, "Polyline bwArrow", "bwArrow"));
            ParseSupport.parseOptionalWord(stok, "Polyline closed", "closed");
            ParseSupport.parseOptionalWord(stok, "Polyline filled", "filled");
            ParseSupport.parseMandatoryWord(stok, "Polyline keyword 'nodes'", "nodes");
            ParseSupport.parseMandatoryChar(stok, "Polyline keyword nodes ':'", ':');
            Vector<PTPoint> nodes = AnimalParseSupport.parsePolyline(stok, "Polyline nodes").getNodes();
            for (PTPoint node : nodes) {
                shape.addNode(node);
            }
            if (ParseSupport.parseOptionalWord(stok, "Compatibility: polyline fill color", "fillColor")) {
                stok.pushBack();
                ParseSupport.parseColor(stok, "Polyline", "fillColor");
            }
            if (version >= 4) {
                this.parseEndingValuesFrom(stok, shape, "Polyline");
            }
        }
        catch (IOException e) {
            MessageDisplay.errorMsg(e.getMessage(), 4);
        }
        return shape;
    }
}

