/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.graphics;

import animal.editor.Editor;
import animal.editor.graphics.GraphicEditor;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTLine;
import animal.gui.DrawCanvas;
import animal.main.Animation;
import animal.misc.ColorChoice;
import animal.misc.ColorChooserAction;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import translator.AnimalTranslator;
import translator.ExtendedActionButton;
import translator.TranslatableGUIElement;

public class LineEditor
extends GraphicEditor
implements ItemListener,
ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = -2413776784253970663L;
    private JCheckBox bwArrowCB;
    private ColorChooserAction colorChooser;
    private JCheckBox fwArrowCB;

    @Override
    protected void buildGUI() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        this.addBox(this.createColorBox(generator));
        this.fwArrowCB = generator.generateJCheckBox("ArrowableShapeEditor.fwArrow", null, this);
        this.fwArrowCB.addItemListener(this);
        this.bwArrowCB = generator.generateJCheckBox("ArrowableShapeEditor.bwArrow", null, this);
        this.bwArrowCB.addItemListener(this);
        Box polylinePropertiesBox = generator.generateBorderedBox(2, "LineEditor.propertiesBL");
        polylinePropertiesBox.add(this.fwArrowCB);
        polylinePropertiesBox.add(this.bwArrowCB);
        this.addBox(polylinePropertiesBox);
        this.finishBoxes();
    }

    public Box createColorBox(TranslatableGUIElement generator) {
        Box colorBox = generator.generateBorderedBox(2, "GenericEditor.colorBL");
        Color initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTLine)this.getCurrentObject(false)).getColor();
        this.colorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "color", AnimalTranslator.translateMessage("GenericEditor.chooseColor", new Object[]{AnimalTranslator.translateMessage("OpenObjectEditor.outline")}), initialColor);
        colorBox.add(new ExtendedActionButton(this.colorChooser, 67));
        return colorBox;
    }

    @Override
    public int pointsNeeded() {
        return 2;
    }

    @Override
    public boolean nextPoint(int num, Point p) {
        PTLine line = (PTLine)this.getCurrentObject();
        if (num == 1) {
            line.setFirstNode(p.x, p.y);
        } else if (num == 2) {
            line.setLastNode(p.x, p.y);
        }
        return true;
    }

    @Override
    public int getMinDist(PTGraphicObject go, Point p) {
        PTLine pg = (PTLine)go;
        Rectangle boundingBox = pg.getBoundingBox();
        if (boundingBox.contains(p.x, p.y)) {
            return 0;
        }
        int minDist = Integer.MAX_VALUE;
        int newDist = MSMath.dist(p, pg.getFirstNode().toPoint(), pg.getLastNode().toPoint());
        if (newDist < minDist) {
            minDist = newDist;
        }
        return minDist;
    }

    @Override
    public EditPoint[] getEditPoints(PTGraphicObject go) {
        PTLine pg = (PTLine)go;
        EditPoint[] result = new EditPoint[3];
        Point startNode = pg.getFirstNode().toPoint();
        Point endNode = pg.getLastNode().toPoint();
        result[0] = new EditPoint(0, startNode);
        result[1] = new EditPoint(1, endNode);
        result[2] = new EditPoint(-1, new Point((startNode.x + endNode.x) / 2, (startNode.y + endNode.y) / 2));
        return result;
    }

    @Override
    public void setProperties(XProperties props) {
        this.colorChooser.setColor(props.getColorProperty("Line.color", Color.black));
        this.depthBox.setSelectedItem(props.getProperty("Line.depth", "16"));
        this.bwArrowCB.setSelected(props.getBoolProperty("Line.bwArrow"));
        this.fwArrowCB.setSelected(props.getBoolProperty("Line.fwArrow"));
    }

    @Override
    public void getProperties(XProperties props) {
        props.put("Line.color", this.colorChooser.getColor());
        props.put((Object)"Line.depth", this.depthBox.getSelectedItem());
        props.put("Line.bwArrow", this.bwArrowCB.isSelected());
        props.put("Line.fwArrow", this.fwArrowCB.isSelected());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        PTLine p = (PTLine)this.getCurrentObject();
        if (e.getSource() == this.fwArrowCB && p != null) {
            p.setFWArrow(this.fwArrowCB.isSelected());
        }
        if (e.getSource() == this.bwArrowCB && p != null) {
            p.setBWArrow(this.bwArrowCB.isSelected());
        }
        Animation.get().doChange();
        this.repaintNow();
    }

    @Override
    public EditableObject createObject() {
        PTLine pg = new PTLine();
        this.storeAttributesInto(pg);
        return pg;
    }

    @Override
    protected void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTLine p = (PTLine)eo;
        p.setColor(this.colorChooser.getColor());
        p.setFWArrow(this.fwArrowCB.isSelected());
        p.setBWArrow(this.bwArrowCB.isSelected());
    }

    @Override
    protected void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTLine p = (PTLine)eo;
        this.colorChooser.setColor(p.getColor());
        this.fwArrowCB.setSelected(p.hasFWArrow());
        this.bwArrowCB.setSelected(p.hasBWArrow());
    }

    @Override
    public Editor getSecondaryEditor(EditableObject go) {
        LineEditor result = new LineEditor();
        result.extractAttributesFrom(go);
        return result;
    }

    @Override
    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage("LineEditor.statusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateFinishButton(), DrawCanvas.translateCancelButton()});
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        PTLine p = (PTLine)this.getCurrentObject();
        if (p != null) {
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
            this.repaintNow();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        PTLine poly = (PTLine)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if ("color".equals(eventName)) {
            poly.setColor((Color)event.getNewValue());
        }
        if (!event.getOldValue().equals(event.getNewValue())) {
            this.repaintNow();
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
        }
    }

    @Override
    public String getBasicType() {
        return "Line";
    }
}

