/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.animators;

import animal.animator.SetFont;
import animal.editor.Editor;
import animal.editor.animators.TimedAnimatorEditor;
import animal.main.Animal;
import animal.misc.EditableObject;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import translator.AnimalTranslator;
import translator.TranslatableGUIElement;

public class SetFontEditor
extends TimedAnimatorEditor {
    private static final long serialVersionUID = -2832505946091287650L;
    private JScrollPane scp;
    private JComboBox fontName;
    private JComboBox fontSize;
    private JCheckBox isItalicBox;
    private JCheckBox isBoldBox;
    private boolean isItalic;
    private boolean isBold;

    @Override
    protected void buildGUI() {
        super.buildGUI();
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        JTabbedPane tp = new JTabbedPane();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel fontPanel = new JPanel(gbl);
        fontPanel.add((Component)generator.generateJLabel("GenericEditor.nameLabel"), gbc);
        String[] fonts = Animal.GLOBAL_FONTS;
        gbc.gridwidth = 0;
        this.fontName = new JComboBox();
        fontPanel.add((Component)this.fontName, gbc);
        int j = 0;
        while (j < fonts.length) {
            this.fontName.addItem(fonts[j]);
            ++j;
        }
        this.fontName.addActionListener(this);
        gbc.gridwidth = 1;
        fontPanel.add((Component)generator.generateJLabel("AbstractTextEditor.fontSizeLabel"), gbc);
        gbc.gridwidth = 0;
        this.fontSize = new JComboBox();
        fontPanel.add((Component)this.fontSize, gbc);
        this.fontSize.setEditable(true);
        this.fontSize.addItem("8");
        this.fontSize.addItem("10");
        this.fontSize.addItem("12");
        this.fontSize.addItem("14");
        this.fontSize.addItem("16");
        this.fontSize.addItem("24");
        this.fontSize.setSelectedItem("12");
        this.fontSize.addActionListener(this);
        gbc.gridwidth = 1;
        fontPanel.add((Component)generator.generateJLabel("AbstractTextEditor.fontStyleLabel"), gbc);
        this.isItalicBox = generator.generateJCheckBox("italic", null, this);
        this.isItalicBox.setHorizontalAlignment(0);
        fontPanel.add((Component)this.isItalicBox, gbc);
        this.isBoldBox = generator.generateJCheckBox("bold", null, this);
        this.isBoldBox.setHorizontalAlignment(0);
        fontPanel.add((Component)this.isBoldBox, gbc);
        generator.insertTranslatableTab("SetFontEditor.font", null, fontPanel, tp);
        this.scp = new JScrollPane(fontPanel);
        this.addLayer(this.scp);
        this.finish();
    }

    void extractFont(Font f) {
        this.fontName.setSelectedItem(f.getName());
        this.fontSize.setSelectedItem(String.valueOf(f.getSize()));
        this.isItalicBox.setSelected(f.isItalic());
        this.isBoldBox.setSelected(f.isBold());
    }

    @Override
    public void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        Font f = ((SetFont)eo).getValue();
        this.isItalic = f.isItalic();
        this.isBold = f.isBold();
        this.isItalicBox.setSelected(this.isItalic);
        this.isBoldBox.setSelected(this.isBold);
        this.fontName.setSelectedItem(f.getName());
        this.fontSize.setSelectedItem(String.valueOf(f.getSize()));
    }

    @Override
    public void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        SetFont setFont = (SetFont)eo;
        setFont.setValue(this.storeFont());
    }

    Font storeFont() {
        String name = (String)this.fontName.getSelectedItem();
        String size = (String)this.fontSize.getSelectedItem();
        this.isItalic = this.isItalicBox.isSelected();
        this.isBold = this.isBoldBox.isSelected();
        return new Font(name, 0 + (this.isBold ? 1 : 0) + (this.isItalic ? 2 : 0), this.getInt(size, 12));
    }

    @Override
    public Editor getSecondaryEditor(EditableObject eo) {
        SetFontEditor result = new SetFontEditor();
        result.extractAttributesFrom(eo);
        return result;
    }

    @Override
    public EditableObject createObject() {
        SetFont h = new SetFont();
        this.storeAttributesInto(h);
        return h;
    }
}

