/*
 * Decompiled with CFR 0.152.
 */
package animal.dialog;

import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.misc.MessageDisplay;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import translator.AnimalTranslator;

public class HtmlPanel
extends JPanel
implements HyperlinkListener {
    private static final long serialVersionUID = -2455829185592463221L;
    public JEditorPane html;

    public HtmlPanel() {
        this.init();
    }

    protected void init() {
        this.setBackground(Color.WHITE);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout());
        this.getAccessibleContext().setAccessibleName(AnimalTranslator.translateMessage("htmlPanelName", null));
        this.getAccessibleContext().setAccessibleDescription(AnimalTranslator.translateMessage("htmlPanelDescr", null));
    }

    public void setURL(String urlString) {
        block3: {
            try {
                URL url = new URL(urlString);
                this.html = new JEditorPane(url);
            }
            catch (MalformedURLException e) {
                MessageDisplay.errorMsg(AnimalTranslator.translateMessage("malformedURL", new Object[]{urlString}), 4);
                this.manuallyGenerate(urlString);
            }
            catch (IOException e) {
                MessageDisplay.errorMsg(AnimalTranslator.translateMessage("ioException", new Object[]{urlString}), 4);
                if (this.html != null) break block3;
                this.manuallyGenerate(urlString);
            }
        }
        this.finishDisplay();
    }

    public void setContentString(String contentString) {
        this.html = new JEditorPane("text/html", contentString);
        this.finishDisplay();
    }

    protected void finishDisplay() {
        this.html.setEditable(false);
        this.html.addHyperlinkListener(this);
        JScrollPane scroller = new JScrollPane(this.html);
        scroller.setBorder(new SoftBevelBorder(1));
        this.add((Component)scroller, "Center");
        this.html.setVisible(true);
        this.setVisible(true);
    }

    public void manuallyGenerate(String urlString) {
        if (urlString == null) {
            return;
        }
        String tutorialID = AnimalConfiguration.getDefaultConfiguration().getProperty("tutorial.path", AnimalTranslator.translateMessage("tutorialPath", null));
        String localeString = Animal.getAnimalConfiguration().getProperty("animal.Locale", "en_US");
        if (urlString.equalsIgnoreCase(tutorialID)) {
            URL url = this.getClass().getResource("/AnimalTutorial_" + localeString + ".html");
            System.err.println("Retrieving local copy at " + url.toString());
            try {
                this.html = new JEditorPane(url);
                this.finishDisplay();
            }
            catch (IOException iOException) {}
        } else {
            URL url = this.getClass().getResource("/animalScript_" + localeString + ".html");
            System.err.println("Retrieving local copy at " + url.toString());
            try {
                this.html = new JEditorPane(url);
                this.finishDisplay();
            }
            catch (IOException e) {
                url = this.getClass().getResource("/animalScript.html");
                try {
                    this.html = new JEditorPane(url);
                }
                catch (IOException e2) {
                    MessageDisplay.errorMsg("URL open failed for '" + urlString + "'", 4);
                }
            }
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(e.getURL());
        }
    }

    protected void linkActivated(URL u) {
        Cursor c = this.html.getCursor();
        Cursor waitCursor = Cursor.getPredefinedCursor(3);
        this.html.setCursor(waitCursor);
        SwingUtilities.invokeLater(new PageLoader(u, c));
    }

    class PageLoader
    implements Runnable {
        Cursor cursor;
        URL url;

        PageLoader(URL u, Cursor c) {
            this.url = u;
            this.cursor = c;
        }

        @Override
        public void run() {
            if (this.url == null) {
                HtmlPanel.this.html.setCursor(this.cursor);
                Container parent = HtmlPanel.this.html.getParent();
                parent.repaint();
            } else {
                Document doc = HtmlPanel.this.html.getDocument();
                try {
                    try {
                        HtmlPanel.this.html.setPage(this.url);
                    }
                    catch (IOException ioe) {
                        HtmlPanel.this.html.setDocument(doc);
                        HtmlPanel.this.getToolkit().beep();
                        this.url = null;
                        SwingUtilities.invokeLater(this);
                    }
                }
                finally {
                    this.url = null;
                    SwingUtilities.invokeLater(this);
                }
            }
        }
    }
}

