/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.Animator;
import animal.main.AnimalConfiguration;
import animal.main.AnimationState;

public class VariableUpdate
extends Animator {
    private static final int FILE_VERSION = 1;
    public static final String TYPE_LABEL = "VariableUpdate";
    private transient AnimationState animState;
    private String name;
    private String newValue;

    public VariableUpdate() {
    }

    public VariableUpdate(int step, String name, String newValue) {
        super(step, (int[])null);
        this.name = name;
        this.newValue = newValue;
    }

    @Override
    public void init(AnimationState animationState, long time, double ticks) {
        super.init(animationState, time, ticks);
        this.animState = animationState;
    }

    @Override
    public void action(long time, double ticks) {
        this.execute();
    }

    @Override
    public void execute() {
        super.execute();
        if (this.animState != null) {
            this.animState.getVariables().get(this.name).setValue(this.newValue);
        }
        AnimalConfiguration.getDefaultConfiguration().getWindowCoordinator().getVariableView().setStep(this.getStep());
    }

    @Override
    public String getAnimatorName() {
        return TYPE_LABEL;
    }

    @Override
    public int getFileVersion() {
        return 1;
    }

    @Override
    public String getType() {
        return TYPE_LABEL;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    @Override
    public boolean isChangingAnimator() {
        return false;
    }

    @Override
    public boolean isGraphicalObjectAnimator() {
        return false;
    }

    @Override
    public void discard() {
        this.animState = null;
        this.name = null;
        this.newValue = null;
        super.discard();
    }

    @Override
    public String toString() {
        return "Variable Update: " + this.name + " to " + this.newValue;
    }
}

