/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.Animator;
import animal.main.AnimalConfiguration;
import animal.main.AnimationState;
import animal.variables.Variable;

public class VariableDeclaration
extends Animator {
    private static final int FILE_VERSION = 1;
    public static final String TYPE_LABEL = "VariableDeclaration";
    private transient AnimationState animState;
    private String name;
    private String value;
    private int initStep;

    public VariableDeclaration() {
    }

    public VariableDeclaration(int step, String name) {
        this(step, name, "");
    }

    public VariableDeclaration(int step, String name, String value) {
        super(step, (int[])null);
        this.name = name;
        this.value = value;
        this.initStep = step;
    }

    @Override
    public void init(AnimationState animationState, long time, double ticks) {
        super.init(animationState, time, ticks);
        this.animState = animationState;
    }

    @Override
    public void action(long time, double ticks) {
        this.execute();
    }

    @Override
    public void execute() {
        super.execute();
        Variable newVar = new Variable(this.name, this.value, this.initStep);
        this.animState.putVariable(newVar);
        AnimalConfiguration.getDefaultConfiguration().getWindowCoordinator().getVariableView().setStep(this.getStep());
    }

    @Override
    public String getAnimatorName() {
        return TYPE_LABEL;
    }

    @Override
    public int getFileVersion() {
        return 1;
    }

    @Override
    public String getType() {
        return TYPE_LABEL;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    @Override
    public boolean isChangingAnimator() {
        return false;
    }

    @Override
    public boolean isGraphicalObjectAnimator() {
        return false;
    }

    @Override
    public void discard() {
        this.animState = null;
        this.name = null;
        this.value = null;
        this.initStep = -1;
        super.discard();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(255);
        sb.append(this.name);
        if (this.value != null && this.value.length() > 0) {
            sb.append(" = ").append(this.value);
        }
        sb.append(";");
        return sb.toString();
    }

    public AnimationState getAnimState() {
        return this.animState;
    }

    public void setAnimState(AnimationState animState) {
        this.animState = animState;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

