/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import java.awt.Point;
import translator.AnimalTranslator;

public class SwapType {
    private int[] swapElements = new int[2];
    private Object[] originalContent = null;
    public byte percentage;
    public boolean done = false;
    public Point p1;
    public Point p2;
    public Point p3;

    public SwapType(int first, int second) {
        this.setElements(first, second);
        this.p1 = new Point(0, 0);
        this.p2 = new Point(0, 0);
        this.p3 = new Point(0, 0);
    }

    public SwapType(int first, int second, byte part) {
        this(first, second);
        this.percentage = part;
    }

    public SwapType(int first, int second, int part) {
        this(first, second, (byte)part);
    }

    public SwapType(int[] elements, byte part) {
        this(elements[0], elements[1], part);
    }

    public SwapType(int[] elements, int part) {
        this(elements, (byte)part);
    }

    public SwapType(int[] elements, byte part, boolean state) {
        this(elements[0], elements[1], part);
        this.done = state;
    }

    public SwapType(int[] elements, int part, boolean state) {
        this(elements, (byte)part);
        this.done = state;
    }

    public SwapType(int[] elements, Point point1, Point point2, Point point3, boolean state) {
        this(elements[0], elements[1]);
        this.setSwapPoints(point1, point2, point3);
        this.done = state;
    }

    public SwapType(SwapType st) {
        this.swapElements = new int[st.swapElements.length];
        int i = 0;
        while (i < st.swapElements.length) {
            this.swapElements[i] = st.swapElements[i];
            ++i;
        }
        this.percentage = st.percentage;
        this.done = st.done;
        this.originalContent = st.originalContent;
    }

    public void setSwapPoints(Point lower, Point upper, Point shift) {
        this.p1 = lower;
        this.p2 = upper;
        this.p3 = shift;
    }

    public void setElements(int a, int b) {
        this.swapElements[0] = a;
        this.swapElements[1] = b;
    }

    public int[] getElements() {
        return this.swapElements;
    }

    public Object[] getOrigContents() {
        return this.originalContent;
    }

    public String toString() {
        if (this.swapElements[0] < 0 || this.swapElements[1] < 0) {
            return AnimalTranslator.translateMessage("swapNoCellsDefined");
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("Swap cells ").append(this.swapElements[0]).append(" and ");
        sb.append(this.swapElements[1]).append(", lower position ").append(this.p1);
        sb.append(", upper position ").append(this.p2);
        sb.append(", translation position ").append(this.p3);
        return sb.toString();
    }
}

