/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.GraphicObjectSpecificAnimation;
import animal.animator.TimedAnimator;
import animal.main.AnimalConfiguration;
import animal.main.AnimationState;
import animal.misc.XProperties;
import java.awt.Color;

public class HighlightEdge
extends TimedAnimator
implements GraphicObjectSpecificAnimation {
    public static final String TYPE_LABEL = "HighlightEdge";
    public static final String REAL_DEACTIVATE = "doRealCellDeactivation";
    private boolean[][] hlState;
    private static boolean realDeactivation;

    public HighlightEdge() {
        if (DefaultProperties == null) {
            HighlightEdge.initializeDefaultProperties(AnimalConfiguration.getDefaultConfiguration().getProperties());
        }
        this.setProperties((XProperties)DefaultProperties.clone());
        realDeactivation = this.getProperties().getBoolProperty(this.mapKey(REAL_DEACTIVATE), false);
    }

    public HighlightEdge(int length) {
        this();
        this.setHighlightState(length - 1, length - 1, false);
    }

    @Override
    public void init(AnimationState animationState, long time, double ticks) {
        super.init(animationState, time, ticks);
    }

    @Override
    public Object getProperty(double factor) {
        int length = 1;
        if (this.hlState != null && this.hlState.length > 0) {
            length = this.hlState.length;
        }
        double[][] states = new double[length][length];
        int i = 0;
        while (i < length) {
            int j = 0;
            while (j < length) {
                states[i][j] = this.getHighlightState(i, j) ? factor : -1.0;
                ++j;
            }
            ++i;
        }
        return states;
    }

    public boolean getHighlightState(int index1, int index2) {
        if (this.hlState == null || index1 < 0 || index1 >= this.hlState.length || index2 < 0 || index2 >= this.hlState.length) {
            return false;
        }
        return this.hlState[index1][index2];
    }

    public boolean[][] getHighlightState() {
        return this.hlState;
    }

    public void setHighlightState(int index1, int index2, boolean state) throws IndexOutOfBoundsException {
        int index = Math.max(index1, index2);
        if (index < 0) {
            throw new IndexOutOfBoundsException("Try to access a negative array index.");
        }
        if (this.hlState == null) {
            this.hlState = new boolean[index + 1][index + 1];
            int i = 0;
            while (i < index) {
                int j = 0;
                while (j < index) {
                    this.hlState[i][j] = false;
                    ++j;
                }
                ++i;
            }
        } else if (index >= this.hlState.length) {
            int j;
            boolean[][] temp = this.hlState;
            this.hlState = new boolean[index][index];
            int i = 0;
            while (i < temp.length) {
                j = 0;
                while (j < temp.length) {
                    this.hlState[i][j] = temp[i][j];
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.hlState.length) {
                j = temp.length;
                while (j < index) {
                    this.hlState[i][j] = false;
                    ++j;
                }
                ++i;
            }
            i = this.hlState.length;
            while (i < index) {
                j = 0;
                while (j < index) {
                    this.hlState[i][j] = false;
                    ++j;
                }
                ++i;
            }
        }
        this.hlState[index1][index2] = state;
    }

    public void setHighlightState(boolean[][] states) {
        this.hlState = states;
    }

    public static boolean realDeactivation() {
        return realDeactivation;
    }

    public static void initializeDefaultProperties(XProperties properties) {
        DefaultProperties = HighlightEdge.extractDefaultProperties(properties, TYPE_LABEL);
    }

    @Override
    public String getType() {
        return TYPE_LABEL;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL, "UnhighlightEdge"};
    }

    @Override
    public String getAnimatorName() {
        return TYPE_LABEL;
    }

    public static Color fadeColor(Color old, Color now, double part) {
        if (part < 0.0 || part > 1.0) {
            return old;
        }
        int r = (int)(part * (double)now.getRed() + (1.0 - part) * (double)old.getRed());
        int g = (int)(part * (double)now.getGreen() + (1.0 - part) * (double)old.getGreen());
        int b = (int)(part * (double)now.getBlue() + (1.0 - part) * (double)old.getBlue());
        return new Color(r, g, b);
    }

    @Override
    public String toString() {
        if (this.hlState == null || this.hlState.length == 0) {
            return "No highlight element set!";
        }
        int counter = 0;
        String toString = new String();
        int i = this.hlState.length - 1;
        while (i >= 0) {
            int j = this.hlState.length - 1;
            while (j >= 0) {
                if (this.hlState[i][j]) {
                    if (counter >= 1) {
                        toString = String.valueOf(String.valueOf(i)) + " " + String.valueOf(j) + ", " + toString;
                        ++counter;
                    } else {
                        toString = String.valueOf(String.valueOf(i)) + " " + String.valueOf(j);
                        ++counter;
                    }
                }
                --j;
            }
            --i;
        }
        toString = String.valueOf(this.getMethod()) + " " + toString + " of " + super.toString();
        return toString;
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[]{"Graph"};
    }
}

