/*
 * Decompiled with CFR 0.152.
 */
package algorithm.animalTranslator.library;

import algorithm.animalTranslator.codeItems.DisplayOptions;
import algorithm.animalTranslator.codeItems.Node;
import algorithm.animalTranslator.codeItems.Timing;
import algorithm.fileHandler.FileHandler;

public abstract class Utilities {
    public FileHandler fh;

    void setFileHandler(FileHandler newFileHandler) {
        this.fh = newFileHandler;
    }

    String idp(String id, Node node) throws Exception {
        return String.valueOf(this.idString(id)) + this.nodeString(node);
    }

    String idString(String id) throws Exception {
        this.checkID(id);
        return " \"" + id + "\" ";
    }

    String asString(String toString) throws Exception {
        this.checkString(toString);
        return " \"" + toString + "\" ";
    }

    String nodeString(Node node) throws Exception {
        this.checkNode(node);
        return node.getString();
    }

    String timeString(DisplayOptions displayOptions) {
        if (displayOptions == null) {
            return "";
        }
        return displayOptions.getString();
    }

    String timingString(Timing timing) {
        if (timing == null) {
            return "";
        }
        return timing.getString();
    }

    String optionsString(String options) {
        if (options == null) {
            return "";
        }
        return " " + options + " ";
    }

    void checkID(String id) throws Exception {
        if (id == null || id == "") {
            throw new Exception("passed ID-String is null or empty");
        }
    }

    void checkNode(Node node) throws Exception {
        if (node == null) {
            throw new Exception("Node has to be given - null found");
        }
    }

    void checkString(String toCheck) throws Exception {
        if (toCheck == null) {
            throw new Exception("Checked String null - string required");
        }
        if (toCheck == "") {
            throw new Exception("Checked String empty - not allowed");
        }
    }

    String createArrayString(String[] theArray, int compareLength) throws Exception {
        String collect = " ";
        if (theArray == null) {
            throw new Exception("passed array is Null - not allowed");
        }
        if (theArray.length == 0) {
            throw new Exception("passed array has zero entries - entries required");
        }
        if (theArray.length != compareLength) {
            throw new Exception("passed arrays length is different from passed compareLength");
        }
        int i = 0;
        while (i < theArray.length) {
            if (theArray[i] == null) {
                throw new Exception("array-entry is null - you shouldn't do this");
            }
            collect = String.valueOf(collect) + "\"" + theArray[i] + "\" ";
            ++i;
        }
        return collect;
    }

    String createArrayString(String[] theArray) throws Exception {
        if (theArray == null) {
            throw new Exception("passed array is null - not allowed");
        }
        return this.createArrayString(theArray, theArray.length);
    }
}

