/*
 * Decompiled with CFR 0.152.
 */
package algorithm.animalTranslator.library;

import algorithm.animalTranslator.codeItems.DisplayOptions;
import algorithm.animalTranslator.codeItems.Node;
import algorithm.animalTranslator.codeItems.Pos;
import algorithm.animalTranslator.codeItems.TimeOffset;
import algorithm.animalTranslator.codeItems.Timing;
import algorithm.animalTranslator.library.Utilities;

public abstract class Library
extends Utilities {
    private int compositeStepsOpened = 0;

    public void prosaLine(String newLine) {
        this.fh.add(newLine);
    }

    public void prosaFragment(String newFragment) {
        this.fh.append(newFragment);
    }

    public void addHeader(String version, String title, String author) {
        this.addHeaderVersion(version);
        if (title != null) {
            this.addHeaderTitle(title);
        }
        if (author != null) {
            this.addHeaderAuthor(author);
        }
    }

    public void addHeaderTA(String title, String author) {
        this.addHeader("2.0", title, author);
    }

    public void addHeaderT(String title) {
        this.addHeader("2.0", title, null);
    }

    public void addHeaderA(String author) {
        this.addHeader("2.0", null, author);
    }

    private void addHeaderVersion(String version) {
        this.fh.add("%Animal " + version);
    }

    private void addHeaderTitle(String title) {
        this.fh.add("title \"" + title + "\"");
    }

    private void addHeaderAuthor(String author) {
        this.fh.add("author \"" + author + "\"");
    }

    public void addPoint(String id, Node node, String options, DisplayOptions displayOptions) {
        try {
            String txt = "point ";
            txt = String.valueOf(txt) + this.idp(id, node);
            txt = String.valueOf(txt) + this.optionsString(options);
            txt = String.valueOf(txt) + this.timeString(displayOptions);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void addSquare(String id, Node node, int width, String options, DisplayOptions displayOptions) {
        try {
            String txt = "square ";
            txt = String.valueOf(txt) + this.idp(id, node);
            txt = String.valueOf(txt) + " " + width + " ";
            txt = String.valueOf(txt) + this.optionsString(options);
            txt = String.valueOf(txt) + this.timeString(displayOptions);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void addRectangle(String id, Node node1, Node node2, String options, DisplayOptions displayOptions) {
        try {
            String txt = "rectangle ";
            txt = String.valueOf(txt) + this.idp(id, node1);
            this.checkNode(node2);
            txt = String.valueOf(txt) + node2.getString();
            txt = String.valueOf(txt) + this.optionsString(options);
            txt = String.valueOf(txt) + this.timeString(displayOptions);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void addRelRectangle(String id, Node node1, Pos node2, String options, DisplayOptions displayOptions) {
        try {
            String txt = "relrectangle ";
            txt = String.valueOf(txt) + this.idp(id, node1);
            this.checkNode(node2);
            txt = String.valueOf(txt) + node2.getString();
            txt = String.valueOf(txt) + this.optionsString(options);
            txt = String.valueOf(txt) + this.timeString(displayOptions);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void addTriangle(String id, Node node1, Node node2, Node node3, String options, DisplayOptions displayOptions) {
        try {
            String txt = "triangle ";
            txt = String.valueOf(txt) + this.idp(id, node1);
            this.checkNode(node2);
            txt = String.valueOf(txt) + node2.getString();
            this.checkNode(node3);
            txt = String.valueOf(txt) + node3.getString();
            txt = String.valueOf(txt) + this.optionsString(options);
            txt = String.valueOf(txt) + this.timeString(displayOptions);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void addPolygon(String id, Node node1, Node node2, Node[] otherNodes, String options, DisplayOptions displayOptions) {
        try {
            String txt = "polygon ";
            txt = String.valueOf(txt) + this.idp(id, node1);
            this.checkNode(node2);
            txt = String.valueOf(txt) + node2.getString();
            txt = String.valueOf(txt) + Node.getArrayString(otherNodes);
            txt = String.valueOf(txt) + this.optionsString(options);
            txt = String.valueOf(txt) + this.timeString(displayOptions);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void addText(String id, String content, Node node, String options, DisplayOptions displayOptions) {
        try {
            String txt = "text ";
            txt = String.valueOf(txt) + this.idString(id);
            txt = String.valueOf(txt) + " \"" + content + "\" ";
            txt = String.valueOf(txt) + this.nodeString(node);
            txt = String.valueOf(txt) + this.optionsString(options);
            txt = String.valueOf(txt) + this.timeString(displayOptions);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void addArray(String id, Node node, String options1, int length, String[] content, String options2, TimeOffset timeOffset, String options3) {
        try {
            String txt = "array ";
            txt = String.valueOf(txt) + this.idp(id, node);
            txt = String.valueOf(txt) + this.optionsString(options1);
            txt = String.valueOf(txt) + "length " + length;
            txt = String.valueOf(txt) + this.createArrayString(content, length);
            txt = String.valueOf(txt) + this.optionsString(options2);
            txt = String.valueOf(txt) + this.timeString(timeOffset);
            txt = String.valueOf(txt) + this.optionsString(options3);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void addField(String id, Node node, String options1, int length, String[] content, String options2, TimeOffset timeOffset, String options3) {
        this.addArray(id, node, options1, length, content, options2, timeOffset, options3);
    }

    public void addArray(String id, Node node, String options1, int length, int[] content, String options2, TimeOffset timeOffset, String options3) {
        String[] sArray = new String[content.length];
        int i = 0;
        while (i < content.length) {
            sArray[i] = Integer.toString(content[i]);
            ++i;
        }
        this.addArray(id, node, options1, length, sArray, options2, timeOffset, options3);
    }

    public void addArray(String id, Node node, String options1, int length, String content, String options2, TimeOffset timeOffset, String options3) {
        String[] sArray = new String[content.length()];
        int i = 0;
        while (i < content.length()) {
            sArray[i] = content.substring(i, i + 1);
            ++i;
        }
        this.addArray(id, node, options1, length, sArray, options2, timeOffset, options3);
    }

    public void addField(String id, Node node, String options1, int length, int[] content, String options2, TimeOffset timeOffset, String options3) {
        this.addArray(id, node, options1, length, content, options2, timeOffset, options3);
    }

    public void addArrayMarker(String markerID, String arrayID, int atIndex, String options, DisplayOptions displayOptions) {
        String txt = "arrayMarker ";
        if (markerID != null) {
            // empty if block
        }
        txt = String.valueOf(txt) + " \"" + markerID + "\" on ";
        txt = String.valueOf(txt) + "\"" + arrayID + "\" atIndex " + atIndex + " ";
        txt = String.valueOf(txt) + this.optionsString(options);
        txt = String.valueOf(txt) + this.timeString(displayOptions);
        this.fh.add(txt);
    }

    public void addArrayPointer(String markerID, String arrayID, int atIndex, String options, DisplayOptions displayOptions) {
        this.addArrayMarker(markerID, arrayID, atIndex, options, displayOptions);
    }

    public void addArrayIndex(String markerID, String arrayID, int atIndex, String options, DisplayOptions displayOptions) {
        this.addArrayMarker(markerID, arrayID, atIndex, options, displayOptions);
    }

    public void arrayPut(String value, String arrayName, int targetPos, Timing timing) {
        try {
            String txt = "arrayPut ";
            this.checkString(value);
            this.checkString(arrayName);
            txt = String.valueOf(txt) + "\"" + value + "\" on \"" + arrayName + "\" position " + targetPos + " ";
            txt = String.valueOf(txt) + this.timingString(timing);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void arraySwap(String arrayName, int pos1, int pos2, Timing timing) {
        try {
            String txt = "arraySwap on ";
            this.checkString(arrayName);
            txt = String.valueOf(txt) + "\"" + arrayName + "\" position " + pos1 + " with " + pos2 + " ";
            txt = String.valueOf(txt) + this.timingString(timing);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void moveArrayMarker(String markerID, int toPos, Timing timing) {
        try {
            String txt = "moveArrayMarker ";
            this.checkString(markerID);
            txt = String.valueOf(txt) + "\"" + markerID + "\" to position " + toPos + " ";
            txt = String.valueOf(txt) + this.timingString(timing);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void moveArrayIndex(String markerID, int toPos, Timing timing) {
        this.moveArrayMarker(markerID, toPos, timing);
    }

    public void moveArrayPointer(String markerID, int toPos, Timing timing) {
        this.moveArrayMarker(markerID, toPos, timing);
    }

    public void moveIndex(String markerID, int toPos, Timing timing) {
        this.moveArrayMarker(markerID, toPos, timing);
    }

    public void moveMarker(String markerID, int toPos, Timing timing) {
        this.moveArrayMarker(markerID, toPos, timing);
    }

    public void movePointer(String markerID, int toPos, Timing timing) {
        this.moveArrayMarker(markerID, toPos, timing);
    }

    public void jumpArrayIndex(String markerID, int toPos, Timing timing) {
        this.moveArrayMarker(markerID, toPos, (Timing)new TimeOffset(0));
    }

    public void jumpArrayMarker(String markerID, int toPos, Timing timing) {
        this.moveArrayMarker(markerID, toPos, (Timing)new TimeOffset(0));
    }

    public void jumpArrayPointer(String markerID, int toPos, Timing timing) {
        this.moveArrayMarker(markerID, toPos, (Timing)new TimeOffset(0));
    }

    public void jumpIndex(String markerID, int toPos, Timing timing) {
        this.moveArrayMarker(markerID, toPos, (Timing)new TimeOffset(0));
    }

    public void jumpMarker(String markerID, int toPos, Timing timing) {
        this.moveArrayMarker(markerID, toPos, (Timing)new TimeOffset(0));
    }

    public void jumpPointer(String markerID, int toPos, Timing timing) {
        this.moveArrayMarker(markerID, toPos, (Timing)new TimeOffset(0));
    }

    public void moveArrayMarker(String markerID, String toPlace, Timing timing) {
        try {
            String txt = "moveArrayMarker ";
            this.checkString(markerID);
            txt = String.valueOf(txt) + "\"" + markerID + "\" to " + toPlace + " ";
            txt = String.valueOf(txt) + this.timingString(timing);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void moveArrayIndex(String markerID, String toPlace, Timing timing) {
        this.moveArrayMarker(markerID, toPlace, timing);
    }

    public void moveArrayPointer(String markerID, String toPlace, Timing timing) {
        this.moveArrayMarker(markerID, toPlace, timing);
    }

    public void moveIndex(String markerID, String toPlace, Timing timing) {
        this.moveArrayMarker(markerID, toPlace, timing);
    }

    public void moveMarker(String markerID, String toPlace, Timing timing) {
        this.moveArrayMarker(markerID, toPlace, timing);
    }

    public void movePointer(String markerID, String toPlace, Timing timing) {
        this.moveArrayMarker(markerID, toPlace, timing);
    }

    public void jumpArrayIndex(String markerID, String toPlace, Timing timing) {
        this.moveArrayMarker(markerID, toPlace, (Timing)new TimeOffset(0));
    }

    public void jumpArrayMarker(String markerID, String toPlace, Timing timing) {
        this.moveArrayMarker(markerID, toPlace, (Timing)new TimeOffset(0));
    }

    public void jumpArrayPointer(String markerID, String toPlace, Timing timing) {
        this.moveArrayMarker(markerID, toPlace, (Timing)new TimeOffset(0));
    }

    public void jumpIndex(String markerID, String toPlace, Timing timing) {
        this.moveArrayMarker(markerID, toPlace, (Timing)new TimeOffset(0));
    }

    public void jumpMarker(String markerID, String toPlace, Timing timing) {
        this.moveArrayMarker(markerID, toPlace, (Timing)new TimeOffset(0));
    }

    public void jumpPointer(String markerID, String toPlace, Timing timing) {
        this.moveArrayMarker(markerID, toPlace, (Timing)new TimeOffset(0));
    }

    public void colorChange(String[] oIDs, String options, String colorName, Timing timing) {
        try {
            String txt = "color ";
            txt = String.valueOf(txt) + this.createArrayString(oIDs);
            txt = String.valueOf(txt) + this.optionsString(options);
            this.checkString(colorName);
            txt = String.valueOf(txt) + this.optionsString(colorName);
            txt = String.valueOf(txt) + this.timingString(timing);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void delay(int msDelay) {
        this.fh.add("delay " + msDelay + " ms ");
    }

    public void compositeStepStart() {
        ++this.compositeStepsOpened;
        if (this.compositeStepsOpened == 1) {
            this.fh.add("{");
        }
    }

    public void compositeStepEnd() {
        if (this.compositeStepsOpened > 0) {
            --this.compositeStepsOpened;
        }
        if (this.compositeStepsOpened == 0) {
            this.fh.add("}");
        }
    }

    public void cSS() {
        this.compositeStepStart();
    }

    public void cSE() {
        this.compositeStepEnd();
    }

    public void comment(String theComment) {
        this.fh.add("# " + theComment);
    }

    public void addCodeGroup(String id, Node node, String options, TimeOffset timeOffset) {
        try {
            String txt = "codegroup ";
            txt = String.valueOf(txt) + this.idp(id, node);
            txt = String.valueOf(txt) + this.optionsString(options);
            txt = String.valueOf(txt) + this.timeString(timeOffset);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void addCodeLine(String theCode, String id, String codeGroupID, int indentation, TimeOffset timeOffset) {
        try {
            String txt = "addCodeLine ";
            txt = String.valueOf(txt) + this.asString(theCode);
            if (id != null) {
                txt = String.valueOf(txt) + " name " + this.idString(id);
            }
            txt = String.valueOf(txt) + " to " + this.asString(codeGroupID) + " indentation " + indentation + " ";
            txt = String.valueOf(txt) + this.timeString(timeOffset);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void addCodeElem(String theCode, String id, String codeGroupID, int positionInRow, int indentation, TimeOffset timeOffset) {
        try {
            String txt = "addCodeElem ";
            txt = String.valueOf(txt) + this.asString(theCode);
            if (id != null) {
                txt = String.valueOf(txt) + " name " + this.idString(id);
            }
            txt = String.valueOf(txt) + " to " + this.asString(codeGroupID) + "\" row " + positionInRow + " indentation " + indentation + " ";
            txt = String.valueOf(txt) + this.timeString(timeOffset);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void addCodeElem(String theCode, String id, String codeGroupID, int indentation, TimeOffset timeOffset) {
        try {
            String txt = "addCodeElem ";
            txt = String.valueOf(txt) + this.asString(theCode);
            if (id != null) {
                txt = String.valueOf(txt) + " name " + this.idString(id);
            }
            txt = String.valueOf(txt) + " to " + this.asString(codeGroupID) + " indentation " + indentation + " ";
            txt = String.valueOf(txt) + this.timeString(timeOffset);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void codeHide(String id, TimeOffset timeOffset) {
        try {
            String txt = "hideCode ";
            txt = String.valueOf(txt) + this.idString(id);
            txt = String.valueOf(txt) + this.timeString(timeOffset);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void hideCode(String id, TimeOffset timeOffset) {
        this.codeHide(id, timeOffset);
    }

    public void hide(String id, TimeOffset timeOffset) {
        try {
            String txt = "hide ";
            txt = String.valueOf(txt) + this.idString(id);
            txt = String.valueOf(txt) + this.timeString(timeOffset);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void hide(String[] ids, TimeOffset timeOffset) {
        try {
            String txt = "hide ";
            txt = String.valueOf(txt) + this.createArrayString(ids);
            txt = String.valueOf(txt) + this.timeString(timeOffset);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void show(String id, TimeOffset timeOffset) {
        try {
            String txt = "show ";
            txt = String.valueOf(txt) + this.idString(id);
            txt = String.valueOf(txt) + this.timeString(timeOffset);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void show(String[] ids, TimeOffset timeOffset) {
        try {
            String txt = "show ";
            txt = String.valueOf(txt) + this.createArrayString(ids);
            txt = String.valueOf(txt) + this.timeString(timeOffset);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void addLabel(String labelEntry) {
        try {
            String txt = "label ";
            txt = String.valueOf(txt) + this.asString(labelEntry);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void echoLocation(Node node) {
        try {
            String txt = "echo location : ";
            txt = String.valueOf(txt) + this.nodeString(node);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void echoBoundingBox(String[] ids) {
        try {
            String txt = "echo boundingBox : ";
            txt = String.valueOf(txt) + this.createArrayString(ids);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void echoBounds(String[] ids) {
        this.echoBoundingBox(ids);
    }

    public void echoText(String textToEcho) {
        try {
            String txt = "echo text : ";
            txt = String.valueOf(txt) + this.asString(textToEcho);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void echo(String textToEcho) {
        this.echoText(textToEcho);
    }

    public void swap(String oID1, String oID2) {
        try {
            String txt = "swap ";
            txt = String.valueOf(txt) + this.asString(oID1) + this.asString(oID2);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void exchange(String oID1, String oID2) {
        this.swap(oID1, oID2);
    }

    public void highlightArrayElem(String arrayID, int position, String options, Timing timing) {
        try {
            String txt = "highlightArrayElem on ";
            txt = String.valueOf(txt) + this.idString(arrayID) + " position " + position + " ";
            txt = String.valueOf(txt) + this.optionsString(options);
            txt = String.valueOf(txt) + this.timingString(timing);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void highlightArrayCell(String arrayID, int position, String options, Timing timing) {
        try {
            String txt = "highlightArrayCell on ";
            txt = String.valueOf(txt) + this.idString(arrayID) + " position " + position + " ";
            txt = String.valueOf(txt) + this.optionsString(options);
            txt = String.valueOf(txt) + this.timingString(timing);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void unhighlightArrayElem(String arrayID, int position, String options, Timing timing) {
        try {
            String txt = "unhighlightArrayElem on ";
            txt = String.valueOf(txt) + this.idString(arrayID) + " position " + position + " ";
            txt = String.valueOf(txt) + this.optionsString(options);
            txt = String.valueOf(txt) + this.timingString(timing);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void unhighlightArrayCell(String arrayID, int position, String options, Timing timing) {
        try {
            String txt = "unhighlightArrayCell on ";
            txt = String.valueOf(txt) + this.idString(arrayID) + " position " + position + " ";
            txt = String.valueOf(txt) + this.optionsString(options);
            txt = String.valueOf(txt) + this.timingString(timing);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void highlightCode(String baseCodeGroup, int lineNr, String options, Timing timing) {
        try {
            String txt = "highlightCode on ";
            txt = String.valueOf(txt) + this.idString(baseCodeGroup) + " line " + lineNr + " ";
            txt = String.valueOf(txt) + this.optionsString(options);
            txt = String.valueOf(txt) + this.timingString(timing);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    public void unhighlightCode(String baseCodeGroup, int lineNr, String options, Timing timing) {
        try {
            String txt = "unhighlightCode on ";
            txt = String.valueOf(txt) + this.idString(baseCodeGroup) + " line " + lineNr + " ";
            txt = String.valueOf(txt) + this.optionsString(options);
            txt = String.valueOf(txt) + this.timingString(timing);
            this.fh.add(txt);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }
}

