/*
 * Decompiled with CFR 0.152.
 */
package algoanim.properties.items;

import algoanim.properties.Visitable;
import algoanim.properties.Visitor;
import algoanim.properties.items.AnimationPropertyItem;

public class IntegerPropertyItem
extends AnimationPropertyItem
implements Visitable {
    private int iValue = 1;
    private int min = 0;
    private int max = Integer.MAX_VALUE;

    public IntegerPropertyItem() {
    }

    public IntegerPropertyItem(int defValue) {
        this.iValue = defValue;
    }

    public IntegerPropertyItem(int defValue, int minValue, int maxValue) {
        this.iValue = defValue;
        this.min = minValue;
        this.max = maxValue;
    }

    @Override
    public Object get() {
        return new Integer(this.iValue);
    }

    @Override
    public boolean set(int value) throws IllegalArgumentException {
        if (this.iValue >= this.min && this.iValue <= this.max) {
            this.iValue = value;
            return true;
        }
        throw new IllegalArgumentException("Integer value out of bounds");
    }

    @Override
    public Object clone() {
        IntegerPropertyItem ret = new IntegerPropertyItem(this.iValue, this.min, this.max);
        return ret;
    }

    @Override
    public void accept(Visitor v) {
        if (v != null) {
            v.visit(this);
        }
    }
}

