/*
 * Decompiled with CFR 0.152.
 */
package algoanim.primitives.generators;

import algoanim.exceptions.NotEnoughNodesException;
import algoanim.interactionsupport.DocumentationLink;
import algoanim.interactionsupport.FillInBlanksQuestion;
import algoanim.interactionsupport.GroupInfo;
import algoanim.interactionsupport.InteractiveElement;
import algoanim.interactionsupport.MultipleChoiceQuestion;
import algoanim.interactionsupport.MultipleSelectionQuestion;
import algoanim.interactionsupport.TrueFalseQuestion;
import algoanim.primitives.Arc;
import algoanim.primitives.ArrayBasedQueue;
import algoanim.primitives.ArrayBasedStack;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.ArrayPrimitive;
import algoanim.primitives.Circle;
import algoanim.primitives.CircleSeg;
import algoanim.primitives.ConceptualQueue;
import algoanim.primitives.ConceptualStack;
import algoanim.primitives.DoubleArray;
import algoanim.primitives.Ellipse;
import algoanim.primitives.EllipseSeg;
import algoanim.primitives.Graph;
import algoanim.primitives.Group;
import algoanim.primitives.IntArray;
import algoanim.primitives.IntMatrix;
import algoanim.primitives.ListBasedQueue;
import algoanim.primitives.ListBasedStack;
import algoanim.primitives.ListElement;
import algoanim.primitives.Point;
import algoanim.primitives.Polygon;
import algoanim.primitives.Polyline;
import algoanim.primitives.Primitive;
import algoanim.primitives.Rect;
import algoanim.primitives.SourceCode;
import algoanim.primitives.Square;
import algoanim.primitives.StringArray;
import algoanim.primitives.StringMatrix;
import algoanim.primitives.Text;
import algoanim.primitives.Triangle;
import algoanim.primitives.Variables;
import algoanim.properties.ArcProperties;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.properties.ArrayProperties;
import algoanim.properties.CircleProperties;
import algoanim.properties.CircleSegProperties;
import algoanim.properties.EllipseProperties;
import algoanim.properties.EllipseSegProperties;
import algoanim.properties.GraphProperties;
import algoanim.properties.ListElementProperties;
import algoanim.properties.MatrixProperties;
import algoanim.properties.PointProperties;
import algoanim.properties.PolygonProperties;
import algoanim.properties.PolylineProperties;
import algoanim.properties.QueueProperties;
import algoanim.properties.RectProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.SquareProperties;
import algoanim.properties.StackProperties;
import algoanim.properties.TextProperties;
import algoanim.properties.TriangleProperties;
import algoanim.util.ArrayDisplayOptions;
import algoanim.util.DisplayOptions;
import algoanim.util.Node;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public abstract class Language {
    public static final int INTERACTION_TYPE_NONE = 128;
    public static final int INTERACTION_TYPE_JHAVE_TEXT = 256;
    public static final int INTERACTION_TYPE_JHAVE_XML = 512;
    public static final int INTERACTION_TYPE_AVINTERACTION = 1024;
    public static final int UNDEFINED_SIZE = 0;
    public HashMap<String, InteractiveElement> interactiveElements = new HashMap(89);

    public Language(String title, String author, int x, int y) {
    }

    public abstract void addLine(StringBuilder var1);

    public void addLine(String line) {
        this.addLine(new StringBuilder(line));
    }

    public abstract void addError(StringBuilder var1);

    public void addError(String error) {
        this.addError(new StringBuilder(error));
    }

    public abstract void addItem(Primitive var1);

    public abstract void writeFile(String var1);

    public abstract void finalizeGeneration();

    public abstract String getAnimationCode();

    public abstract boolean isNameUsed(String var1);

    public abstract Vector<String> validDirections();

    public abstract boolean isValidDirection(String var1);

    public abstract void setStepMode(boolean var1);

    public void nextStep() {
        this.nextStep(-1, null);
    }

    public void nextStep(int delay) {
        this.nextStep(delay, null);
    }

    public void nextStep(String label) {
        this.nextStep(-1, label);
    }

    public abstract void nextStep(int var1, String var2);

    public abstract Point newPoint(Node var1, String var2, DisplayOptions var3, PointProperties var4);

    public Arc newArc(Node center, Node radius, String name, DisplayOptions display) {
        return this.newArc(center, radius, name, display, new ArcProperties());
    }

    public abstract Arc newArc(Node var1, Node var2, String var3, DisplayOptions var4, ArcProperties var5);

    public Circle newCircle(Node center, int radius, String name, DisplayOptions display) {
        return this.newCircle(center, radius, name, display, new CircleProperties());
    }

    public abstract Circle newCircle(Node var1, int var2, String var3, DisplayOptions var4, CircleProperties var5);

    public abstract CircleSeg newCircleSeg(Node var1, int var2, String var3, DisplayOptions var4, CircleSegProperties var5);

    public EllipseSeg newEllipseSeg(Node center, Node radius, String name, DisplayOptions display) {
        return this.newEllipseSeg(center, radius, name, display, new EllipseSegProperties());
    }

    public abstract EllipseSeg newEllipseSeg(Node var1, Node var2, String var3, DisplayOptions var4, EllipseSegProperties var5);

    public abstract Ellipse newEllipse(Node var1, Node var2, String var3, DisplayOptions var4, EllipseProperties var5);

    public Ellipse newEllipse(Node center, Node radius, String name, DisplayOptions display) {
        return this.newEllipse(center, radius, name, display, new EllipseProperties());
    }

    public CircleSeg newCircleSeg(Node center, int radius, String name, DisplayOptions display) {
        return this.newCircleSeg(center, radius, name, display, new CircleSegProperties());
    }

    public abstract Graph newGraph(String var1, int[][] var2, Node[] var3, String[] var4, DisplayOptions var5, GraphProperties var6);

    public Graph newGraph(String name, int[][] graphAdjacencyMatrix, Node[] graphNodes, String[] labels, DisplayOptions display) {
        return this.newGraph(name, graphAdjacencyMatrix, graphNodes, labels, display, new GraphProperties());
    }

    public abstract Polyline newPolyline(Node[] var1, String var2, DisplayOptions var3, PolylineProperties var4);

    public Polyline newPolyline(Node[] vertices, String name, DisplayOptions display) {
        return this.newPolyline(vertices, name, display, new PolylineProperties());
    }

    public abstract Polygon newPolygon(Node[] var1, String var2, DisplayOptions var3, PolygonProperties var4) throws NotEnoughNodesException;

    public Polygon newPolygon(Node[] vertices, String name, DisplayOptions display) throws NotEnoughNodesException {
        return this.newPolygon(vertices, name, display, new PolygonProperties());
    }

    public abstract Rect newRect(Node var1, Node var2, String var3, DisplayOptions var4, RectProperties var5);

    public Rect newRect(Node upperLeft, Node lowerRight, String name, DisplayOptions display) {
        return this.newRect(upperLeft, lowerRight, name, display, new RectProperties());
    }

    public abstract Square newSquare(Node var1, int var2, String var3, DisplayOptions var4, SquareProperties var5);

    public Square newSquare(Node upperLeft, int width, String name, DisplayOptions display) {
        return this.newSquare(upperLeft, width, name, display, new SquareProperties());
    }

    public abstract Triangle newTriangle(Node var1, Node var2, Node var3, String var4, DisplayOptions var5, TriangleProperties var6);

    public abstract Variables newVariables();

    public Triangle newTriangle(Node x, Node y, Node z, String name, DisplayOptions display) {
        return this.newTriangle(x, y, z, name, display, new TriangleProperties());
    }

    public abstract DoubleArray newDoubleArray(Node var1, double[] var2, String var3, ArrayDisplayOptions var4, ArrayProperties var5);

    public DoubleArray newDoubleArray(Node upperLeft, double[] data, String name, ArrayDisplayOptions display) {
        return this.newDoubleArray(upperLeft, data, name, display, new ArrayProperties());
    }

    public abstract IntArray newIntArray(Node var1, int[] var2, String var3, ArrayDisplayOptions var4, ArrayProperties var5);

    public IntArray newIntArray(Node upperLeft, int[] data, String name, ArrayDisplayOptions display) {
        return this.newIntArray(upperLeft, data, name, display, new ArrayProperties());
    }

    public abstract IntMatrix newIntMatrix(Node var1, int[][] var2, String var3, DisplayOptions var4, MatrixProperties var5);

    public IntMatrix newIntMatrix(Node upperLeft, int[][] data, String name, DisplayOptions display) {
        return this.newIntMatrix(upperLeft, data, name, display, new MatrixProperties());
    }

    public abstract StringArray newStringArray(Node var1, String[] var2, String var3, ArrayDisplayOptions var4, ArrayProperties var5);

    public StringArray newStringArray(Node upperLeft, String[] data, String name, ArrayDisplayOptions display) {
        return this.newStringArray(upperLeft, data, name, display, new ArrayProperties());
    }

    public abstract StringMatrix newStringMatrix(Node var1, String[][] var2, String var3, DisplayOptions var4, MatrixProperties var5);

    public StringMatrix newStringMatrix(Node upperLeft, String[][] data, String name, DisplayOptions display) {
        return this.newStringMatrix(upperLeft, data, name, display, new MatrixProperties());
    }

    public abstract ArrayMarker newArrayMarker(ArrayPrimitive var1, int var2, String var3, DisplayOptions var4, ArrayMarkerProperties var5);

    public ArrayMarker newArrayMarker(ArrayPrimitive a, int index, String name, DisplayOptions display) {
        return this.newArrayMarker(a, index, name, display, new ArrayMarkerProperties());
    }

    public abstract ListElement newListElement(Node var1, int var2, LinkedList<Object> var3, ListElement var4, ListElement var5, String var6, DisplayOptions var7, ListElementProperties var8);

    public ListElement newListElement(Node upperLeft, int pointers, LinkedList<Object> ptrLocations, ListElement prev, String name, DisplayOptions display, ListElementProperties lp) {
        return this.newListElement(upperLeft, pointers, ptrLocations, prev, null, name, display, lp);
    }

    public ListElement newListElement(Node upperLeft, int pointers, LinkedList<Object> ptrLocations, ListElement prev, String name, DisplayOptions display) {
        return this.newListElement(upperLeft, pointers, ptrLocations, prev, null, name, display, new ListElementProperties());
    }

    public abstract SourceCode newSourceCode(Node var1, String var2, DisplayOptions var3, SourceCodeProperties var4);

    public SourceCode newSourceCode(Node upperLeft, String name, DisplayOptions display) {
        return this.newSourceCode(upperLeft, name, display, new SourceCodeProperties());
    }

    public abstract Text newText(Node var1, String var2, String var3, DisplayOptions var4, TextProperties var5);

    public Text newText(Node upperLeft, String text, String name, DisplayOptions display) {
        Text aText = this.newText(upperLeft, text, name, display, new TextProperties());
        return aText;
    }

    public abstract <T> ConceptualStack<T> newConceptualStack(Node var1, List<T> var2, String var3, DisplayOptions var4, StackProperties var5);

    public <T> ConceptualStack<T> newConceptualStack(Node upperLeft, List<T> content, String name, DisplayOptions display) {
        return this.newConceptualStack(upperLeft, content, name, display, new StackProperties());
    }

    public abstract <T> ArrayBasedStack<T> newArrayBasedStack(Node var1, List<T> var2, String var3, DisplayOptions var4, StackProperties var5, int var6);

    public <T> ArrayBasedStack<T> newArrayBasedStack(Node upperLeft, List<T> content, String name, DisplayOptions display, int capacity) {
        return this.newArrayBasedStack(upperLeft, content, name, display, new StackProperties(), capacity);
    }

    public abstract <T> ListBasedStack<T> newListBasedStack(Node var1, List<T> var2, String var3, DisplayOptions var4, StackProperties var5);

    public <T> ListBasedStack<T> newListBasedStack(Node upperLeft, List<T> content, String name, DisplayOptions display) {
        return this.newListBasedStack(upperLeft, content, name, display, new StackProperties());
    }

    public abstract <T> ConceptualQueue<T> newConceptualQueue(Node var1, List<T> var2, String var3, DisplayOptions var4, QueueProperties var5);

    public <T> ConceptualQueue<T> newConceptualQueue(Node upperLeft, List<T> content, String name, DisplayOptions display) {
        return this.newConceptualQueue(upperLeft, content, name, display, new QueueProperties());
    }

    public abstract <T> ArrayBasedQueue<T> newArrayBasedQueue(Node var1, List<T> var2, String var3, DisplayOptions var4, QueueProperties var5, int var6);

    public <T> ArrayBasedQueue<T> newArrayBasedQueue(Node upperLeft, List<T> content, String name, DisplayOptions display, int capacity) {
        return this.newArrayBasedQueue(upperLeft, content, name, display, new QueueProperties(), capacity);
    }

    public abstract <T> ListBasedQueue<T> newListBasedQueue(Node var1, List<T> var2, String var3, DisplayOptions var4, QueueProperties var5);

    public <T> ListBasedQueue<T> newListBasedQueue(Node upperLeft, List<T> content, String name, DisplayOptions display) {
        return this.newListBasedQueue(upperLeft, content, name, display, new QueueProperties());
    }

    public abstract Group newGroup(LinkedList<Primitive> var1, String var2);

    public abstract void addDocumentationLink(DocumentationLink var1);

    public abstract void addTFQuestion(TrueFalseQuestion var1);

    public abstract void addFIBQuestion(FillInBlanksQuestion var1);

    public abstract void addMCQuestion(MultipleChoiceQuestion var1);

    public abstract void addMSQuestion(MultipleSelectionQuestion var1);

    public abstract void addQuestionGroup(GroupInfo var1);

    public abstract void setInteractionType(int var1);
}

