/*
 * Decompiled with CFR 0.152.
 */
package algoanim.primitives;

import algoanim.primitives.Primitive;
import algoanim.primitives.generators.ListElementGenerator;
import algoanim.properties.ListElementProperties;
import algoanim.util.DisplayOptions;
import algoanim.util.Node;
import algoanim.util.Timing;
import java.util.LinkedList;

public class ListElement
extends Primitive {
    private ListElementProperties properties;
    private ListElementGenerator generator = null;
    private ListElement prev;
    private ListElement next;
    private Node upperLeft;
    private int pointers;
    private LinkedList<Object> ptrLocations;

    public ListElement(ListElementGenerator leg, Node upperLeftCorner, int nrPointers, LinkedList<Object> pointerLocations, ListElement prevElement, String name, DisplayOptions display, ListElementProperties lp) {
        this(leg, upperLeftCorner, nrPointers, pointerLocations, prevElement, null, name, display, lp);
    }

    public ListElement(ListElementGenerator leg, Node upperLeftCorner, int nrPointers, LinkedList<Object> pointerLocations, ListElement prevElement, ListElement nextElement, String name, DisplayOptions display, ListElementProperties lp) {
        super(leg, display);
        this.properties = lp;
        this.upperLeft = upperLeftCorner;
        this.prev = prevElement;
        this.next = nextElement;
        this.setPointers(nrPointers);
        this.generator = leg;
        this.ptrLocations = pointerLocations;
        this.setName(name);
        this.generator.create(this);
    }

    private void setPointers(int nrPointers) {
        this.pointers = nrPointers >= 0 && nrPointers < 256 ? nrPointers : 0;
    }

    public int getPointers() {
        return this.pointers;
    }

    public void setPointerLocations(LinkedList<Object> pointerLocations) {
        this.ptrLocations = pointerLocations;
    }

    public LinkedList<Object> getPointerLocations() {
        return this.ptrLocations;
    }

    public ListElementProperties getProperties() {
        return this.properties;
    }

    public Node getUpperLeft() {
        return this.upperLeft;
    }

    public ListElement getPrev() {
        return this.prev;
    }

    public ListElement getNext() {
        return this.next;
    }

    public void link(ListElement target, int linkno, Timing offset, Timing duration) {
        if (linkno <= this.pointers && linkno >= 0) {
            this.generator.link(this, target, linkno, offset, duration);
        }
    }

    public void unlink(int linkno, Timing offset, Timing duration) {
        if (linkno <= this.pointers && linkno >= 0) {
            this.generator.unlink(this, linkno, offset, duration);
        }
    }

    @Override
    public void setName(String newName) {
        this.properties.setName(newName);
        super.setName(newName);
    }
}

