/*
 * Decompiled with CFR 0.152.
 */
package algoanim.primitives;

import algoanim.primitives.ArrayPrimitive;
import algoanim.primitives.generators.DoubleArrayGenerator;
import algoanim.properties.ArrayProperties;
import algoanim.util.ArrayDisplayOptions;
import algoanim.util.Node;
import algoanim.util.Timing;

public class DoubleArray
extends ArrayPrimitive {
    private double[] data;
    protected DoubleArrayGenerator generator;
    private ArrayProperties properties = null;
    private Node upperLeft = null;

    public DoubleArray(DoubleArrayGenerator dag, Node upperLeftCorner, double[] arrayData, String name, ArrayDisplayOptions display, ArrayProperties iap) {
        super(dag, display);
        if (upperLeftCorner == null) {
            throw new IllegalArgumentException("The coordinate of the upper left Node shouldn't be null!");
        }
        this.upperLeft = upperLeftCorner;
        this.length = arrayData.length;
        this.data = arrayData;
        this.properties = iap;
        this.setName(name);
        this.generator = dag;
        this.generator.create(this);
    }

    public void put(int where, double what, Timing t, Timing d) throws IndexOutOfBoundsException {
        if (where >= this.data.length || where < 0) {
            throw new IndexOutOfBoundsException("Array has min Size 0 and max Size " + this.data.length);
        }
        this.data[where] = what;
        this.generator.put(this, where, what, t, d);
    }

    @Override
    public void swap(int what, int with, Timing t, Timing d) throws IndexOutOfBoundsException {
        if (what >= this.data.length || what < 0 || with >= this.data.length || with < 0) {
            throw new IndexOutOfBoundsException("Array has min Size 0 and max Size " + this.data.length);
        }
        double tmp = this.data[what];
        this.data[what] = this.data[with];
        this.data[with] = tmp;
        this.generator.swap(this, what, with, t, d);
    }

    public double[] getData() {
        return this.data;
    }

    public double getData(int i) throws IndexOutOfBoundsException {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException("Array has indices [0, " + (this.data.length - 1) + "]; you tried to access #" + i);
        }
        return this.data[i];
    }

    public Node getUpperLeft() {
        return this.upperLeft;
    }

    public ArrayProperties getProperties() {
        return this.properties;
    }

    @Override
    public void setName(String newName) {
        this.properties.setName(newName);
        super.setName(newName);
    }

    public void highlightCell(int position, Timing offset, Timing duration) {
        if (position >= 0 && position < this.getLength()) {
            this.generator.highlightCell(this, position, offset, duration);
        }
    }

    public void highlightCell(int from, int to, Timing offset, Timing duration) {
        if (from <= to && from >= 0 && from < this.getLength() && to >= 0 && to < this.getLength()) {
            this.generator.highlightCell(this, from, to, offset, duration);
        }
    }

    public void unhighlightCell(int position, Timing offset, Timing duration) {
        if (position >= 0 && position < this.getLength()) {
            this.generator.unhighlightCell(this, position, offset, duration);
        }
    }

    public void unhighlightCell(int from, int to, Timing offset, Timing duration) {
        if (from <= to && from >= 0 && from < this.getLength() && to >= 0 && to < this.getLength()) {
            this.generator.unhighlightCell(this, from, to, offset, duration);
        }
    }

    public void highlightElem(int position, Timing offset, Timing duration) {
        if (position >= 0 && position < this.getLength()) {
            this.generator.highlightElem(this, position, offset, duration);
        }
    }

    public void highlightElem(int from, int to, Timing offset, Timing duration) {
        if (from <= to && from >= 0 && from < this.getLength() && to >= 0 && to < this.getLength()) {
            this.generator.highlightElem(this, from, to, offset, duration);
        }
    }

    public void unhighlightElem(int position, Timing offset, Timing duration) {
        if (position >= 0 && position < this.getLength()) {
            this.generator.unhighlightElem(this, position, offset, duration);
        }
    }

    public void unhighlightElem(int from, int to, Timing offset, Timing duration) {
        if (from <= to && from >= 0 && from < this.getLength() && to >= 0 && to < this.getLength()) {
            this.generator.unhighlightElem(this, from, to, offset, duration);
        }
    }
}

