/*
 * Decompiled with CFR 0.152.
 */
package algoanim.primitives;

import algoanim.primitives.VisualStack;
import algoanim.primitives.generators.ArrayBasedStackGenerator;
import algoanim.properties.StackProperties;
import algoanim.util.DisplayOptions;
import algoanim.util.Node;
import algoanim.util.Timing;
import java.util.EmptyStackException;
import java.util.List;

public class ArrayBasedStack<T>
extends VisualStack<T> {
    private int capacity;
    private int elemCount;
    private ArrayBasedStackGenerator<T> generator;

    public ArrayBasedStack(ArrayBasedStackGenerator<T> absg, Node upperLeftCorner, List<T> content, String name, DisplayOptions display, StackProperties sp, int capacity) {
        super(absg, upperLeftCorner, content, name, display, sp);
        this.generator = absg;
        if (capacity < 0) {
            throw new IllegalArgumentException("The capacity of the ArrayBasedStack must be nonnegative!");
        }
        this.capacity = capacity;
        this.elemCount = content == null ? 0 : content.size();
        this.generator.create(this);
    }

    public void push(T elem, Timing delay, Timing duration) {
        if (this.isFull(delay, duration)) {
            throw new IndexOutOfBoundsException("The capacity limit of the array used by this stack has been exceeded!");
        }
        super.push(elem);
        ++this.elemCount;
        this.generator.push(this, elem, delay, duration);
    }

    public T pop(Timing delay, Timing duration) {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        this.generator.pop(this, delay, duration);
        --this.elemCount;
        return super.pop();
    }

    public T top(Timing delay, Timing duration) {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        this.generator.top(this, delay, duration);
        return super.top();
    }

    public boolean isEmpty(Timing delay, Timing duration) {
        this.generator.isEmpty(this, delay, duration);
        return super.isEmpty();
    }

    public boolean isFull(Timing delay, Timing duration) {
        this.generator.isFull(this, delay, duration);
        return this.elemCount == this.capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void highlightTopElem(Timing delay, Timing duration) {
        if (!this.isEmpty()) {
            this.generator.highlightTopElem(this, delay, duration);
        }
    }

    public void unhighlightTopElem(Timing delay, Timing duration) {
        if (!this.isEmpty()) {
            this.generator.unhighlightTopElem(this, delay, duration);
        }
    }

    public void highlightTopCell(Timing delay, Timing duration) {
        if (!this.isEmpty()) {
            this.generator.highlightTopCell(this, delay, duration);
        }
    }

    public void unhighlightTopCell(Timing delay, Timing duration) {
        if (!this.isEmpty()) {
            this.generator.unhighlightTopCell(this, delay, duration);
        }
    }
}

