/*
 * Decompiled with CFR 0.152.
 */
package algoanim.annotations;

import algoanim.annotations.Annotation;
import algoanim.annotations.Executor;
import algoanim.executors.EvalExecutor;
import algoanim.executors.GlobalExecutor;
import algoanim.executors.HighlightExecutor;
import algoanim.executors.VariableContextExecutor;
import algoanim.executors.VariableDeclareExecutor;
import algoanim.executors.VariableDecreaseExecutor;
import algoanim.executors.VariableDiscardExecutor;
import algoanim.executors.VariableIncreaseExecutor;
import algoanim.executors.VariableSetExecutor;
import algoanim.primitives.SourceCode;
import algoanim.primitives.Variables;
import java.util.Vector;

public class ExecutorManager {
    protected Variables vars;
    protected SourceCode src;
    protected Vector<Executor> executors;

    public ExecutorManager(Variables vars, SourceCode src) {
        this.vars = vars;
        this.src = src;
        this.executors = new Vector();
        this.executors.add(new VariableDeclareExecutor(vars, src));
        this.executors.add(new VariableSetExecutor(vars, src));
        this.executors.add(new VariableDiscardExecutor(vars, src));
        this.executors.add(new VariableDecreaseExecutor(vars, src));
        this.executors.add(new VariableIncreaseExecutor(vars, src));
        this.executors.add(new EvalExecutor(vars, src));
        this.executors.add(new HighlightExecutor(vars, src));
        this.executors.add(new GlobalExecutor(vars, src));
        this.executors.add(new VariableContextExecutor(vars, src));
    }

    public boolean exec(Vector<Annotation> annos) {
        boolean executed = true;
        for (Annotation anno : annos) {
            executed &= this.exec(anno);
        }
        return executed;
    }

    public boolean exec(Annotation anno) {
        boolean executed = false;
        for (Executor executor : this.executors) {
            boolean bl = executed = executed || executor.exec(anno);
        }
        if (!(executed || anno.getName().equals("label") || anno.getName().equals("continue"))) {
            System.err.println("no executor found for annotation \"" + anno.getName() + "\"");
        }
        return executed;
    }
}

