/*
 * Decompiled with CFR 0.152.
 */
package algoanim.animalscript;

import algoanim.animalscript.AnimalGenerator;
import algoanim.primitives.Primitive;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.primitives.generators.TextGenerator;
import algoanim.properties.TextProperties;
import algoanim.util.Timing;
import java.awt.Color;
import java.awt.Font;

public class AnimalTextGenerator
extends AnimalGenerator
implements TextGenerator {
    private static int count = 1;

    public AnimalTextGenerator(Language aLang) {
        super(aLang);
    }

    @Override
    public void create(Text t) {
        if (this.isNameUsed(t.getName()) || t.getName() == "") {
            t.setName("Text" + count);
            ++count;
        }
        this.lang.addItem(t);
        StringBuilder str = new StringBuilder();
        str.append("text \"" + t.getName() + "\" ");
        str.append("\"" + t.getText() + "\" ");
        str.append(AnimalGenerator.makeNodeDef(t.getUpperLeft()));
        TextProperties props = t.getProperties();
        if (props.get("centered") != null && ((Boolean)props.get("centered")).booleanValue()) {
            str.append(" centered");
        }
        if (props.get("color") != null) {
            str.append(" color ");
            str.append(AnimalGenerator.makeColorDef(((Color)props.get("color")).getRed(), ((Color)props.get("color")).getGreen(), ((Color)props.get("color")).getBlue()));
        }
        if (props.get("depth") != null) {
            str.append(" depth " + ((Integer)props.get("depth")).toString());
        }
        if (props.get("font") != null) {
            str.append(" font " + ((Font)props.get("font")).getFamily());
        }
        if (props.get("font") != null) {
            str.append(" size " + ((Font)props.get("font")).getSize());
        }
        if (props.get("font") != null && ((Font)props.get("font")).isBold()) {
            str.append(" bold");
        }
        if (props.get("font") != null && ((Font)props.get("font")).isItalic()) {
            str.append(" italic");
        }
        str.append(AnimalGenerator.makeDisplayOptionsDef(t.getDisplayOptions(), props));
        this.lang.addLine(str);
    }

    @Override
    public void setFont(Primitive p, Font newFont, Timing delay, Timing duration) {
        StringBuilder str = new StringBuilder();
        str.append("setFont of \"").append(p.getName()).append("\" to font ");
        str.append(newFont.getFamily()).append(" size ").append(newFont.getSize());
        if (newFont.isBold()) {
            str.append(" bold");
        }
        if (newFont.isItalic()) {
            str.append(" italic");
        }
        str.append(AnimalGenerator.makeOffsetTimingDef(delay));
        str.append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(str);
    }

    @Override
    public void setText(Primitive p, String newText, Timing delay, Timing duration) {
        StringBuilder str = new StringBuilder();
        str.append("setText of \"").append(p.getName()).append("\" to \"");
        str.append(newText).append("\"");
        str.append(AnimalGenerator.makeOffsetTimingDef(delay));
        str.append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(str);
    }
}

