/*
 * Decompiled with CFR 0.152.
 */
package algoanim.animalscript;

import algoanim.animalscript.AnimalGenerator;
import algoanim.animalscript.AnimalScript;
import algoanim.primitives.Square;
import algoanim.primitives.generators.Language;
import algoanim.primitives.generators.SquareGenerator;
import algoanim.properties.SquareProperties;
import java.awt.Color;

public class AnimalSquareGenerator
extends AnimalGenerator
implements SquareGenerator {
    private static int count = 1;

    public AnimalSquareGenerator(Language aLang) {
        super(aLang);
    }

    @Override
    public void create(Square s) {
        if (this.isNameUsed(s.getName()) || s.getName() == "") {
            s.setName("Square" + count);
            ++count;
        }
        this.lang.addItem(s);
        StringBuilder str = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        str.append("square \"" + s.getName() + "\" ");
        str.append(AnimalGenerator.makeNodeDef(s.getUpperLeft()));
        str.append(" " + s.getWidth());
        SquareProperties props = s.getProperties();
        if (props.get("color") != null) {
            str.append(" color ");
            str.append(AnimalGenerator.makeColorDef(((Color)props.get("color")).getRed(), ((Color)props.get("color")).getGreen(), ((Color)props.get("color")).getBlue()));
        }
        if (props.get("depth") != null) {
            str.append(" depth " + ((Integer)props.get("depth")).toString());
        }
        if (props.get("filled") != null && ((Boolean)props.get("filled")).booleanValue()) {
            str.append(" filled");
            if (props.get("fillColor") != null) {
                str.append(" fillColor ");
                str.append(AnimalGenerator.makeColorDef(((Color)props.get("fillColor")).getRed(), ((Color)props.get("fillColor")).getGreen(), ((Color)props.get("fillColor")).getBlue()));
            }
        }
        str.append(AnimalGenerator.makeDisplayOptionsDef(s.getDisplayOptions(), props));
        this.lang.addLine(str);
    }
}

