/*
 * Decompiled with CFR 0.152.
 */
package algoanim.animalscript;

import algoanim.animalscript.AnimalGenerator;
import algoanim.animalscript.AnimalScript;
import algoanim.primitives.Group;
import algoanim.primitives.Primitive;
import algoanim.primitives.generators.GroupGenerator;
import algoanim.primitives.generators.Language;
import java.util.LinkedList;
import java.util.ListIterator;

public class AnimalGroupGenerator
extends AnimalGenerator
implements GroupGenerator {
    private static int count = 1;

    public AnimalGroupGenerator(Language aLang) {
        super(aLang);
    }

    @Override
    public void create(Group g) {
        String name = g.getName();
        if (name == null || name == "" || this.isNameUsed(name)) {
            g.setName("Group" + count);
            name = g.getName();
            ++count;
        }
        this.lang.addItem(g);
        StringBuilder def = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        def.append("group \"" + name + "\" ");
        LinkedList<Primitive> primitives = g.getPrimitives();
        if (primitives != null) {
            ListIterator i = primitives.listIterator();
            while (i.hasNext()) {
                Primitive p = (Primitive)i.next();
                def.append("\"" + p.getName() + "\" ");
            }
        }
        this.lang.addLine(def);
    }

    @Override
    public void remove(Group g, Primitive p) {
        this.lang.addLine("remove \"" + g.getName() + "\" \"" + p.getName() + "\"");
    }
}

