/*
 * Decompiled with CFR 0.152.
 */
package algoanim.animalscript;

import algoanim.animalscript.AnimalGenerator;
import algoanim.animalscript.AnimalScript;
import algoanim.primitives.Circle;
import algoanim.primitives.generators.CircleGenerator;
import algoanim.primitives.generators.Language;
import algoanim.properties.CircleProperties;
import java.awt.Color;

public class AnimalCircleGenerator
extends AnimalGenerator
implements CircleGenerator {
    private static int count = 1;

    public AnimalCircleGenerator(Language aLang) {
        super(aLang);
    }

    @Override
    public void create(Circle acircle) {
        if (this.isNameUsed(acircle.getName()) || acircle.getName() == "") {
            acircle.setName("Circle" + count);
            ++count;
        }
        this.lang.addItem(acircle);
        StringBuilder str = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        str.append("circle \"" + acircle.getName() + "\" ");
        str.append(AnimalGenerator.makeNodeDef(acircle.getCenter()));
        str.append(" radius " + acircle.getRadius());
        CircleProperties props = acircle.getProperties();
        if (props.get("color") != null) {
            str.append(" color ");
            str.append(AnimalGenerator.makeColorDef(((Color)props.get("color")).getRed(), ((Color)props.get("color")).getGreen(), ((Color)props.get("color")).getBlue()));
        }
        if (props.get("depth") != null) {
            str.append(" depth " + ((Integer)props.get("depth")).toString());
        }
        if (props.get("filled") != null && ((Boolean)props.get("filled")).booleanValue()) {
            str.append(" filled");
            if (props.get("fillColor") != null) {
                str.append(" fillColor ");
                str.append(AnimalGenerator.makeColorDef(((Color)props.get("fillColor")).getRed(), ((Color)props.get("fillColor")).getGreen(), ((Color)props.get("fillColor")).getBlue()));
            }
        }
        str.append(AnimalGenerator.makeDisplayOptionsDef(acircle.getDisplayOptions(), props));
        this.lang.addLine(str);
    }
}

