/*
 * Decompiled with CFR 0.152.
 */
package algoanim.animalscript;

import algoanim.animalscript.AnimalGenerator;
import algoanim.animalscript.AnimalScript;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.generators.ArrayMarkerGenerator;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.util.Timing;
import java.awt.Color;

public class AnimalArrayMarkerGenerator
extends AnimalGenerator
implements ArrayMarkerGenerator {
    private static int count = 1;

    public AnimalArrayMarkerGenerator(Language aLang) {
        super(aLang);
    }

    @Override
    public void create(ArrayMarker am) {
        if (this.isNameUsed(am.getName()) || am.getName() == "") {
            am.setName("ArrayMarker" + count);
            ++count;
        }
        this.lang.addItem(am);
        StringBuilder def = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        def.append("arrayMarker \"").append(am.getName()).append("\" on \"");
        def.append(am.getArray().getName()).append("\" atIndex ");
        def.append(am.getPosition());
        ArrayMarkerProperties props = am.getProperties();
        if (props.get("label") != null && !((String)props.get("label")).equals("")) {
            def.append(" label \"").append((String)props.get("label")).append("\"");
        }
        if (props.get("long") != null && (Boolean)props.get("long") == Boolean.TRUE) {
            def.append(" long");
        } else if (props.get("short") != null && (Boolean)props.get("short") == Boolean.TRUE) {
            def.append(" short");
        }
        if (props.get("color") != null) {
            def.append(" color ");
            def.append(AnimalGenerator.makeColorDef(((Color)props.get("color")).getRed(), ((Color)props.get("color")).getGreen(), ((Color)props.get("color")).getBlue()));
        }
        if (props.get("depth") != null) {
            def.append(" depth " + ((Integer)props.get("depth")).toString());
        }
        def.append(AnimalGenerator.makeDisplayOptionsDef(am.getDisplayOptions(), props));
        this.lang.addLine(def);
    }

    @Override
    public void move(ArrayMarker am, int to, Timing delay, Timing duration) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("moveArrayMarker \"").append(am.getName());
        sb.append("\" to position ").append(to).append(" ");
        sb.append(AnimalGenerator.makeOffsetTimingDef(delay)).append(" ");
        sb.append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(sb.toString());
    }

    @Override
    public void moveBeforeStart(ArrayMarker am, Timing delay, Timing duration) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("moveArrayMarker \"").append(am.getName());
        sb.append("\" to outside ");
        sb.append(AnimalGenerator.makeOffsetTimingDef(delay)).append(" ");
        sb.append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(sb.toString());
    }

    @Override
    public void moveToEnd(ArrayMarker am, Timing delay, Timing duration) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("moveArrayMarker \"").append(am.getName());
        sb.append("\" to arrayEnd ");
        sb.append(AnimalGenerator.makeOffsetTimingDef(delay));
        sb.append(" ").append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(sb.toString());
    }

    @Override
    public void moveOutside(ArrayMarker am, Timing delay, Timing duration) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("moveArrayMarker \"").append(am.getName());
        sb.append("\" to outside ");
        sb.append(AnimalGenerator.makeOffsetTimingDef(delay));
        sb.append(" ").append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(sb.toString());
    }

    @Override
    public void decrement(ArrayMarker am, Timing delay, Timing duration) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("moveArrayMarker \"").append(am.getName());
        sb.append("\" to position ").append(am.getPosition() - 1);
        sb.append(" ").append(AnimalGenerator.makeOffsetTimingDef(delay));
        sb.append(" ");
        sb.append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(sb.toString());
    }

    @Override
    public void increment(ArrayMarker am, Timing delay, Timing duration) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("moveArrayMarker \"").append(am.getName());
        sb.append("\" to position ").append(am.getPosition() + 1);
        sb.append(" ").append(AnimalGenerator.makeOffsetTimingDef(delay));
        sb.append(" ");
        sb.append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(sb.toString());
    }
}

