/*
 * Decompiled with CFR 0.152.
 */
package algoanim.animalscript;

import algoanim.animalscript.AnimalGenerator;
import algoanim.animalscript.AnimalScript;
import algoanim.primitives.Arc;
import algoanim.primitives.generators.ArcGenerator;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArcProperties;
import java.awt.Color;

public class AnimalArcGenerator
extends AnimalGenerator
implements ArcGenerator {
    private static int count = 1;

    public AnimalArcGenerator(Language aLang) {
        super(aLang);
    }

    @Override
    public void create(Arc ag) {
        if (this.isNameUsed(ag.getName()) || ag.getName() == "") {
            ag.setName("Arc" + count);
            ++count;
        }
        this.lang.addItem(ag);
        StringBuilder str = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        str.append("circleSeg \"" + ag.getName() + "\" ");
        str.append(AnimalGenerator.makeNodeDef(ag.getCenter()));
        str.append(" radius " + AnimalGenerator.makeNodeDef(ag.getRadius()));
        ArcProperties props = ag.getProperties();
        if (props.get("angle") != null) {
            str.append(" angle " + props.get("angle").toString());
        }
        if (props.get("startAngle") != null) {
            str.append(" startAngle " + props.get("startAngle").toString());
        }
        if (props.get("clockwise") != null && ((Boolean)props.get("clockwise")).booleanValue()) {
            str.append(" clockwise ");
        } else if (props.get("clockwise") != null && ((Boolean)props.get("counterclockwise")).booleanValue()) {
            str.append(" counterclockwise ");
        }
        if (props.get("color") != null) {
            str.append(" color ");
            str.append(AnimalGenerator.makeColorDef(((Color)props.get("color")).getRed(), ((Color)props.get("color")).getGreen(), ((Color)props.get("color")).getBlue()));
        }
        if (props.get("depth") != null) {
            str.append(" depth " + ((Integer)props.get("depth")).toString());
        }
        if (props.get("closed") != null && ((Boolean)props.get("closed")).booleanValue()) {
            str.append(" closed ");
            if (props.get("filled") != null && ((Boolean)props.get("filled")).booleanValue()) {
                str.append(" filled");
                if (props.get("fillColor") != null) {
                    str.append(" fillColor ");
                    str.append(AnimalGenerator.makeColorDef(((Color)props.get("fillColor")).getRed(), ((Color)props.get("fillColor")).getGreen(), ((Color)props.get("fillColor")).getBlue()));
                }
            }
        } else {
            if (props.get("fwArrow") != null && ((Boolean)props.get("fwArrow")).booleanValue()) {
                str.append(" fwarrow ");
            }
            if (props.get("bwArrow") != null && ((Boolean)props.get("bwArrow")).booleanValue()) {
                str.append(" bwarrow ");
            }
        }
        str.append(AnimalGenerator.makeDisplayOptionsDef(ag.getDisplayOptions(), props));
        this.lang.addLine(str);
    }
}

