/*
 * Decompiled with CFR 0.152.
 */
package net.algoanim.aads;

import animal.misc.XProperties;

public class AnimatedStringArray {
    private static int arrayCode = 0;
    private String[] arrayData = null;
    private StringBuilder localBuffer = null;
    private String arrayName = "array";
    private XProperties props = new XProperties();
    private boolean inStep = false;
    private int nrAssignments = 0;
    private int nrComparisons = 0;
    private int nrCodeLines = 0;
    private String assCounterID = null;
    private String compCounterID = null;

    public AnimatedStringArray(String[] arrayParam) {
        this("array" + arrayCode++, arrayParam);
    }

    public AnimatedStringArray(String label, String[] arrayParam) {
        this(label, arrayParam, new StringBuilder(Short.MAX_VALUE));
    }

    public AnimatedStringArray(String label, String[] theArray, StringBuilder targetBuffer) {
        this.setArrayName(label);
        this.arrayData = new String[theArray.length];
        System.arraycopy(theArray, 0, this.arrayData, 0, theArray.length);
        this.setLocalBuffer(targetBuffer);
        this.installBasicArray();
    }

    public void installBasicArray() {
        if (this.arrayData == null) {
            return;
        }
        int length = this.getLength();
        this.props.put(String.valueOf(this.getArrayName()) + ".name", this.getArrayName());
        this.props.put(String.valueOf(this.getArrayName()) + ".length", length);
        StringBuilder sbuf = this.getLocalBuffer();
        sbuf.append("  array \"").append(this.getArrayName()).append("\" (20, 80)");
        sbuf.append(" color black fillColor white elementColor black ");
        sbuf.append("elemHighlight blue cellHighlight gray length ");
        sbuf.append(length).append(" ");
        int i = 0;
        while (i < length) {
            sbuf.append("\"").append(this.arrayData[i]).append("\"");
            ++i;
        }
        sbuf.append("\n");
    }

    public int getLength() {
        if (this.arrayData == null) {
            return 0;
        }
        return this.arrayData.length;
    }

    public int getNrAssignments() {
        return this.nrAssignments;
    }

    public int getNrComparisons() {
        return this.nrComparisons;
    }

    public void incrementAssignments() {
        this.incrementAssignments(1);
    }

    public void incrementAssignments(int howMuch) {
        this.nrAssignments += howMuch;
        if (this.assCounterID != null) {
            this.getLocalBuffer().append("  move \"").append(this.assCounterID).append("\" type \"");
            this.getLocalBuffer().append("translateNodes 2 3\" along line (0,0) (1,0) within 5 ticks\n");
        }
    }

    public void incrementComparisons() {
        this.incrementComparisons(1);
    }

    public void incrementComparisons(int howMuch) {
        this.nrComparisons += howMuch;
        if (this.compCounterID != null) {
            this.getLocalBuffer().append("  move \"").append(this.compCounterID).append("\" type \"");
            this.getLocalBuffer().append("translateNodes 2 3\" (0,0) along line (1,0) within 5 ticks\n");
        }
    }

    public void setLocalBuffer(StringBuilder targetBuffer) {
        this.localBuffer = targetBuffer;
    }

    public void installSourceCode(String[] codeLines, String[] indentations) {
        this.nrCodeLines = 0;
        if (codeLines == null || codeLines.length == 0) {
            return;
        }
        String codeGroupName = String.valueOf(this.getArrayName()) + " code";
        this.startStep();
        StringBuilder sbuf = this.getLocalBuffer();
        sbuf.append("  codegroup \"").append(codeGroupName);
        sbuf.append("\" at (20, 140) color black highlightColor red");
        sbuf.append("contextColor blue2 font SansSerif size 11");
        int i = 0;
        while (i < codeLines.length) {
            sbuf.append("\n  addCodeLine \"").append(codeLines[i]);
            sbuf.append("\" to \"").append(codeGroupName);
            sbuf.append("\" indentation ").append(indentations[i]);
            this.props.put(String.valueOf(this.getArrayName()) + ".codeline_" + i, codeLines[i]);
            ++i;
        }
        this.endStep();
        this.nrCodeLines = codeLines.length;
    }

    public void startStep() {
        if (this.inStep) {
            this.endStep();
        }
        this.getLocalBuffer().append("{\n");
        this.inStep = true;
    }

    public void endStep() {
        if (this.inStep) {
            this.getLocalBuffer().append("}\n");
        }
        this.inStep = false;
    }

    public void highlightCode(int line, boolean highlightOn, boolean contextMode) {
        if (line < 1 || line > this.nrCodeLines) {
            return;
        }
        StringBuilder sbuf = this.getLocalBuffer();
        sbuf.append("  ");
        if (!highlightOn) {
            sbuf.append("un");
        }
        sbuf.append("highlightCode on \"").append(String.valueOf(this.getArrayName()) + " code");
        sbuf.append("\" line ").append(line);
        if (contextMode) {
            sbuf.append(" context");
        }
        sbuf.append("\n");
    }

    public String getArrayName() {
        if (this.arrayName == null) {
            this.arrayName = "array" + arrayCode;
            ++arrayCode;
        }
        return this.arrayName;
    }

    public void setArrayName(String name) {
        this.arrayName = name;
    }

    public StringBuilder getLocalBuffer() {
        if (this.localBuffer == null) {
            this.localBuffer = new StringBuilder(32768);
        }
        return this.localBuffer;
    }

    public void swap(int firstIndex, int secondIndex) {
        int length = this.getLength();
        if (length == 0 || firstIndex < 0 || firstIndex > length || secondIndex < 0 || secondIndex > length) {
            return;
        }
        StringBuilder sbuf = this.getLocalBuffer();
        sbuf.append("  arraySwap on \"").append(this.getArrayName());
        sbuf.append("\" position ").append(firstIndex).append(" with ");
        sbuf.append(secondIndex).append(" within 10 ticks\n");
        String tmp = this.arrayData[secondIndex];
        this.arrayData[secondIndex] = this.arrayData[firstIndex];
        this.arrayData[firstIndex] = tmp;
        this.incrementAssignments(3);
    }

    public void installArrayIndex(int targetPosition, String label, String title) {
        if (targetPosition < 0 || targetPosition >= this.getLength()) {
            return;
        }
        StringBuilder sbuf = this.getLocalBuffer();
        sbuf.append("  arrayIndex \"").append(label).append("\" on \"");
        sbuf.append(this.getArrayName()).append("\" atIndex ").append(targetPosition);
        if (title != null) {
            sbuf.append(" label \"").append(title).append("\"");
        }
        sbuf.append(" color ").append("red").append("\n");
        this.props.put(String.valueOf(this.getArrayName()) + ".index_" + label, targetPosition);
        this.props.put(String.valueOf(this.getArrayName()) + ".label_" + label, label);
        this.props.put(String.valueOf(this.getArrayName()) + ".label_" + title, title);
        this.incrementAssignments();
    }

    public void moveArrayIndex(String label, int targetPosition) {
        if (targetPosition < 0 || targetPosition > this.getLength()) {
            return;
        }
        StringBuilder sbuf = this.getLocalBuffer();
        sbuf.append("  moveMarker \"").append(label).append("\" to position ");
        sbuf.append(targetPosition).append(" within 5 ticks\n");
        this.props.put(String.valueOf(this.getArrayName()) + ".index_" + label, targetPosition);
        this.incrementAssignments();
    }

    public void putElement(String newVal, int position) {
        if (position < 0 || position >= this.getLength()) {
            return;
        }
        StringBuilder sbuf = this.getLocalBuffer();
        sbuf.append("  arrayPut \"").append(newVal).append("\" on \"");
        sbuf.append(this.getArrayName()).append("\" position ").append(position).append("\n");
        this.arrayData[position] = newVal;
        this.incrementAssignments();
    }

    public void printArray() {
        int length = this.getLength();
        if (length > 0) {
            StringBuilder sbuf = new StringBuilder(length << 3);
            sbuf.append("array values: [");
            int i = 0;
            while (i < length - 1) {
                sbuf.append('\"').append(this.arrayData[i]).append("\", ");
                ++i;
            }
            sbuf.append('\"').append(this.arrayData[length - 1]).append("\"]");
            System.err.println(sbuf.toString());
            Object var2_2 = null;
        }
    }

    public void setCounterIDs(String assignmentID, String comparisonID) {
        this.assCounterID = assignmentID;
        this.compCounterID = comparisonID;
    }
}

