/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui.graphs.basic;

import gfgaa.gui.GraphAlgController;
import gfgaa.gui.components.IntegerTextFieldEx;
import gfgaa.gui.components.SComponent;
import gfgaa.gui.components.SPanel;
import gfgaa.gui.graphs.AbstractGraph;
import gfgaa.gui.graphs.AbstractNode;
import gfgaa.gui.graphs.KantenPanelInterface;
import gfgaa.gui.graphs.basic.Edge;
import gfgaa.gui.graphs.basic.Node;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public final class KantenPanel
extends SPanel
implements KantenPanelInterface {
    private static final long serialVersionUID = 2283100811872159078L;
    GraphAlgController mainclass;
    private JButton createNodeButton;
    private JButton removeNodeButton;
    JComboBox nodeTagBox;
    IntegerTextFieldEx xPos;
    IntegerTextFieldEx yPos;
    private JButton createEdgeButton;
    private JButton removeEdgeButton;
    JComboBox startNodeBox;
    JComboBox endNodeBox;
    private JLabel weightEdgeLab;
    IntegerTextFieldEx weightEdgeField;
    private JComboBox nodeBox;
    private JLabel workAtEdgesLab;
    private JLabel startNodeLab;
    private JLabel workAtNodeLab;
    private JLabel nodeTagLab;
    private JLabel positionLab;
    private JLabel endNodeLab;

    public KantenPanel(GraphAlgController mainclass) {
        this.setLayout(null);
        this.mainclass = mainclass;
        this.mainclass.addPanel(4, this);
        this.createEditNodes();
        this.createEditEdges();
        this.changeLanguageSettings(mainclass.getLanguageSettings());
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent e) {
                KantenPanel.this.refreshPanelComponents();
            }

            @Override
            public void ancestorMoved(AncestorEvent e) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent e) {
            }
        });
    }

    private JComboBox createNodeBox(int id) {
        this.nodeBox = new JComboBox();
        this.nodeBox.setFont(new Font("Serif", 1, 16));
        if (id == 1) {
            this.nodeBox.setBounds(213, 280, 44, 25);
        } else {
            this.nodeBox.setBounds(213, 310, 44, 25);
        }
        this.nodeBox.addItem(" ");
        AbstractGraph graph = this.mainclass.getGraph();
        int anz = 0;
        if (graph != null) {
            char sign = 'A';
            int i = 0;
            while (i < 26) {
                if (graph.containsTag("" + sign)) {
                    this.nodeBox.addItem(new Character(sign));
                    ++anz;
                }
                ++i;
                sign = (char)(sign + '\u0001');
            }
        }
        if (anz == 0) {
            this.nodeBox.setEnabled(false);
        }
        this.add(this.nodeBox);
        return this.nodeBox;
    }

    private void createEditNodes() {
        this.workAtNodeLab = new JLabel();
        this.workAtNodeLab.setFont(new Font("Serif", 1, 18));
        this.add(new SComponent(this.workAtNodeLab, new String[]{"Knoten bearbeiten", "Edit Nodes"}));
        this.add(this.workAtNodeLab);
        this.nodeTagLab = new JLabel();
        this.nodeTagLab.setBounds(20, 70, 170, 25);
        this.add(new SComponent(this.nodeTagLab, new String[]{"Kennzeichnung des Knotens", "Node Tag"}));
        this.add(this.nodeTagLab);
        this.positionLab = new JLabel();
        this.positionLab.setBounds(20, 100, 170, 25);
        this.add(new SComponent(this.positionLab, new String[]{"Position des Knotens", "Node Position"}));
        this.add(this.positionLab);
        this.xPos = new IntegerTextFieldEx(30, 420);
        this.xPos.setBounds(203, 100, 30, 25);
        this.xPos.setText("210");
        this.add(new SComponent(this.xPos, new String[]{"x Koordinate", "x Coordinate"}));
        this.add(this.xPos);
        this.yPos = new IntegerTextFieldEx(30, 420);
        this.yPos.setBounds(237, 100, 30, 25);
        this.yPos.setText("210");
        this.add(new SComponent(this.yPos, new String[]{"y Koordinate", "y Coordinate"}));
        this.add(this.yPos);
        this.nodeTagBox = new JComboBox();
        this.nodeTagBox.setBounds(213, 70, 44, 25);
        this.nodeTagBox.setFont(new Font("Serif", 1, 16));
        char sign = 'A';
        this.nodeTagBox.addItem(" ");
        int i = 0;
        while (i < 26) {
            char c = sign;
            sign = (char)(c + 1);
            this.nodeTagBox.addItem(new Character(c));
            ++i;
        }
        this.nodeTagBox.setSelectedIndex(0);
        this.nodeTagBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KantenPanel.this.enableNodeButtons();
            }
        });
        this.add(this.nodeTagBox);
        this.createNodeButton = new JButton();
        this.createNodeButton.setBounds(10, 180, 132, 25);
        this.createNodeButton.setEnabled(false);
        this.createNodeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractGraph aktuGraph = KantenPanel.this.mainclass.getGraph();
                String tag = KantenPanel.this.nodeTagBox.getSelectedItem().toString();
                int xpos = KantenPanel.this.xPos.getValue();
                int ypos = KantenPanel.this.yPos.getValue();
                if (!aktuGraph.containsTag(tag)) {
                    aktuGraph.addNode(new Node(tag.charAt(0), xpos, ypos));
                    KantenPanel.this.refreshPanelComponents();
                    KantenPanel.this.nodeTagBox.setSelectedIndex(0);
                } else {
                    aktuGraph.getNode(tag.charAt(0)).moveTo(xpos, ypos);
                }
                KantenPanel.this.mainclass.repaint();
            }
        });
        this.add(this.createNodeButton);
        this.removeNodeButton = new JButton();
        this.removeNodeButton.setBounds(142, 180, 132, 25);
        this.removeNodeButton.setEnabled(false);
        this.add(new SComponent(this.removeNodeButton, new String[]{"Knoten entfernen", "Remove Node"}, new String[]{"Entfernt den Knoten mit der ausgew\u2030hlten Kennzeichnung.", "Removes the node with the choosen tag."}));
        this.removeNodeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractGraph aktuGraph = KantenPanel.this.mainclass.getGraph();
                String tag = KantenPanel.this.nodeTagBox.getSelectedItem().toString();
                if (KantenPanel.this.mainclass.showUserMessage(3)) {
                    aktuGraph.removeNode(tag.charAt(0));
                    KantenPanel.this.refreshPanelComponents();
                    KantenPanel.this.nodeTagBox.setSelectedIndex(0);
                    KantenPanel.this.mainclass.repaint();
                }
            }
        });
        this.add(this.removeNodeButton);
    }

    private void createEditEdges() {
        this.workAtEdgesLab = new JLabel();
        this.workAtEdgesLab.setFont(new Font("Serif", 1, 18));
        this.add(new SComponent(this.workAtEdgesLab, new String[]{"Kanten bearbeiten", "Edit Edges"}));
        this.add(this.workAtEdgesLab);
        this.startNodeLab = new JLabel();
        this.startNodeLab.setBounds(20, 280, 200, 25);
        this.add(new SComponent(this.startNodeLab, new String[]{"Startknoten der Kante", "Start Node Tag"}));
        this.add(this.startNodeLab);
        this.startNodeBox = this.createNodeBox(1);
        this.endNodeLab = new JLabel();
        this.endNodeLab.setBounds(20, 310, 200, 25);
        this.add(new SComponent(this.endNodeLab, new String[]{"Zielknoten der Kante", "End Node Tag"}));
        this.add(this.endNodeLab);
        this.endNodeBox = this.createNodeBox(2);
        this.weightEdgeLab = new JLabel();
        this.weightEdgeLab.setBounds(20, 340, 200, 25);
        this.add(new SComponent(this.weightEdgeLab, new String[]{"Gewicht der Kante", "Weight of the Edge"}));
        this.add(this.weightEdgeLab);
        this.weightEdgeField = new IntegerTextFieldEx(1, 99);
        this.weightEdgeField.setBounds(223, 340, 25, 25);
        this.weightEdgeField.setText("1");
        this.add(new SComponent(this.weightEdgeField, new String[]{"Gewicht der Kante", "Weight of the Edge"}));
        this.add(this.weightEdgeField);
        this.createEdgeButton = new JButton();
        this.createEdgeButton.setBounds(10, 420, 132, 25);
        this.createEdgeButton.setEnabled(false);
        this.createEdgeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                char cStart = KantenPanel.this.startNodeBox.getSelectedItem().toString().charAt(0);
                char cZiel = KantenPanel.this.endNodeBox.getSelectedItem().toString().charAt(0);
                AbstractGraph aktuGraph = KantenPanel.this.mainclass.getGraph();
                AbstractNode strt = aktuGraph.getNode(cStart);
                AbstractNode end = aktuGraph.getNode(cZiel);
                int weight = KantenPanel.this.weightEdgeField.getValue();
                if (aktuGraph.isDirected()) {
                    if (!aktuGraph.containsTag(String.valueOf(cStart) + "->" + cZiel)) {
                        Edge edge = new Edge(strt, end, weight);
                        strt.addEdge(edge);
                        end.addAgainstEdge(edge);
                        KantenPanel.this.weightEdgeField.setText("1");
                        KantenPanel.this.startNodeBox.setSelectedIndex(0);
                        KantenPanel.this.endNodeBox.setSelectedIndex(0);
                    } else {
                        strt.getEdgeTo(end).setWeight(weight);
                    }
                } else if (aktuGraph.containsTag(String.valueOf(cStart) + "->" + cZiel) || aktuGraph.containsTag(String.valueOf(cZiel) + "->" + cStart)) {
                    if (cStart > cZiel) {
                        end.getEdgeTo(strt).setWeight(weight);
                    } else {
                        strt.getEdgeTo(end).setWeight(weight);
                    }
                } else {
                    if (cStart > cZiel) {
                        Edge edge = new Edge(end, strt, weight);
                        end.addEdge(edge);
                        strt.addAgainstEdge(edge);
                    } else {
                        Edge edge = new Edge(strt, end, weight);
                        strt.addEdge(edge);
                        end.addAgainstEdge(edge);
                    }
                    KantenPanel.this.weightEdgeField.setText("1");
                    KantenPanel.this.startNodeBox.setSelectedIndex(0);
                    KantenPanel.this.endNodeBox.setSelectedIndex(0);
                }
                KantenPanel.this.mainclass.repaint();
            }
        });
        this.add(this.createEdgeButton);
        this.removeEdgeButton = new JButton();
        this.removeEdgeButton.setBounds(142, 420, 132, 25);
        this.removeEdgeButton.setEnabled(false);
        this.add(new SComponent(this.removeEdgeButton, new String[]{"Kante entfernen", "Remove Edge"}, new String[]{"L\u02c6scht die Kante die vom ausgew\u2030hlten Start zum Ziel geht.", "Removes the edge which points from the choosen start to the choosen target."}));
        this.removeEdgeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sStart = KantenPanel.this.startNodeBox.getSelectedItem().toString();
                String sZiel = KantenPanel.this.endNodeBox.getSelectedItem().toString();
                if (KantenPanel.this.mainclass.showUserMessage(4)) {
                    AbstractGraph aktuGraph = KantenPanel.this.mainclass.getGraph();
                    AbstractNode strt = aktuGraph.getNode(sStart.charAt(0));
                    AbstractNode end = aktuGraph.getNode(sZiel.charAt(0));
                    if (aktuGraph.isDirected()) {
                        aktuGraph.removeEdge(strt, end);
                    } else if (sStart.charAt(0) > sZiel.charAt(0)) {
                        aktuGraph.removeEdge(end, strt);
                    } else {
                        aktuGraph.removeEdge(strt, end);
                    }
                    KantenPanel.this.weightEdgeField.setText("1");
                    KantenPanel.this.startNodeBox.setSelectedIndex(0);
                    KantenPanel.this.endNodeBox.setSelectedIndex(0);
                    KantenPanel.this.mainclass.repaint();
                }
            }
        });
        this.add(this.removeEdgeButton);
    }

    void enableNodeButtons() {
        AbstractGraph aktuGraph = this.mainclass.getGraph();
        if (this.nodeTagBox.getSelectedIndex() == 0) {
            this.createNodeButton.setEnabled(false);
            if (this.mainclass.getLanguageSettings() == 0) {
                this.createNodeButton.setText("Knoten erzeugen");
                this.createNodeButton.setToolTipText("Erzeugt einen Knoten mit der ausgew\u2030hlten Kennung an der angegebenen Position.");
            } else {
                this.createNodeButton.setText("Create Node");
                this.createNodeButton.setToolTipText("Creates a node with the choosen tag at the specified position.");
            }
            this.xPos.setText("210");
            this.yPos.setText("210");
            this.removeNodeButton.setEnabled(false);
            return;
        }
        String sTag = this.nodeTagBox.getSelectedItem().toString();
        boolean flag = aktuGraph.containsTag(sTag);
        if (flag) {
            AbstractNode node = aktuGraph.getNode(sTag.charAt(0));
            this.xPos.setText("" + node.getXPos());
            this.yPos.setText("" + node.getYPos());
            if (this.mainclass.getLanguageSettings() == 0) {
                this.createNodeButton.setText("Knoten bewegen");
                this.createNodeButton.setToolTipText("Bewegt den ausgew\u2030hlten Knoten zur entsprechenden Position.");
            } else {
                this.createNodeButton.setText("Move Node");
                this.createNodeButton.setToolTipText("Moves the selected node to the specified position.");
            }
        } else {
            this.xPos.setText("210");
            this.yPos.setText("210");
            if (this.mainclass.getLanguageSettings() == 0) {
                this.createNodeButton.setText("Knoten erzeugen");
                this.createNodeButton.setToolTipText("Erzeugt einen Knoten mit der ausgew\u2030hlten Kennung an der angegebenen Position.");
            } else {
                this.createNodeButton.setText("Create Node");
                this.createNodeButton.setToolTipText("Creates a node with the choosen tag at the specified position.");
            }
        }
        this.createNodeButton.setEnabled(flag || !flag && aktuGraph.getNumberOfNodes() < aktuGraph.maxsize());
        this.removeNodeButton.setEnabled(flag);
    }

    void enableEdgeButtons() {
        boolean flag;
        if (this.startNodeBox.getSelectedIndex() == 0 || this.endNodeBox.getSelectedIndex() == 0) {
            this.createEdgeButton.setEnabled(false);
            if (this.mainclass.getLanguageSettings() == 0) {
                this.createEdgeButton.setText("Kante erzeugen");
                this.createEdgeButton.setToolTipText("Erzeugt eine neue Kante mit entsprechendem Gewicht vom Start- zum Zielknoten.");
            } else {
                this.createEdgeButton.setText("Create Edge");
                this.createEdgeButton.setToolTipText("Creates a new edge from the specified start to the specified end with the given weight.");
            }
            this.removeEdgeButton.setEnabled(false);
            this.weightEdgeField.setText("1");
            return;
        }
        String sTag = String.valueOf(this.startNodeBox.getSelectedItem().toString()) + "->" + this.endNodeBox.getSelectedItem().toString();
        String vTag = String.valueOf(this.endNodeBox.getSelectedItem().toString()) + "->" + this.startNodeBox.getSelectedItem().toString();
        AbstractGraph aktuGraph = this.mainclass.getGraph();
        boolean bl = flag = aktuGraph.containsTag(sTag) || !aktuGraph.isDirected() && aktuGraph.containsTag(vTag);
        if (flag && aktuGraph.isWeighted()) {
            if (aktuGraph.containsTag(sTag)) {
                this.weightEdgeField.setText("" + aktuGraph.getNode(sTag.charAt(0)).getEdgeTo(aktuGraph.getNode(sTag.charAt(3))).getWeight());
            } else {
                this.weightEdgeField.setText("" + aktuGraph.getNode(vTag.charAt(0)).getEdgeTo(aktuGraph.getNode(vTag.charAt(3))).getWeight());
            }
            if (this.mainclass.getLanguageSettings() == 0) {
                this.createEdgeButton.setText("Gewicht \u2030ndern");
                this.createEdgeButton.setToolTipText("");
            } else {
                this.createEdgeButton.setText("Set Weight");
                this.createEdgeButton.setToolTipText("");
            }
        } else if (this.mainclass.getLanguageSettings() == 0) {
            this.createEdgeButton.setText("Kante erzeugen");
            this.createEdgeButton.setToolTipText("Erzeugt eine neue Kante mit entsprechendem Gewicht vom Start- zum Zielknoten.");
        } else {
            this.createEdgeButton.setText("Create Edge");
            this.createEdgeButton.setToolTipText("Creates a new edge from the specified start to the specified end with the given weight.");
        }
        this.createEdgeButton.setEnabled(!flag || flag && aktuGraph.isWeighted());
        this.removeEdgeButton.setEnabled(flag);
    }

    @Override
    public void refreshPanelComponents() {
        Object select = this.startNodeBox.getSelectedItem();
        this.remove(this.startNodeBox);
        this.startNodeBox = this.createNodeBox(1);
        this.startNodeBox.setSelectedItem(select);
        select = this.endNodeBox.getSelectedItem();
        this.remove(this.endNodeBox);
        this.endNodeBox = this.createNodeBox(2);
        this.endNodeBox.setSelectedItem(select);
        this.enableEdgeButtons();
        this.enableNodeButtons();
        ActionListener combolistener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KantenPanel.this.enableEdgeButtons();
            }
        };
        this.startNodeBox.addActionListener(combolistener);
        this.endNodeBox.addActionListener(combolistener);
    }

    @Override
    public void changeLanguageSettings(int languageFlag) {
        super.changeLanguageSettings(languageFlag);
        this.enableNodeButtons();
        this.enableEdgeButtons();
    }

    @Override
    public void paint(Graphics g) {
        Dimension size = this.getSize();
        int[] pos = new int[5];
        pos[0] = (size.width - 266) / 2;
        pos[1] = pos[0] + 134;
        pos[3] = (size.width - 240) / 2;
        pos[4] = pos[3] + 190;
        if (this.mainclass.getLanguageSettings() == 0) {
            pos[2] = (size.width - 145) / 2;
            this.workAtNodeLab.setBounds(pos[2], 20, 145, 25);
            this.workAtEdgesLab.setBounds(pos[2], 230, 145, 25);
        } else {
            pos[2] = (size.width - 90) / 2;
            this.workAtNodeLab.setBounds(pos[2], 20, 90, 25);
            this.workAtEdgesLab.setBounds(pos[2], 230, 90, 25);
        }
        this.nodeTagLab.setLocation(pos[3], 70);
        this.nodeTagBox.setLocation(pos[4], 70);
        this.positionLab.setLocation(pos[3], 100);
        this.xPos.setLocation(pos[3] + 180, 100);
        this.yPos.setLocation(pos[3] + 212, 100);
        this.startNodeLab.setLocation(pos[3], 280);
        this.startNodeBox.setLocation(pos[4], 280);
        this.endNodeLab.setLocation(pos[3], 310);
        this.endNodeBox.setLocation(pos[4], 310);
        this.weightEdgeLab.setLocation(pos[3], 340);
        this.weightEdgeField.setLocation(pos[3] + 200, 340);
        this.createNodeButton.setLocation(pos[0], 180);
        this.removeNodeButton.setLocation(pos[1], 180);
        this.createEdgeButton.setLocation(pos[0], 420);
        this.removeEdgeButton.setLocation(pos[1], 420);
        Image offImage = this.createImage(size.width, size.height);
        Graphics offGraphics = offImage.getGraphics();
        boolean vis = this.mainclass.getGraph().isWeighted();
        this.weightEdgeLab.setVisible(vis);
        this.weightEdgeField.setVisible(vis);
        super.printComponents(offGraphics);
        offGraphics.setColor(Color.BLACK);
        offGraphics.drawLine(0, 220, size.width, 220);
        g.drawImage(offImage, 0, 0, this);
    }

    @Override
    public void refreshNodePosition(AbstractNode node) {
        if (node.getTag() == this.nodeTagBox.getSelectedItem().toString().charAt(0)) {
            this.xPos.setText("" + node.getXPos());
            this.yPos.setText("" + node.getYPos());
        }
    }
}

