/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui.graphs;

import gfgaa.gui.graphs.AbstractEdge;
import gfgaa.gui.graphs.AbstractGraph;
import java.util.ArrayList;

public abstract class AbstractNode {
    private char bez;
    private int x;
    private int y;
    protected AbstractGraph graph;
    protected ArrayList<AbstractEdge> inArcs;
    protected ArrayList<AbstractEdge> outArcs;

    public AbstractNode(char bez, int x, int y) {
        this.bez = bez;
        this.x = x;
        this.y = y;
        this.inArcs = new ArrayList();
        this.outArcs = new ArrayList();
    }

    public AbstractNode(char bez) {
        this.bez = bez;
    }

    public abstract void setGraph(AbstractGraph var1);

    public void addEdge(AbstractEdge edge) {
        this.graph.addTag(edge.getTag());
        this.outArcs.add(edge);
    }

    public AbstractEdge getEdge(int pos) {
        return this.outArcs.get(pos);
    }

    public int getNumberOfEdges() {
        return this.outArcs.size();
    }

    public boolean removeEdge(AbstractEdge edge) {
        int anz = this.outArcs.size();
        int i = 0;
        while (i < anz) {
            if (edge == this.getEdge(i)) {
                this.outArcs.remove(edge);
                this.graph.removeTag(edge.getTag());
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addAgainstEdge(AbstractEdge gegenkante) {
        this.inArcs.add(gegenkante);
    }

    public AbstractEdge getAgainstEdge(int pos) {
        return this.inArcs.get(pos);
    }

    public int getNumberOfAgainstEdges() {
        return this.inArcs.size();
    }

    public boolean removeAgainstEdge(AbstractEdge edge) {
        int anz = this.inArcs.size();
        int i = 0;
        while (i < anz) {
            if (edge == this.getAgainstEdge(i)) {
                this.inArcs.remove(edge);
                this.graph.removeTag(edge.getTag());
                return true;
            }
            ++i;
        }
        return false;
    }

    public AbstractGraph getGraph() {
        return this.graph;
    }

    public AbstractEdge getEdgeTo(AbstractNode nach) {
        int anz = this.getNumberOfEdges();
        int i = 0;
        while (i < anz) {
            AbstractEdge edge = this.getEdge(i);
            if (edge.getTarget() == nach) {
                return edge;
            }
            ++i;
        }
        return null;
    }

    public char getTag() {
        return this.bez;
    }

    public int getXPos() {
        return this.x;
    }

    public int getYPos() {
        return this.y;
    }

    public void moveTo(int x, int y) {
        this.x = x;
        this.y = y;
    }
}

