/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui;

import gfgaa.gui.GraphAlgGUI;
import gfgaa.gui.GraphDrawer;
import gfgaa.gui.MessageHandler;
import gfgaa.gui.components.ColorChooserComboBox;
import gfgaa.gui.components.SPanel;
import gfgaa.gui.exceptions.GraphTypeException;
import gfgaa.gui.graphs.AbstractGraph;
import gfgaa.gui.graphs.GraphEntry;
import gfgaa.gui.graphs.MatrixPanelInterface;
import gfgaa.gui.graphs.basic.BasicGraphEntry;
import gfgaa.gui.others.GraphDataBase;
import gfgaa.gui.others.LanguageInterface;
import gfgaa.gui.others.PanelManager;
import java.awt.Color;
import java.util.HashMap;

public final class GraphAlgController
implements LanguageInterface {
    private GraphDataBase gb;
    private PanelManager pm;
    private GraphAlgGUI gui;
    private GraphDrawer drawer;
    private MessageHandler messages;
    private boolean[] hintsEnabled;
    private int languageFlag = 0;
    private int transferMode = 0;

    public GraphAlgController() {
        new GraphAlgController(this.languageFlag);
    }

    public GraphAlgController(int languageFlag) {
        this.languageFlag = languageFlag;
        this.messages = new MessageHandler(this);
        this.hintsEnabled = new boolean[4];
        int i = 0;
        while (i < 4) {
            this.hintsEnabled[i] = true;
            ++i;
        }
        this.pm = new PanelManager();
        this.gb = new GraphDataBase(this);
        this.gb.addGraph(new BasicGraphEntry(this));
        this.gb.initialize();
        this.drawer = new GraphDrawer();
        this.gui = new GraphAlgGUI(this);
    }

    public void repaint() {
        if (this.gui != null) {
            this.gui.repaint();
        }
    }

    protected void setTopLevelPanel(int[] panelId) {
        this.gui.setTopLevelPanel(panelId);
    }

    public void setVisible(boolean isVisible) {
        this.gui.setVisible(isVisible);
    }

    public void addPanel(int pos, SPanel panel) {
        this.pm.addPanel(pos, panel);
    }

    public GraphDataBase getGraphDatabase() {
        return this.gb;
    }

    public AbstractGraph getGraph() {
        return this.gb.getSelectedGraph();
    }

    public Integer getGraphTyp() {
        return this.gb.getGraphTyp();
    }

    protected GraphDrawer getGraphDrawer() {
        return this.drawer;
    }

    public SPanel getPanel(int pos) {
        return this.pm.getPanel(pos);
    }

    public boolean showUserMessage(int messageId) {
        this.messages.setMessage(messageId);
        if (this.hintsEnabled[this.messages.getMessageType()]) {
            this.messages.setMessageVisible();
            return this.messages.getAnswer();
        }
        return true;
    }

    public int getTransferMode() {
        return this.transferMode;
    }

    protected void setTransferMode(int transferMode) {
        this.transferMode = transferMode;
    }

    public int getLanguageSettings() {
        return this.languageFlag;
    }

    protected void changeLanguageSettings(int languageFlag) {
        if (this.languageFlag != languageFlag) {
            this.languageFlag = languageFlag;
            this.gui.changeLanguageSettings(this.languageFlag);
            this.gb.changeLanguageSettings();
        }
    }

    protected boolean getHintsEnabeld(int pos) {
        return this.hintsEnabled[pos];
    }

    protected void setHintsEnabeld(int pos, boolean enabled) {
        this.hintsEnabled[pos] = enabled;
    }

    public void addGraph(GraphEntry entry) throws GraphTypeException {
        this.gb.addGraphType(entry);
    }

    public void setAlgoExcepFlag(boolean eFlag) {
        if (eFlag) {
            this.showUserMessage(12);
        }
    }

    public GraphAlgGUI getGUI() {
        return this.gui;
    }

    public int[][] getAdjacencyMatrix() {
        return ((MatrixPanelInterface)((Object)this.pm.getPanel(5))).getAdjacencyMatrix();
    }

    public String[] getGraphColorSettings() {
        Color[] graphColors = this.drawer.getColorSettings();
        int l = graphColors.length;
        String[] gracol = new String[l];
        int i = 0;
        while (i < l) {
            gracol[i] = ColorChooserComboBox.getStringForColor(graphColors[i]);
            ++i;
        }
        return gracol;
    }

    public HashMap getWeightLabelSet() {
        return this.drawer.getWeightLabelSet();
    }
}

