/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.sorting;

import algoanim.animalscript.AnimalScript;
import algoanim.exceptions.LineNotExistsException;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.IntArray;
import algoanim.primitives.Rect;
import algoanim.primitives.SourceCode;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.properties.ArrayProperties;
import algoanim.properties.RectProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;

public class ShakerSort2
implements Generator {
    private ArrayMarker downMarker;
    private ArrayMarker upMarker;
    private ArrayMarker leftMarker;
    private ArrayMarker rightMarker;
    private SourceCode source;
    private SourceCode intro;
    private Text swappedText;
    private static final String DESCRIPTION = "Shakersort is a variation of bubble sort that is both a stable sorting algorithm and a comparison sort. The algorithm differs from bubble sort in that sorts in both directions each pass through the list. This sorting algorithm is only marginally more difficult than bubble sort to implement, and solves the problem with so-called turtles in bubble sort. (taken from wikipedia) ";
    private static final String CODE = "static void shakerSort(int[] intArray) {\n boolean swapped;\n int left = 0; \n int right = intArray.length - 1;\n int complete = right;\n do {\n \tswapped = false;\n \tfor (int down = right; down > left; down--)\n \t\tif (intArray[down] < inAtrray[down - 1]) {\n \t\t\tswap(intArray, down, down-1);\n \t\t\tswapped = true;\n \t\t\tcomplete = down;\n \t\t}\n \tleft = complete;\n \tfor (int up = left; up < right; up++)\n \t\tif (intArray[up + 1] < intArray[up]) {\n \t\t\tswap(intArray, up, up+1);\n \t\t\tswapped = true;\n \t\t\tcomplete = up;\n \t\t}\n \tright = complete;\n } while (swapped);\n }";

    public void sort(IntArray ia, Language lang) {
        ia.hide();
        this.swappedText.hide();
        this.intro.addCodeLine("Shaker Sort, also known as 'Cocktail Sort' or 'Bidirectional Bubble Sort', is an ", null, 0, null);
        this.intro.addCodeLine("improved version of Bubble Sort.", null, 0, null);
        this.intro.addCodeLine("", null, 0, null);
        this.intro.addCodeLine("In contrast to Bubble Sort, Shaker Sort doesn't pass through the list from the bottom", null, 0, null);
        this.intro.addCodeLine("to the top in every single iteration. Instead it passes alternately through the list", null, 0, null);
        this.intro.addCodeLine("from the bottom to the top and from the top to the bottom. Shaker Sort has the same ", null, 0, null);
        this.intro.addCodeLine("complexity as Bubble sort - O(n\u2264) in Landau notation, but it can be slightly faster. ", null, 0, null);
        this.intro.addCodeLine("That's because bigger elements can be separated from smaller elements very fast. ", null, 0, null);
        this.intro.addCodeLine("While Bubble Sort can only move big elements to the top of the list, Shaker Sort ", null, 0, null);
        this.intro.addCodeLine("will also move small elements to the bottom.", null, 0, null);
        this.intro.addCodeLine("", null, 0, null);
        this.intro.addCodeLine("When passing trough the list, Shaker Sort always compares the current element to ", null, 0, null);
        this.intro.addCodeLine("the following element. In case those elements are out of order, both elements will be ", null, 0, null);
        this.intro.addCodeLine("exchanged. Hence Shaker Sort works 'in-place'. Elements at the bottom/top of the ", null, 0, null);
        this.intro.addCodeLine("list, which are already at their final position, will be skipped in the next pass. Once ", null, 0, null);
        this.intro.addCodeLine("Shaker Sort finishes a pass without exchanging any elements, it terminates.", null, 0, null);
        lang.nextStep();
        ia.show();
        this.intro.hide();
        this.rightMarker.hide();
        this.leftMarker.hide();
        this.downMarker.hide();
        this.upMarker.hide();
        this.source.addCodeLine("static void shakerSort(int[] intArray) {", null, 0, null);
        this.source.addCodeLine("boolean swapped;", null, 1, null);
        this.source.addCodeLine("int left = 0;", null, 1, null);
        this.source.addCodeLine("int right = intArray.length - 1;", null, 1, null);
        this.source.addCodeLine("int complete = right;", null, 1, null);
        this.source.addCodeLine("do {", null, 1, null);
        this.source.addCodeLine("swapped = false;", null, 2, null);
        this.source.addCodeLine("for (int down = right; down > left; down--)", null, 2, null);
        this.source.addCodeLine("if (intArray[down] < intArray[down - 1]) {", null, 3, null);
        this.source.addCodeLine("swap(intArray, down, down-1);", null, 4, null);
        this.source.addCodeLine("swapped = true;", null, 4, null);
        this.source.addCodeLine("complete = down;", null, 4, null);
        this.source.addCodeLine("}", null, 3, null);
        this.source.addCodeLine("left = complete;", null, 2, null);
        this.source.addCodeLine("for (int up = left; up < right; up++)", null, 2, null);
        this.source.addCodeLine("if(intArray[up + 1] < intArray[up]) {", null, 3, null);
        this.source.addCodeLine("swap(inArray,up, up+1);", null, 4, null);
        this.source.addCodeLine("swapped = true;", null, 4, null);
        this.source.addCodeLine("complete = up;", null, 4, null);
        this.source.addCodeLine("}", null, 3, null);
        this.source.addCodeLine("right = complete;", null, 2, null);
        this.source.addCodeLine("} while (swapped);", null, 1, null);
        this.source.addCodeLine("}", null, 0, null);
        lang.nextStep();
        try {
            this.shakerSort(ia, this.source, 0, ia.getLength() - 1, lang);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
    }

    private void shakerSort(IntArray ia, SourceCode codeSupport, int i, int j, Language lang) {
        boolean swapped;
        codeSupport.highlight(0);
        lang.nextStep();
        codeSupport.unhighlight(0);
        codeSupport.highlight(1);
        this.swappedText.show();
        this.swappedText.changeColor(null, Color.RED, null, null);
        lang.nextStep();
        this.swappedText.changeColor(null, Color.BLACK, null, null);
        codeSupport.unhighlight(1);
        codeSupport.highlight(2);
        this.leftMarker.move(0, null, null);
        this.leftMarker.show();
        lang.nextStep();
        codeSupport.unhighlight(2);
        codeSupport.highlight(3);
        this.rightMarker.move(ia.getLength() - 1, null, null);
        this.rightMarker.show();
        lang.nextStep();
        codeSupport.unhighlight(3);
        codeSupport.highlight(4);
        int complete = this.rightMarker.getPosition();
        ia.highlightCell(complete, null, null);
        lang.nextStep();
        codeSupport.unhighlight(4);
        do {
            codeSupport.highlight(5);
            lang.nextStep();
            codeSupport.unhighlight(5);
            this.swappedText.changeColor(null, Color.RED, null, null);
            swapped = false;
            this.swappedText.setText("swapped: " + String.valueOf(swapped), null, null);
            codeSupport.highlight(6);
            lang.nextStep();
            this.swappedText.changeColor(null, Color.BLACK, null, null);
            codeSupport.unhighlight(6);
            this.downMarker.show();
            this.downMarker.move(this.rightMarker.getPosition(), null, null);
            while (this.downMarker.getPosition() > this.leftMarker.getPosition()) {
                codeSupport.highlight(7);
                lang.nextStep();
                codeSupport.unhighlight(7);
                codeSupport.highlight(8);
                ia.highlightElem(this.downMarker.getPosition() - 1, this.downMarker.getPosition(), null, null);
                lang.nextStep();
                codeSupport.unhighlight(8);
                if (ia.getData(this.downMarker.getPosition()) < ia.getData(this.downMarker.getPosition() - 1)) {
                    codeSupport.highlight(9);
                    ia.unhighlightCell(0, ia.getLength() - 1, null, null);
                    ia.swap(this.downMarker.getPosition(), this.downMarker.getPosition() - 1, null, null);
                    ia.highlightCell(complete, null, null);
                    lang.nextStep();
                    codeSupport.unhighlight(9);
                    codeSupport.highlight(10);
                    swapped = true;
                    this.swappedText.setText("swapped: " + String.valueOf(swapped), null, null);
                    this.swappedText.changeColor(null, Color.RED, null, null);
                    lang.nextStep();
                    this.swappedText.changeColor(null, Color.BLACK, null, null);
                    codeSupport.unhighlight(10);
                    codeSupport.highlight(11);
                    ia.unhighlightCell(complete, null, null);
                    complete = this.downMarker.getPosition();
                    ia.highlightCell(complete, null, null);
                    lang.nextStep();
                    codeSupport.unhighlight(11);
                }
                ia.unhighlightElem(this.downMarker.getPosition() - 1, this.downMarker.getPosition(), null, null);
                codeSupport.highlight(12);
                lang.nextStep();
                codeSupport.unhighlight(12);
                this.downMarker.decrement(null, null);
            }
            this.downMarker.hide();
            this.leftMarker.move(complete, null, null);
            codeSupport.highlight(13);
            lang.nextStep();
            codeSupport.unhighlight(13);
            this.upMarker.show();
            this.upMarker.move(this.leftMarker.getPosition(), null, null);
            while (this.upMarker.getPosition() < this.rightMarker.getPosition()) {
                codeSupport.highlight(14);
                lang.nextStep();
                codeSupport.unhighlight(14);
                codeSupport.highlight(15);
                lang.nextStep();
                ia.highlightElem(this.upMarker.getPosition(), this.upMarker.getPosition() + 1, null, null);
                lang.nextStep();
                codeSupport.unhighlight(15);
                if (ia.getData(this.upMarker.getPosition() + 1) < ia.getData(this.upMarker.getPosition())) {
                    codeSupport.highlight(16);
                    ia.unhighlightCell(0, ia.getLength() - 1, null, null);
                    ia.swap(this.upMarker.getPosition(), this.upMarker.getPosition() + 1, null, null);
                    ia.highlightCell(complete, null, null);
                    lang.nextStep();
                    codeSupport.unhighlight(16);
                    codeSupport.highlight(17);
                    swapped = true;
                    this.swappedText.setText("swapped: " + String.valueOf(swapped), null, null);
                    this.swappedText.changeColor(null, Color.RED, null, null);
                    lang.nextStep();
                    this.swappedText.changeColor(null, Color.BLACK, null, null);
                    codeSupport.unhighlight(17);
                    codeSupport.highlight(18);
                    ia.unhighlightCell(complete, null, null);
                    complete = this.upMarker.getPosition();
                    ia.highlightCell(complete, null, null);
                    lang.nextStep();
                    codeSupport.unhighlight(18);
                }
                codeSupport.highlight(19);
                ia.unhighlightElem(this.upMarker.getPosition(), this.upMarker.getPosition() + 1, null, null);
                lang.nextStep();
                codeSupport.unhighlight(19);
                this.upMarker.increment(null, null);
            }
            this.upMarker.hide();
            codeSupport.highlight(20);
            this.rightMarker.move(complete, null, null);
            lang.nextStep();
            codeSupport.unhighlight(20);
            codeSupport.highlight(21);
            this.swappedText.changeColor(null, Color.RED, null, null);
            lang.nextStep();
            this.swappedText.changeColor(null, Color.BLACK, null, null);
            codeSupport.unhighlight(21);
        } while (swapped);
        codeSupport.highlight(22);
        lang.nextStep();
        codeSupport.unhighlight(22);
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        AnimalScript lang = new AnimalScript("ShakerSort Animation", "trickSoft", 640, 480);
        ((Language)lang).setStepMode(true);
        RectProperties rectProps = new RectProperties();
        rectProps.set("fillColor", Color.LIGHT_GRAY);
        rectProps.set("filled", true);
        TextProperties textProps = new TextProperties();
        textProps.set("font", new Font("SansSerif", 1, 24));
        Rect textBox = ((Language)lang).newRect(new Coordinates(60, 10), new Coordinates(230, 55), "Box", null, rectProps);
        Text nameText = ((Language)lang).newText(new Coordinates(82, 28), "ShakerSort", "nameLabelOnTop", null, textProps);
        int[] arrayData = (int[])primitives.get("Input Data");
        IntArray array = ((Language)lang).newIntArray(new Coordinates(60, 130), arrayData, "My Array", null, (ArrayProperties)props.getPropertiesByName("Array"));
        this.downMarker = ((Language)lang).newArrayMarker(array, arrayData.length, "down", null, (ArrayMarkerProperties)props.getPropertiesByName("Down Arrow"));
        this.upMarker = ((Language)lang).newArrayMarker(array, arrayData.length, "up", null, (ArrayMarkerProperties)props.getPropertiesByName("Up Arrow"));
        this.leftMarker = ((Language)lang).newArrayMarker(array, arrayData.length, "l", null, (ArrayMarkerProperties)props.getPropertiesByName("Left Arrow"));
        this.rightMarker = ((Language)lang).newArrayMarker(array, arrayData.length, "r", null, (ArrayMarkerProperties)props.getPropertiesByName("Right Arrow"));
        this.swappedText = lang.newText(new Coordinates(100, 170), "swapped: ", "swappedText", null);
        this.source = ((Language)lang).newSourceCode(new Coordinates(60, 190), "Source Code", null, (SourceCodeProperties)props.getPropertiesByName("Source Code"));
        this.intro = ((Language)lang).newSourceCode(new Coordinates(60, 90), "Intro Text", null, (SourceCodeProperties)props.getPropertiesByName("Intro Text"));
        this.sort(array, lang);
        return ((Object)lang).toString();
    }

    @Override
    public String getAlgorithmName() {
        return "ShakerSort";
    }

    @Override
    public String getCodeExample() {
        return CODE;
    }

    @Override
    public Locale getContentLocale() {
        return Locale.US;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(1);
    }

    @Override
    public String getName() {
        return "ShakerSort";
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    public static void main(String[] args) {
        String outname = "C:\\Test.asu";
        AnimationPropertiesContainer props = new AnimationPropertiesContainer();
        Hashtable<String, Object> primitives = new Hashtable<String, Object>();
        int[] array = new int[]{8, 7, 6, 5, 4, 3, 2, 1};
        primitives.put("Input Data", array);
        ArrayProperties aprops = new ArrayProperties();
        aprops.setName("Array");
        aprops.set("fillColor", Color.LIGHT_GRAY);
        aprops.set("elemHighlight", Color.CYAN);
        aprops.set("cellHighlight", Color.ORANGE);
        props.add(aprops);
        ArrayMarkerProperties mprops = new ArrayMarkerProperties();
        mprops.setName("Down Arrow");
        mprops.set("label", "Down");
        props.add(mprops);
        mprops = new ArrayMarkerProperties();
        mprops.setName("Up Arrow");
        mprops.set("label", "Up");
        props.add(mprops);
        mprops = new ArrayMarkerProperties();
        mprops.set("color", Color.RED);
        mprops.set("label", "L");
        mprops.setName("Left Arrow");
        props.add(mprops);
        mprops = new ArrayMarkerProperties();
        mprops.set("color", Color.RED);
        mprops.set("label", "R");
        mprops.setName("Right Arrow");
        props.add(mprops);
        SourceCodeProperties sprops = new SourceCodeProperties();
        sprops.setName("Source Code");
        sprops.set("highlightColor", Color.RED);
        props.add(sprops);
        sprops = new SourceCodeProperties();
        sprops.setName("Intro Text");
        sprops.set("font", new Font("SansSerif", 1, 15));
        props.add(sprops);
        ShakerSort2 test = new ShakerSort2();
        String script = test.generate(props, primitives);
        System.out.println(script);
        try {
            FileWriter fileWriter = new FileWriter("C:\\Test.asu");
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.append(script);
            bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getAnimationAuthor() {
        return "Daniel Trick, Jonathan R\u00f6mer, Florian Jung";
    }

    @Override
    public void init() {
    }
}

