/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.sorting;

import algoanim.animalscript.AnimalScript;
import algoanim.primitives.Rect;
import algoanim.primitives.SourceCode;
import algoanim.primitives.StringMatrix;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.MatrixProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import algoanim.util.Offset;
import algoanim.util.TicksTiming;
import algoanim.util.Timing;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Locale;

public class RadixSort
implements Generator {
    private Language l = new AnimalScript("RadixSort Animation", "Ioannis Tsigaridas & Manuel Wick", 800, 600);
    private StringMatrix matrix;
    private static final String ST = ". Stelle wird sortiert";
    private Text text;
    private Text rectText;
    private Text partCollText;
    private static final Timing StandardTiming = new TicksTiming(40);
    private static final String SOURCE_CODE = "";
    private static final String DESCRIPTION = "";

    public RadixSort() {
        this.l.setStepMode(true);
    }

    public void sort(int[] keys) {
        SourceCodeProperties titleProps = new SourceCodeProperties();
        titleProps.set("font", new Font("Monospaced", 1, 16));
        titleProps.set("highlightColor", Color.green);
        SourceCode title = this.l.newSourceCode(new Coordinates(30, 20), "sourceCode", null, titleProps);
        title.addCodeLine("Radixsort", null, 0, null);
        title.addCodeLine("", null, 0, null);
        title.addCodeLine("Radixsort ist ein stabiles Sortierverfahren. Die Idee dabei ist nach", null, 0, null);
        title.addCodeLine("jedem Zeichen des Keys zu sortiern. Zuerst wird nach der letzten Stelle sortiert,", null, 0, null);
        title.addCodeLine("dann nach der vorletzten Stelle usw...", null, 0, null);
        title.addCodeLine("", null, 0, null);
        title.addCodeLine("Dieser Sortiervorgang besteht aus zwei Phasen, die sich immer abwechseln.", null, 0, null);
        title.addCodeLine("Das ist die Partitionierungsphase und die Sammelphase.", null, 0, null);
        title.addCodeLine("In der Partitionierungsphase werden die Keys auf F\u2030cher(Zahlen von 0 bis 9)aufgeteilt.", null, 0, null);
        title.addCodeLine("In der Sammelphase werden die Keys von den F\u2030chern(Zahlen von 0 bis 9) in Reihenfolge", null, 0, null);
        title.addCodeLine("vom niederwertigsten aufgesammelt. Diese zwei Phasen werden solange durchgef\u00b8hrt bis alle Stellen(Ziffern)", null, 0, null);
        title.addCodeLine("untersucht worden sind. In der letzten Iteration nach dem Aufsammeln fuer die erste Stelle der Keys sind", null, 0, null);
        title.addCodeLine("die Keys aufsteigend sortiert.", null, 0, null);
        this.l.nextStep();
        title.hide();
        String[][] matrixKeys = new String[13][keys.length + 1];
        int i = 0;
        while (i < matrixKeys.length) {
            int j = 0;
            while (j < matrixKeys[0].length) {
                matrixKeys[i][j] = "";
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < keys.length) {
            matrixKeys[0][1 + i] = String.valueOf(keys[i]);
            ++i;
        }
        int n = 0;
        int i2 = 3;
        while (i2 < 13) {
            matrixKeys[i2][0] = String.valueOf(n);
            ++n;
            ++i2;
        }
        this.partCollText = this.l.newText(new Coordinates(50, 50), "RadixSort", "partcoll", null);
        this.text = this.l.newText(new Offset(0, 50, "partcoll", "NW"), "1. Stelle wird sortiert", "st", null);
        TextProperties textProps = new TextProperties();
        textProps.set("color", Color.RED);
        this.rectText = this.l.newText(new Offset(30, 0, "st", "NE"), "", "rectText", null, textProps);
        Rect rect = this.l.newRect(new Offset(-5, -5, "rectText", "NW"), new Offset(10, 10, "rectText", "SE"), "rect", null);
        MatrixProperties matrixProps = new MatrixProperties();
        matrixProps.set("fillColor", Color.WHITE);
        matrixProps.set("filled", true);
        matrixProps.set("elemHighlight", Color.RED);
        matrixProps.set("cellHighlight", Color.WHITE);
        matrixProps.set("color", Color.WHITE);
        this.matrix = this.l.newStringMatrix(new Offset(0, 40, "st", "SW"), matrixKeys, "matrix", null, matrixProps);
        int i3 = this.matrix.getElement(0, 1).length() - 1;
        while (i3 >= 0) {
            this.text.setText(String.valueOf(this.matrix.getElement(0, 1).length() - i3) + ST, null, null);
            this.partition(i3);
            this.collect();
            --i3;
        }
        this.partCollText.setText("Schl\u221a\u00bassel fertig sortiert", null, StandardTiming);
    }

    private void partition(int literalPos) {
        this.partCollText.setText("Partitionierungsphase", null, StandardTiming);
        int i = 1;
        while (i < this.matrix.getNrCols()) {
            this.setKey(i, literalPos);
            ++i;
        }
    }

    private void collect() {
        int keyPos = 1;
        this.partCollText.setText("Sammelphase", null, StandardTiming);
        int j = 3;
        while (j < this.matrix.getNrRows()) {
            int i = 1;
            while (i < this.matrix.getNrCols() - 1) {
                if (this.matrix.getElement(j, i).compareTo("") != 0) {
                    this.l.nextStep();
                    this.matrix.swap(j, i, 0, keyPos, null, new TicksTiming(40));
                    ++keyPos;
                }
                ++i;
            }
            ++j;
        }
    }

    private void setKey(int keyPos, int literalPos) {
        this.l.nextStep();
        String str = this.matrix.getElement(0, keyPos);
        String chr = String.valueOf(str.charAt(literalPos));
        this.rectText.setText(chr, null, null);
        int i = Integer.valueOf(chr);
        this.set(keyPos, i);
    }

    private void set(int keyPos, int targetPos) {
        targetPos += 3;
        int i = 1;
        while (i < this.matrix.getNrCols() - 1) {
            if (this.matrix.getElement(targetPos, i).compareTo("") == 0) break;
            ++i;
        }
        this.matrix.swap(0, keyPos, targetPos, i, null, new TicksTiming(40));
    }

    public static void main(String[] args) {
        RadixSort radix = new RadixSort();
        Hashtable<String, Object> arg1 = new Hashtable<String, Object>();
        int keyNumber = 4;
        int[] keys = new int[keyNumber];
        int i = 0;
        while (i < keyNumber) {
            int key;
            while (String.valueOf(key = (int)Math.floor(Math.random() * 1000.0)).length() < 3) {
            }
            keys[i] = key;
            ++i;
        }
        arg1.put("keys", keys);
        System.out.println(radix.generate(null, arg1));
    }

    @Override
    public String generate(AnimationPropertiesContainer arg0, Hashtable<String, Object> arg1) {
        int[] keys = (int[])arg1.get("keys");
        this.sort(keys);
        return this.l.toString();
    }

    @Override
    public String getAlgorithmName() {
        return "RadixSort";
    }

    @Override
    public String getCodeExample() {
        return "";
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(1);
    }

    @Override
    public String getName() {
        return "RadixSort";
    }

    @Override
    public String getOutputLanguage() {
        return "Pseudo-Code";
    }

    @Override
    public String getAnimationAuthor() {
        return "Manuel Wick, Ioannis Tsigaridas";
    }

    @Override
    public void init() {
    }
}

