/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.sorting;

import algoanim.animalscript.AnimalScript;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.IntArray;
import algoanim.primitives.Polyline;
import algoanim.primitives.Rect;
import algoanim.primitives.SourceCode;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.properties.ArrayProperties;
import algoanim.properties.PolylineProperties;
import algoanim.properties.RectProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import algoanim.util.Node;
import algoanim.util.TicksTiming;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;

public class Heapsort2
implements Generator {
    private static Language lang;
    private final String SOURCE_CODE = "public static void sort(int[] a0) \n{\n\ta=a0;\n\tn=a.length;\n\theapsort();\n}\n\nprivate static void heapsort()\n{\n\tbuildheap();\n\twhile (n>1)\n\t{\n\t\tn--;\n\t\texchange (0, n);\n\t\tdownheap (0);\n\t}\n}\n\nprivate static void buildheap()\n{\n\tfor (int v=n/2-1; v>=0; v--)\n\t\tdownheap (v);\n}\n\nprivate static void downheap(int v)\n{\n\tint w=2*v+1;    // first descendant of v\n\twhile (w<n)\n\t{\n\t\tif (w+1<n)    // is there a second descendant?\n\t\t\tif (a[w+1]>a[w]) w++;  // w is the descendant of v with maximum label\n\t\tif (a[v]>=a[w]) return;  // v has heap property\n\t\t// otherwise\n\t\texchange(v, w);  // exchange labels of v and w\n\t\tv=w;        // continue\n\t\tw=2*v+1;\n\t}\n}\n\nprivate static void exchange(int i, int j)\n{\n\tint t=a[i];\n\ta[i]=a[j];\n\ta[j]=t;\n}\n\n";
    private final String DESCRIPTION = "Heapsort (method) is a comparison-based sorting algorithm, and is part of the selection sort family. Although somewhat slower in practice on most machines than a good implementation of quicksort, it has the advantage of a worst-case O(n log n) runtime. Heapsort inserts the input list elements into a heap data structure. The largest value (in a max-heap) or the smallest value (in a min-heap) are extracted until none remain, the values having been extracted in sorted order. The heap's invariant is preserved after each extraction, so the only cost is that of extraction During extraction, the only space required is that needed to store the heap. In order to achieve constant space overhead, the heap is stored in the part of the input array that has not yet been sorted. (The structure of this heap is described at Binary heap: Heap implementation.) Heapsort uses two heap operations: insertion and root deletion. Each extraction places an element in the last empty location of the array. The remaining prefix of the array stores the unsorted elements. (Source: Wikipedia)";
    private final String desc1 = "Heapsort (method) is a comparison-based sorting algorithm, and is part of the";
    private final String desc2 = "selection sort family. Although somewhat slower in practice on most machines than";
    private final String desc3 = "a good implementation of quicksort, it has the advantage of a worst-case O(n log n)";
    private final String desc4 = "runtime. Heapsort inserts the input list elements into a heap data structure. The largest";
    private final String desc5 = "value (in a max-heap) or the smallest value (in a min-heap) are extracted until none remain,";
    private final String desc6 = "the values having been extracted in sorted order. The heap's invariant is preserved after";
    private final String desc7 = "each extraction, so the only cost is that of extraction During extraction, the only space";
    private final String desc8 = "required is that needed to store the heap. In order to achieve constant space overhead, the";
    private final String desc9 = "heap is stored in the part of the input array that has not yet been sorted. Heapsort uses two";
    private final String desc10 = "heap operations: insertion and root deletion. Each extraction places an element in the last";
    private final String desc11 = "empty location of the array. The remaining prefix of the array stores the unsorted elements.";
    private final String desc12 = "";
    private final String desc13 = "                                                    Source: Wikipedia";
    private static SourceCode scSort;
    private static SourceCode scBuildheap;
    private static SourceCode scDownheap;
    private static SourceCode scExchange;
    private static IntArray intArray;
    private static int n;
    private static int arrayN;
    private static Text nIndex;
    private static Text vIndex;
    private static Text wIndex;
    private static Text vLocalIndex;
    private static ArrayMarker nMarker;
    private static ArrayMarker vMarker;
    private static ArrayMarker wMarker;
    private static ArrayMarker vLocalMarker;
    private static Text[] tree;
    private static int originalXcoordTree;
    private static int originalYcoordTree;

    static {
        originalXcoordTree = 500;
        originalYcoordTree = 420;
    }

    private Heapsort2(Language lang) {
        Heapsort2.lang = lang;
    }

    public Heapsort2() {
        lang = new AnimalScript("Caesar-Chiffre", "Henrik Schr\u00f6der, Nedislav Nedyalkov, Latinka Pavlova", 1024, 768);
    }

    @Override
    public String generate(AnimationPropertiesContainer arg0, Hashtable<String, Object> arg1) {
        AnimalScript lang = new AnimalScript("Heapsort", "Henrik Schr\u00f6der, Nedislav Nedyalkov, Latinka Pavlova", 1024, 768);
        new Heapsort2(lang);
        ((Language)lang).setStepMode(true);
        RectProperties rp = new RectProperties();
        rp.set("fillColor", Color.YELLOW);
        rp.set("filled", Boolean.TRUE);
        ((Language)lang).newRect(new Coordinates(120, 5), new Coordinates(260, 36), "HeaderRect", null, rp);
        TextProperties tp = new TextProperties();
        tp.set("font", new Font("Monospaced", 1, 20));
        ((Language)lang).newText(new Coordinates(140, 10), "Heapsort", "Header", null, tp);
        lang.nextStep();
        RectProperties rpd = new RectProperties();
        rpd.set("color", Color.CYAN);
        Rect r1 = lang.newRect(new Coordinates(40, 140), new Coordinates(552, 372), "descr", null);
        Rect r2 = lang.newRect(new Coordinates(42, 142), new Coordinates(550, 370), "descr", null);
        Rect r3 = ((Language)lang).newRect(new Coordinates(41, 141), new Coordinates(551, 371), "descr", null, rpd);
        SourceCodeProperties scProperties = new SourceCodeProperties();
        scProperties.set("color", Color.WHITE);
        SourceCode s = lang.newSourceCode(new Coordinates(50, 150), "desc", null);
        s.addCodeLine("Heapsort (method) is a comparison-based sorting algorithm, and is part of the", null, 0, new TicksTiming(25));
        s.addCodeLine("selection sort family. Although somewhat slower in practice on most machines than", null, 0, new TicksTiming(20));
        s.addCodeLine("a good implementation of quicksort, it has the advantage of a worst-case O(n log n)", null, 0, new TicksTiming(15));
        s.addCodeLine("runtime. Heapsort inserts the input list elements into a heap data structure. The largest", null, 0, new TicksTiming(10));
        s.addCodeLine("value (in a max-heap) or the smallest value (in a min-heap) are extracted until none remain,", null, 0, new TicksTiming(5));
        s.addCodeLine("the values having been extracted in sorted order. The heap's invariant is preserved after", null, 0, new TicksTiming(0));
        s.addCodeLine("each extraction, so the only cost is that of extraction During extraction, the only space", null, 0, new TicksTiming(5));
        s.addCodeLine("required is that needed to store the heap. In order to achieve constant space overhead, the", null, 0, new TicksTiming(10));
        s.addCodeLine("heap is stored in the part of the input array that has not yet been sorted. Heapsort uses two", null, 0, new TicksTiming(15));
        s.addCodeLine("heap operations: insertion and root deletion. Each extraction places an element in the last", null, 0, new TicksTiming(20));
        s.addCodeLine("empty location of the array. The remaining prefix of the array stores the unsorted elements.", null, 0, new TicksTiming(25));
        s.addCodeLine("", null, 0, new TicksTiming(30));
        s.addCodeLine("                                                    Source: Wikipedia", null, 0, new TicksTiming(35));
        lang.nextStep();
        s.hide(new TicksTiming(500));
        r1.hide(new TicksTiming(500));
        r2.hide(new TicksTiming(500));
        r3.hide(new TicksTiming(500));
        lang.nextStep();
        ((Language)lang).newRect(new Coordinates(60, 125), new Coordinates(300, 125), "line", null, rp);
        ((Language)lang).newRect(new Coordinates(390, 5), new Coordinates(390, 400), "vertLine", null, rp);
        scSort = ((Language)lang).newSourceCode(new Coordinates(80, 120), "sourceCode", null, (SourceCodeProperties)arg0.getPropertiesByName("main_sourceCode"));
        scSort.addCodeLine("private static void sort()", null, 0, null);
        scSort.addCodeLine("{", null, 0, null);
        scSort.addCodeLine("    buildheap();", null, 0, null);
        scSort.addCodeLine("    while (n>1)", null, 0, null);
        scSort.addCodeLine("    {", null, 0, null);
        scSort.addCodeLine("        n--;", null, 0, null);
        scSort.addCodeLine("        exchange (0, n);", null, 0, null);
        scSort.addCodeLine("        downheap (0);", null, 0, null);
        scSort.addCodeLine("    }", null, 0, null);
        scSort.addCodeLine("}", null, 0, null);
        scBuildheap = ((Language)lang).newSourceCode(new Coordinates(400, 0), "sourceCode2", null, (SourceCodeProperties)arg0.getPropertiesByName("methods_sourceCode"));
        scBuildheap.addCodeLine(" -> private static void buildheap() {", null, 0, null);
        scBuildheap.addCodeLine("        for (int v=n/2-1; v>=0; v--)", null, 0, null);
        scBuildheap.addCodeLine("            downheap (v);", null, 0, null);
        scBuildheap.addCodeLine("    }", null, 0, null);
        rp.set("color", Color.BLUE);
        rp.set("fillColor", new Color(224, 224, 255));
        ((Language)lang).newRect(new Coordinates(835, 30), new Coordinates(950, 55), "vrect", null, rp);
        tp.set("font", new Font("Monospaced", 0, 12));
        tp.set("color", Color.BLUE);
        vIndex = ((Language)lang).newText(new Coordinates(840, 30), "current v = _", "v", null, tp);
        scDownheap = ((Language)lang).newSourceCode(new Coordinates(400, 75), "sourceCode3", null, (SourceCodeProperties)arg0.getPropertiesByName("methods_sourceCode"));
        scDownheap.addCodeLine(" -> private static void downheap(int v') {", null, 0, null);
        scDownheap.addCodeLine("        int w=2*v'+1;    // first descendant of v'", null, 0, null);
        scDownheap.addCodeLine("        while (w<n)", null, 0, null);
        scDownheap.addCodeLine("        {", null, 0, null);
        scDownheap.addCodeLine("            if (w+1<n)    // is there a second descendant?", null, 0, null);
        scDownheap.addCodeLine("                if (a[w+1] > a[w]) w++;              // w-the descendant of v' with max label", null, 0, null);
        scDownheap.addCodeLine("            if (a[v'] >= a[w])", null, 0, null);
        scDownheap.addCodeLine("                return;      // v' has heap property", null, 0, null);
        scDownheap.addCodeLine("            exchange(v', w);  // exchange labels of v' and w", null, 0, null);
        scDownheap.addCodeLine("            v'=w;        // continue", null, 0, null);
        scDownheap.addCodeLine("            w=2*v'+1;", null, 0, null);
        scDownheap.addCodeLine("        }", null, 0, null);
        scDownheap.addCodeLine("    }", null, 0, null);
        ((Language)lang).newRect(new Coordinates(835, 110), new Coordinates(960, 150), "vrect", null, rp);
        wIndex = ((Language)lang).newText(new Coordinates(840, 110), "current w = _", "w", null, tp);
        vLocalIndex = ((Language)lang).newText(new Coordinates(840, 130), "v' = _", "vLocal", null, tp);
        scExchange = ((Language)lang).newSourceCode(new Coordinates(400, 310), "sourceCode4", null, (SourceCodeProperties)arg0.getPropertiesByName("methods_sourceCode"));
        scExchange.addCodeLine(" -> private void exchange(int i, int j) {", null, 0, null);
        scExchange.addCodeLine("       int t=a[i];    // first descendant of v", null, 0, null);
        scExchange.addCodeLine("       a[i] = a[j];", null, 0, null);
        scExchange.addCodeLine("       a[j] = t;", null, 0, null);
        scExchange.addCodeLine("    }", null, 0, null);
        int[] array = (int[])arg1.get("Unsorted_Numbers(maxValue=100,maxCount=15)");
        ArrayList<Integer> alNumbers = new ArrayList<Integer>(array.length);
        int i = 0;
        while (i < array.length) {
            if (array[i] < 100) {
                alNumbers.add(array[i]);
            }
            if (alNumbers.size() >= 15) break;
            ++i;
        }
        array = new int[alNumbers.size()];
        i = 0;
        while (i < alNumbers.size()) {
            array[i] = (Integer)alNumbers.get(i);
            ++i;
        }
        Heapsort2.heapsort(array, (ArrayProperties)arg0.getPropertiesByName("array"));
        String st = ((Object)lang).toString();
        return st;
    }

    private static void heapsort(int[] array, ArrayProperties arProp) {
        intArray = lang.newIntArray(new Coordinates(80, 410), array, "SortArray", null, arProp);
        n = array.length;
        arrayN = n - 1;
        RectProperties rp = new RectProperties();
        rp.set("color", Color.BLUE);
        rp.set("fillColor", new Color(224, 224, 255));
        rp.set("filled", Boolean.TRUE);
        lang.newRect(new Coordinates(265, 185), new Coordinates(370, 210), "curnrect", null, rp);
        TextProperties tp = new TextProperties();
        tp.set("font", new Font("Monospaced", 0, 12));
        tp.set("color", Color.BLUE);
        nIndex = lang.newText(new Coordinates(270, 185), "current n = " + n, "text1", null, tp);
        tree = new Text[n];
        int i = 0;
        while (i < tree.length) {
            double x;
            double p = 0.0;
            if (i == 0) {
                Heapsort2.tree[i] = lang.newText(new Coordinates(originalXcoordTree, originalYcoordTree), new Integer(intArray.getData(i)).toString(), new Integer(intArray.getData(i)).toString(), null);
            } else if (i == 1 || i == 2) {
                p = 1.5;
                x = (double)originalXcoordTree - 160.0 * (p -= (double)i);
                Heapsort2.tree[i] = lang.newText(new Coordinates((int)x, originalYcoordTree + 30), new Integer(intArray.getData(i)).toString(), new Integer(intArray.getData(i)).toString(), null);
            } else if (i >= 3 && i <= 6) {
                p = 4.5;
                x = (double)originalXcoordTree - 80.0 * (p -= (double)i);
                Heapsort2.tree[i] = lang.newText(new Coordinates((int)x, originalYcoordTree + 60), new Integer(intArray.getData(i)).toString(), new Integer(intArray.getData(i)).toString(), null);
            } else if (i >= 7 && i <= 14) {
                p = 10.5;
                x = (double)originalXcoordTree - 40.0 * (p -= (double)i);
                Heapsort2.tree[i] = lang.newText(new Coordinates((int)x, originalYcoordTree + 90), new Integer(intArray.getData(i)).toString(), new Integer(intArray.getData(i)).toString(), null);
            } else if (i >= 15 && i <= 30) {
                p = 22.5;
                x = (double)originalXcoordTree - 20.0 * (p -= (double)i);
                Heapsort2.tree[i] = lang.newText(new Coordinates((int)x, originalYcoordTree + 120), new Integer(intArray.getData(i)).toString(), new Integer(intArray.getData(i)).toString(), null);
            }
            ++i;
        }
        PolylineProperties pp = new PolylineProperties();
        pp.set("color", Color.LIGHT_GRAY);
        int i2 = 0;
        while (i2 < tree.length) {
            if (2 * i2 + 1 < tree.length) {
                lang.newPolyline(new Node[]{tree[i2].getUpperLeft(), tree[2 * i2 + 1].getUpperLeft()}, "line1: " + i2, null, pp);
            }
            if (2 * i2 + 2 < tree.length) {
                lang.newPolyline(new Node[]{tree[i2].getUpperLeft(), tree[2 * i2 + 2].getUpperLeft()}, "line2: " + i2, null, pp);
            }
            ++i2;
        }
        lang.nextStep();
        ArrayMarkerProperties amn = new ArrayMarkerProperties();
        amn.set("color", Color.BLACK);
        amn.set("label", "n");
        nMarker = lang.newArrayMarker(intArray, n - 1, "n", null, amn);
        nMarker.hide();
        amn.set("color", Color.BLUE);
        amn.set("label", "v");
        vMarker = lang.newArrayMarker(intArray, n / 2 - 1, "vMarker", null, amn);
        vMarker.hide();
        amn.set("color", Color.RED);
        amn.set("label", "w");
        wMarker = lang.newArrayMarker(intArray, n / 2 - 1, "wMarker", null, amn);
        wMarker.hide();
        amn.set("label", "v'");
        vLocalMarker = lang.newArrayMarker(intArray, n / 2 - 1, "vLocalMarker", null, amn);
        vLocalMarker.hide();
        Heapsort2.sort();
        lang.setStepMode(true);
        scSort.unhighlight(0);
        scSort.unhighlight(1);
        scSort.unhighlight(9);
        intArray.highlightCell(0, null, null);
        rp.set("color", Color.RED);
        rp.set("filled", Boolean.FALSE);
        lang.newRect(new Coordinates(originalXcoordTree - 5, originalYcoordTree), new Coordinates(originalXcoordTree + 17, originalYcoordTree + 17), "root", null, rp);
        tree[0].setFont(new Font("Serif", 1, 13), null, new TicksTiming(50));
        tp.set("font", new Font("Monospaced", 1, 16));
        tp.set("color", Color.RED);
        lang.newText(new Coordinates(80, 370), "SORTED", "sorted", null, tp);
        lang.nextStep();
        lang.setStepMode(false);
    }

    private static void sort() {
        scSort.highlight(0);
        scSort.highlight(1);
        scSort.highlight(9);
        scSort.highlight(2);
        scBuildheap.highlight(0);
        lang.nextStep();
        lang.setStepMode(false);
        Heapsort2.buildheap();
        lang.setStepMode(true);
        scBuildheap.unhighlight(0);
        scSort.unhighlight(2);
        scSort.highlight(3);
        scSort.highlight(4);
        scSort.highlight(8);
        lang.nextStep();
        lang.setStepMode(false);
        while (n > 1) {
            lang.setStepMode(true);
            scSort.highlight(5);
            nIndex.setText("current n = " + --n, null, null);
            if (arrayN == n) {
                nMarker.show();
            } else {
                nMarker.move(n, null, new TicksTiming(50));
            }
            lang.nextStep();
            scSort.unhighlight(5);
            scSort.highlight(6);
            scExchange.highlight(0);
            scExchange.highlight(1);
            scExchange.highlight(2);
            scExchange.highlight(3);
            scExchange.highlight(4);
            lang.nextStep();
            Heapsort2.exchange(0, n);
            scSort.unhighlight(6);
            scExchange.unhighlight(0);
            scExchange.unhighlight(1);
            scExchange.unhighlight(2);
            scExchange.unhighlight(3);
            scExchange.unhighlight(4);
            intArray.highlightCell(n, null, new TicksTiming(50));
            tree[n].setFont(new Font("Serif", 1, 13), null, new TicksTiming(50));
            double p = 0.0;
            double x = 0.0;
            double y = 0.0;
            if (n == 0) {
                x = originalXcoordTree;
                y = originalYcoordTree;
            } else if (n == 1 || n == 2) {
                p = 1.5;
                x = (double)originalXcoordTree - 160.0 * (p -= (double)n);
                y = originalYcoordTree + 30;
            } else if (n >= 3 && n <= 6) {
                p = 4.5;
                x = (double)originalXcoordTree - 80.0 * (p -= (double)n);
                y = originalYcoordTree + 60;
            } else if (n >= 7 && n <= 14) {
                p = 10.5;
                x = (double)originalXcoordTree - 40.0 * (p -= (double)n);
                y = originalYcoordTree + 90;
            } else if (n >= 15 && n <= 30) {
                p = 22.5;
                x = (double)originalXcoordTree - 20.0 * (p -= (double)n);
                y = originalYcoordTree + 120;
            }
            RectProperties rp = new RectProperties();
            rp.set("color", Color.RED);
            lang.newRect(new Coordinates((int)x - 5, (int)y), new Coordinates((int)x + 17, (int)y + 17), "rec", null, rp);
            lang.nextStep();
            scSort.highlight(7);
            scDownheap.highlight(0);
            scDownheap.highlight(12);
            lang.nextStep();
            lang.setStepMode(false);
            Heapsort2.downheap(0);
            lang.setStepMode(true);
            scDownheap.unhighlight(0);
            scDownheap.unhighlight(12);
            scSort.unhighlight(7);
            lang.nextStep();
            lang.setStepMode(false);
        }
        lang.setStepMode(true);
        scSort.unhighlight(3);
        scSort.unhighlight(4);
        scSort.unhighlight(8);
        nMarker.hide();
        lang.nextStep();
        lang.setStepMode(false);
    }

    private static void buildheap() {
        lang.setStepMode(true);
        scBuildheap.highlight(0);
        scBuildheap.highlight(1);
        scBuildheap.highlight(3);
        vMarker.show();
        lang.nextStep();
        lang.setStepMode(false);
        int v = n / 2 - 1;
        while (v >= 0) {
            lang.setStepMode(true);
            scBuildheap.highlight(2);
            scDownheap.highlight(0);
            scDownheap.highlight(12);
            vIndex.setText("current v = " + v, null, null);
            vMarker.move(v, null, new TicksTiming(50));
            lang.nextStep();
            lang.setStepMode(false);
            Heapsort2.downheap(v);
            --v;
        }
        lang.setStepMode(true);
        vIndex.setText("v = _", null, null);
        scDownheap.unhighlight(0);
        scDownheap.unhighlight(12);
        scBuildheap.unhighlight(0);
        scBuildheap.unhighlight(1);
        scBuildheap.unhighlight(2);
        scBuildheap.unhighlight(3);
        vMarker.hide();
        lang.nextStep();
        lang.setStepMode(false);
    }

    private static void downheap(int v) {
        lang.setStepMode(true);
        scDownheap.highlight(1);
        int w = 2 * v + 1;
        if (w < n) {
            wMarker.move(w, null, null);
        }
        wIndex.setText("current w = " + w, null, null);
        lang.nextStep();
        vLocalIndex.setText("v' = " + v, null, null);
        vLocalMarker.move(v, null, null);
        scDownheap.unhighlight(1);
        scDownheap.highlight(2);
        scDownheap.highlight(3);
        scDownheap.highlight(11);
        vLocalMarker.show();
        wMarker.show();
        lang.nextStep();
        while (w < n) {
            lang.setStepMode(false);
            scDownheap.highlight(4);
            if (w + 1 < n) {
                scDownheap.highlight(5);
                if (intArray.getData(w + 1) > intArray.getData(w)) {
                    wIndex.setText("current w = " + ++w, null, null);
                    wMarker.move(w, null, new TicksTiming(50));
                }
            }
            lang.setStepMode(true);
            scDownheap.unhighlight(4);
            scDownheap.unhighlight(5);
            scDownheap.highlight(6);
            lang.nextStep();
            if (intArray.getData(v) >= intArray.getData(w)) {
                scDownheap.highlight(6);
                scDownheap.highlight(7);
                lang.nextStep();
                scDownheap.unhighlight(2);
                scDownheap.unhighlight(3);
                scDownheap.unhighlight(6);
                scDownheap.unhighlight(7);
                scDownheap.unhighlight(11);
                wMarker.hide();
                vLocalMarker.hide();
                lang.nextStep();
                return;
            }
            scDownheap.unhighlight(6);
            scDownheap.highlight(8);
            scExchange.highlight(0);
            scExchange.highlight(1);
            scExchange.highlight(2);
            scExchange.highlight(3);
            scExchange.highlight(4);
            Heapsort2.exchange(v, w);
            scDownheap.unhighlight(8);
            scExchange.unhighlight(0);
            scExchange.unhighlight(1);
            scExchange.unhighlight(2);
            scExchange.unhighlight(3);
            scExchange.unhighlight(4);
            scDownheap.highlight(9);
            lang.nextStep();
            v = w;
            vLocalMarker.move(v, null, new TicksTiming(50));
            vLocalIndex.setText("v' = " + v, null, null);
            lang.nextStep();
            scDownheap.unhighlight(9);
            scDownheap.highlight(10);
            w = 2 * v + 1;
            wIndex.setText("current w = " + w, null, null);
            if (w < n) {
                wMarker.move(w, null, new TicksTiming(50));
            }
            lang.nextStep();
            scDownheap.highlight(10);
            scDownheap.unhighlight(10);
            lang.nextStep();
        }
        wIndex.setText("current w = _", null, null);
        vLocalIndex.setText("v' = _", null, null);
        scDownheap.unhighlight(2);
        scDownheap.unhighlight(3);
        scDownheap.unhighlight(11);
        wMarker.hide();
        vLocalMarker.hide();
        lang.nextStep();
        lang.setStepMode(false);
    }

    private static void exchange(int i, int j) {
        intArray.highlightElem(i, null, null);
        tree[i].setFont(new Font("SansSerif", 1, 13), null, null);
        tree[j].setFont(new Font("SansSerif", 1, 13), null, null);
        intArray.highlightElem(j, null, null);
        PolylineProperties pp = new PolylineProperties();
        pp.set("color", Color.RED);
        pp.set("bwArrow", Boolean.TRUE);
        Polyline p = lang.newPolyline(new Node[]{tree[i].getUpperLeft(), tree[j].getUpperLeft()}, "linie", null, pp);
        p.hide(new TicksTiming(350));
        tree[i].setText(new Integer(intArray.getData(j)).toString(), new TicksTiming(100), new TicksTiming(200));
        tree[j].setText(new Integer(intArray.getData(i)).toString(), new TicksTiming(100), new TicksTiming(200));
        intArray.swap(i, j, new TicksTiming(100), new TicksTiming(200));
        tree[i].setFont(new Font("Monospaced", 0, 12), new TicksTiming(150), null);
        tree[j].setFont(new Font("Monospaced", 0, 12), new TicksTiming(150), null);
        intArray.unhighlightElem(j, new TicksTiming(100), null);
        intArray.unhighlightElem(i, new TicksTiming(100), null);
        lang.nextStep();
    }

    @Override
    public String getAlgorithmName() {
        return "Heapsort";
    }

    @Override
    public String getAnimationAuthor() {
        return "Henrik Schr\u00f6der, Nedislav Nedyalkov, Latinka Pavlova";
    }

    @Override
    public String getCodeExample() {
        return "public static void sort(int[] a0) \n{\n\ta=a0;\n\tn=a.length;\n\theapsort();\n}\n\nprivate static void heapsort()\n{\n\tbuildheap();\n\twhile (n>1)\n\t{\n\t\tn--;\n\t\texchange (0, n);\n\t\tdownheap (0);\n\t}\n}\n\nprivate static void buildheap()\n{\n\tfor (int v=n/2-1; v>=0; v--)\n\t\tdownheap (v);\n}\n\nprivate static void downheap(int v)\n{\n\tint w=2*v+1;    // first descendant of v\n\twhile (w<n)\n\t{\n\t\tif (w+1<n)    // is there a second descendant?\n\t\t\tif (a[w+1]>a[w]) w++;  // w is the descendant of v with maximum label\n\t\tif (a[v]>=a[w]) return;  // v has heap property\n\t\t// otherwise\n\t\texchange(v, w);  // exchange labels of v and w\n\t\tv=w;        // continue\n\t\tw=2*v+1;\n\t}\n}\n\nprivate static void exchange(int i, int j)\n{\n\tint t=a[i];\n\ta[i]=a[j];\n\ta[j]=t;\n}\n\n";
    }

    @Override
    public Locale getContentLocale() {
        return Locale.US;
    }

    @Override
    public String getDescription() {
        return "Heapsort (method) is a comparison-based sorting algorithm, and is part of the selection sort family. Although somewhat slower in practice on most machines than a good implementation of quicksort, it has the advantage of a worst-case O(n log n) runtime. Heapsort inserts the input list elements into a heap data structure. The largest value (in a max-heap) or the smallest value (in a min-heap) are extracted until none remain, the values having been extracted in sorted order. The heap's invariant is preserved after each extraction, so the only cost is that of extraction During extraction, the only space required is that needed to store the heap. In order to achieve constant space overhead, the heap is stored in the part of the input array that has not yet been sorted. (The structure of this heap is described at Binary heap: Heap implementation.) Heapsort uses two heap operations: insertion and root deletion. Each extraction places an element in the last empty location of the array. The remaining prefix of the array stores the unsorted elements. (Source: Wikipedia)";
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(1);
    }

    @Override
    public String getName() {
        return "Heapsort";
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public void init() {
    }
}

