/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.sorting;

import algoanim.animalscript.AnimalScript;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.IntArray;
import algoanim.primitives.Rect;
import algoanim.primitives.SourceCode;
import algoanim.primitives.StringArray;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.properties.ArrayProperties;
import algoanim.properties.RectProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import algoanim.util.MsTiming;
import algoanim.util.Offset;
import algoanim.util.TicksTiming;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Locale;

public class GnomeSortADS
implements Generator {
    public Language lang;
    public ArrayProperties arrayDesign = new ArrayProperties();
    public ArrayMarkerProperties pointerDesign = new ArrayMarkerProperties();
    public SourceCodeProperties scProps = new SourceCodeProperties();
    public ArrayProperties arrayDesign2 = new ArrayProperties();
    public RectProperties rp = new RectProperties();
    public int language;

    public GnomeSortADS() {
        AnimalScript l = new AnimalScript("niko tijani", "arif", 640, 480);
        this.lang = l;
    }

    public void execute(int[] a) {
        this.lang.setStepMode(true);
        TextProperties textProp = new TextProperties();
        textProp.set("font", new Font("Bold", 1, 40));
        this.lang.newText(new Coordinates(500, 30), "Gnome Sort", "text", null, textProp);
        this.lang.nextStep();
        if (this.language % 2 == 0) {
            this.showEnglishText();
        }
        if (this.language % 2 == 1) {
            this.showGermanText();
        }
        SourceCode sc = this.showSourceCode();
        this.lang.nextStep();
        int i = 0;
        sc.highlight(0);
        IntArray sortArray = this.lang.newIntArray(new Coordinates(100, 90), a, "mainArray", null, this.arrayDesign);
        IntArray oldArray = this.lang.newIntArray(new Coordinates(100, 90), a, "mainArray", null, this.arrayDesign);
        oldArray.changeColor("fillColor", Color.WHITE, new TicksTiming(10), new TicksTiming(10));
        oldArray.hide();
        this.lang.nextStep();
        sc.unhighlight(0);
        sc.highlight(1);
        ArrayMarker marker = this.lang.newArrayMarker(sortArray, 0, "i", null, this.pointerDesign);
        this.showString("i = 0", 1);
        sc.unhighlight(1);
        sc.highlight(2);
        if (this.language % 2 == 0) {
            this.showString("i = 0,  ar.length = " + sortArray.getLength() + ", (0 < " + sortArray.getLength() + ") =>  TRUE!", 2);
        }
        if (this.language % 2 == 1) {
            this.showString("i = 0,  ar.length = " + sortArray.getLength() + ", (0 < " + sortArray.getLength() + ") =>  WAHR!", 2);
        }
        while (i < sortArray.getLength()) {
            sortArray.unhighlightCell(0, sortArray.getLength() - 1, null, null);
            sc.unhighlight(2);
            sc.highlight(3);
            sortArray.unhighlightCell(0, sortArray.getLength(), null, null);
            sortArray.highlightCell(i - 1, i, null, null);
            sortArray.highlightCell(i, i, null, null);
            if (i == 0) {
                if (this.language % 2 == 0) {
                    this.showString("this time i is equals 0", 3);
                }
                if (this.language % 2 == 1) {
                    this.showString("jetzt ist i = 0", 3);
                }
            } else if (sortArray.getData(i - 1) < sortArray.getData(i)) {
                if (this.language % 2 == 0) {
                    this.showString(String.valueOf(sortArray.getData(i - 1)) + " is smaller than " + sortArray.getData(i) + " so they are sorted", 3);
                }
                if (this.language % 2 == 1) {
                    this.showString(String.valueOf(sortArray.getData(i - 1)) + " ist kleiner als " + sortArray.getData(i) + " also sind sie sortiert", 3);
                }
            }
            if (i == 0 || sortArray.getData(i - 1) <= sortArray.getData(i)) {
                sortArray.unhighlightCell(0, sortArray.getLength(), null, null);
                sortArray.highlightCell(i - 1, i, null, null);
                sc.unhighlight(2);
                sc.unhighlight(3);
                sc.highlight(4);
                if (this.language % 2 == 0) {
                    this.showString("we can move to the next position", 4);
                }
                if (this.language % 2 == 1) {
                    this.showString("Wir gehen \u00b8ber zur naechsten Position", 4);
                }
                if (++i < sortArray.getLength()) {
                    marker.move(i, null, null);
                }
            } else {
                sc.unhighlight(2);
                sc.unhighlight(3);
                sc.unhighlight(4);
                sc.highlight(5);
                if (this.language % 2 == 0) {
                    this.showString(String.valueOf(sortArray.getData(i - 1)) + " is bigger than " + sortArray.getData(i), 5);
                }
                if (this.language % 2 == 1) {
                    this.showString(String.valueOf(sortArray.getData(i - 1)) + " ist groesser als " + sortArray.getData(i), 5);
                }
                sc.unhighlight(5);
                sc.highlight(6);
                if (this.language % 2 == 0) {
                    this.showString("so we swap them!", 6);
                }
                if (this.language % 2 == 1) {
                    this.showString("Also wird getauscht!", 6);
                }
                sortArray.swap(i, i - 1, null, new MsTiming(900));
                this.lang.nextStep();
                sc.unhighlight(6);
                sc.highlight(7);
                --i;
                if (this.language % 2 == 0) {
                    this.showString("go one position backwords", 7);
                }
                if (this.language % 2 == 1) {
                    this.showString("Gehe eine Position zurueck", 7);
                }
                sc.unhighlight(7);
                marker.move(i, null, null);
                this.lang.nextStep();
            }
            sortArray.unhighlightCell(0, sortArray.getLength() - 1, null, null);
            sc.unhighlight(3);
            sc.unhighlight(4);
            sc.highlight(2);
            if (i < sortArray.getLength()) {
                if (this.language % 2 == 0) {
                    this.showString("i = " + i + ",  ar.length = " + sortArray.getLength() + ", (" + i + " < " + sortArray.getLength() + ") still TRUE!", 2);
                }
                if (this.language % 2 != 1) continue;
                this.showString("i = " + i + ",  ar.length = " + sortArray.getLength() + ", (" + i + " < " + sortArray.getLength() + ") Das ist WAHR!", 2);
                continue;
            }
            if (this.language % 2 == 0) {
                this.showString("i = " + i + ",  ar.length = " + sortArray.getLength() + ", (" + i + " = " + sortArray.getLength() + ") =>  FALSE!", 2);
            }
            if (this.language % 2 != 1) continue;
            this.showString("i = " + i + ",  ar.length = " + sortArray.getLength() + ", (" + i + " = " + sortArray.getLength() + ") =>  FALSCH!", 2);
        }
        if (this.language % 2 == 0) {
            this.showString("Sorted!", 10);
        }
        if (this.language % 2 == 1) {
            this.showString("Sortiert!", 10);
        }
        this.lang.nextStep();
        marker.hide();
        sortArray.moveBy(null, 0, 40, new TicksTiming(10), new TicksTiming(10));
        this.lang.nextStep();
        oldArray.show();
        if (this.language % 2 == 0) {
            this.lang.newText(new Offset(10, 10, sortArray, "E"), "Array before sort", "text", null);
            this.lang.newText(new Offset(10, 50, sortArray, "E"), "Array after sort", "text", null);
        }
        if (this.language % 2 == 1) {
            this.lang.newText(new Offset(10, 10, sortArray, "E"), "Array vor dem sortieren", "text", null);
            this.lang.newText(new Offset(10, 50, sortArray, "E"), "Array nach dem sortieren", "text", null);
        }
    }

    public void unhighlight(IntArray x) {
        int i = 0;
        while (i < x.getLength()) {
            ++i;
        }
    }

    public SourceCode showSourceCode() {
        this.scProps.set("font", new Font("Monospaced", 0, 12));
        SourceCode sc = this.lang.newSourceCode(new Coordinates(40, 200), "sourceCode", null, this.scProps);
        sc.addCodeLine("public void gnomeSort(int [ ] array){", null, 0, null);
        sc.addCodeLine("int i = 0;", null, 1, null);
        sc.addCodeLine("while (i < ar.length){", null, 1, null);
        sc.addCodeLine("if(i == 0 || array[i-1] <= array[i])", null, 2, null);
        sc.addCodeLine("i++;", null, 3, null);
        sc.addCodeLine("else{", null, 2, null);
        sc.addCodeLine("swap(array[i],array[i-1]);", null, 3, null);
        sc.addCodeLine("i--;", null, 3, null);
        sc.addCodeLine("}", null, 2, null);
        sc.addCodeLine("}", null, 1, null);
        sc.addCodeLine("}", null, 0, null);
        return sc;
    }

    public void showString(String text, int i) {
        text = "// " + text;
        String[] x = new String[]{text};
        StringArray x1 = this.lang.newStringArray(new Coordinates(320, 205 + i * 17), x, "x", null, this.arrayDesign2);
        this.lang.nextStep();
        x1.hide(null);
    }

    public static void main(String[] args) {
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        int[] a = (int[])primitives.get("intArray");
        this.arrayDesign = (ArrayProperties)props.get(0);
        this.pointerDesign = (ArrayMarkerProperties)props.get(1);
        this.scProps = (SourceCodeProperties)props.get(2);
        this.arrayDesign2 = (ArrayProperties)props.get(3);
        this.rp = (RectProperties)props.get(4);
        this.language = (Integer)primitives.get("Language/Sprache");
        this.execute(a);
        return this.lang.toString();
    }

    public void showGermanText() {
        TextProperties textProp = new TextProperties();
        textProp.set("font", new Font("Bold", 0, 20));
        Text descTitle = this.lang.newText(new Coordinates(40, 165), "Beschreibung des Algorithmus", "text", null, textProp);
        SourceCode germanText = this.lang.newSourceCode(new Coordinates(40, 200), "description", null);
        germanText.addCodeLine("Man stelle sich einen Gartenzwerg (garden gnome) vor, welcher", null, 0, null);
        germanText.addCodeLine("vor n Blument\u02c6pfen steht, die unterschiedliche Gr\u02c6\ufb02en haben d\u00b8rfen.", null, 0, null);
        germanText.addCodeLine("Die Blument\u02c6pfe sind in einer von links nach rechts", null, 0, null);
        germanText.addCodeLine("verlaufenden Reihe aufgestellt. Ganz links steht der Gartenzwerg", null, 0, null);
        germanText.addCodeLine("und m\u02c6chte die Blument\u02c6pfe von links nach rechts der Gr\u02c6\ufb02e nach", null, 0, null);
        germanText.addCodeLine("aufsteigend sortieren.", null, 0, null);
        germanText.addCodeLine("", null, 1, null);
        this.lang.nextStep();
        germanText.addCodeLine("Dazu vergleicht er die beiden Blument\u02c6pfe, vor denen er grade steht.", null, 0, null);
        germanText.addCodeLine("Stellt er fest, dass sie in der richtigen Reihenfolge sind,", null, 0, null);
        germanText.addCodeLine("so macht er einen Schritt nach rechts. Stellt er hingegen fest,", null, 0, null);
        germanText.addCodeLine("dass die Reihenfolge nicht stimmt, so vertauscht er die", null, 0, null);
        germanText.addCodeLine("beiden Blument\u02c6pfe und macht einen Schritt nach links.", null, 0, null);
        germanText.addCodeLine("", null, 1, null);
        this.lang.nextStep();
        germanText.addCodeLine("Dies wiederholt er st\u2030ndig. Fertig ist er, wenn er", null, 0, null);
        germanText.addCodeLine("am ganz rechts stehenden Blumentopf ankommt und feststellt,", null, 0, null);
        germanText.addCodeLine("dass dieser in der richtigen Reihenfolge steht.", null, 0, null);
        germanText.addCodeLine("", null, 1, null);
        germanText.addCodeLine("entnommen aus: ", null, 0, null);
        germanText.addCodeLine("http://de.wikipedia.org/wiki/Gnomesort", null, 0, null);
        this.drawRect(descTitle, germanText);
        this.lang.nextStep();
    }

    private void drawRect(Text descTitle, SourceCode descText) {
        Rect inner = this.lang.newRect(new Offset(-5, -35, descText, "NW"), new Offset(5, 5, descText, "SE"), "rect", null, this.rp);
        Rect outer = this.lang.newRect(new Offset(-3, -33, descText, "NW"), new Offset(7, 7, descText, "SE"), "rect", null, this.rp);
        Rect outer1 = this.lang.newRect(new Offset(-7, -37, descText, "NW"), new Offset(3, 3, descText, "SE"), "rect", null, this.rp);
        this.lang.nextStep();
        descTitle.moveBy(null, 600, 0, new TicksTiming(10), new TicksTiming(10));
        descText.moveBy(null, 600, 0, new TicksTiming(10), new TicksTiming(10));
        inner.moveBy(null, 600, 0, new TicksTiming(10), new TicksTiming(10));
        outer.moveBy(null, 600, 0, new TicksTiming(10), new TicksTiming(10));
        outer1.moveBy(null, 600, 0, new TicksTiming(10), new TicksTiming(10));
    }

    public void showEnglishText() {
        TextProperties textProp = new TextProperties();
        textProp.set("font", new Font("Bold", 0, 20));
        Text descTitle = this.lang.newText(new Coordinates(40, 165), "Description of algorithm", "text", null, textProp);
        SourceCode englishText = this.lang.newSourceCode(new Coordinates(40, 200), "description", null);
        englishText.addCodeLine("Gnome sort is a sorting algorithm which is similar to ", null, 0, null);
        englishText.addCodeLine("insertion sort, except that moving an element to its ", null, 0, null);
        englishText.addCodeLine("proper place is accomplished by a series of swaps, as ", null, 0, null);
        englishText.addCodeLine("in bubble sort. The name comes from the supposed ", null, 0, null);
        englishText.addCodeLine("behavior of the Dutch garden gnome in sorting a line ", null, 0, null);
        englishText.addCodeLine("of flowerpots and is described on Dick Grune's Gnome ", null, 0, null);
        englishText.addCodeLine("sort page", null, 0, null);
        englishText.addCodeLine("", null, 0, null);
        this.lang.nextStep();
        englishText.addCodeLine("It is conceptually simple, requiring no nested loops.", null, 0, null);
        englishText.addCodeLine("The running time is O(n\u2264), but in practice the ", null, 0, null);
        englishText.addCodeLine("algorithm can run as fast as Insertion sort.", null, 0, null);
        englishText.addCodeLine("", null, 0, null);
        this.lang.nextStep();
        englishText.addCodeLine("The algorithm always finds the first place where two ", null, 0, null);
        englishText.addCodeLine("adjacent elements are in the wrong order, and swaps ", null, 0, null);
        englishText.addCodeLine("them. It takes advantage of the fact that performing ", null, 0, null);
        englishText.addCodeLine("a swap can introduce a new out-of-order adjacent pair ", null, 0, null);
        englishText.addCodeLine("only right before or after the two swapped elements. ", null, 0, null);
        englishText.addCodeLine("It does not assume that elements forward of the ", null, 0, null);
        englishText.addCodeLine("current position are sorted, so it only needs to ", null, 0, null);
        englishText.addCodeLine("check the position directly before the swapped ", null, 0, null);
        englishText.addCodeLine("elements.", null, 0, null);
        englishText.addCodeLine("", null, 0, null);
        this.lang.nextStep();
        englishText.addCodeLine("taken from http://en.wikipedia.org/wiki/Gnome_sort", null, 0, null);
        this.drawRect(descTitle, englishText);
    }

    @Override
    public String getAlgorithmName() {
        return "GnomeSort";
    }

    @Override
    public String getAnimationAuthor() {
        return "Tijani Ahmedou, Nikola Dyundev, Arif Sami";
    }

    @Override
    public String getCodeExample() {
        return "public void gnomeSort(int [ ] array){\n  int i = 0;\n  while (i < ar.length){\n    if(i == 0 || array[i-1] <= array[i])\n      i++;\n    else{\n      swap(array[i],array[i-1]);\n      i--;\n    }\n  }\n}";
    }

    @Override
    public Locale getContentLocale() {
        return Locale.US;
    }

    @Override
    public String getDescription() {
        return "Ein einfacher und sehr stabiler Sortieralgorithmus\nA simple and stable sorting algorithm\n\nLanguage: \n0 - English\n1 - Deutsch (default)\n\n";
    }

    @Override
    public String getFileExtension() {
        return ".asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(1);
    }

    @Override
    public String getName() {
        return "Gnome Sort";
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public void init() {
    }
}

