/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.sorting;

import algoanim.primitives.ArrayMarker;
import algoanim.primitives.IntArray;
import algoanim.primitives.Primitive;
import algoanim.primitives.Text;
import algoanim.properties.ArrayProperties;
import algoanim.util.Coordinates;
import algoanim.util.Offset;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.helpers.AnimatedIntArrayAlgorithm;
import java.util.Hashtable;
import java.util.Locale;
import translator.Translator;

public class GenericAnnotatedMergeSort
extends AnimatedIntArrayAlgorithm
implements Generator {
    protected Text swapLabel;
    protected Text swapPerf;
    protected Locale contentLocale = null;
    protected ArrayMarker iMarker = null;
    protected ArrayMarker jMarker = null;
    protected ArrayMarker kMarker = null;
    protected IntArray bArray = null;

    public GenericAnnotatedMergeSort(String aResourceName, Locale aLocale) {
        this.resourceName = aResourceName;
        this.locale = aLocale;
        this.init();
    }

    @Override
    public void init() {
        this.translator = new Translator(this.resourceName, this.locale);
        this.primitiveProps = new Hashtable(59);
        this.localType = new GeneratorType(1);
        this.contentLocale = this.locale;
    }

    @Override
    protected void hideNrStepsArrayCode() {
        super.hideNrStepsArrayCode();
        if (this.array != null) {
            this.array.hide();
        }
        if (this.bArray != null) {
            this.bArray.hide();
        }
    }

    public void sort() {
        this.mergeSort(0, this.array.getLength() - 1, 0);
    }

    private String createSplitLabel(int l, int r, int d) {
        StringBuilder mergeLabel = new StringBuilder(40);
        int a = 0;
        while (a < d) {
            mergeLabel.append(' ');
            ++a;
        }
        mergeLabel.append("Mergesort(array, ").append(l).append(", ");
        mergeLabel.append(r).append(")");
        return mergeLabel.toString();
    }

    private String createMergeLabel(int l, int r, int d) {
        StringBuilder mergeLabel = new StringBuilder(40);
        int a = 0;
        while (a < d) {
            mergeLabel.append(' ');
            ++a;
        }
        mergeLabel.append("merge array [").append(l).append(", ");
        mergeLabel.append(r).append("]");
        return mergeLabel.toString();
    }

    private void mergeSort(int l, int r, int depth) {
        this.bArray.highlightElem(0, this.bArray.getLength() - 1, null, null);
        this.code.highlight("header");
        this.array.highlightCell(l, r, null, null);
        this.lang.nextStep();
        this.code.toggleHighlight("header", "variables");
        this.lang.nextStep(this.createSplitLabel(l, r, depth));
        this.code.toggleHighlight("variables", "array");
        this.lang.nextStep();
        this.code.toggleHighlight("array", "check");
        this.lang.nextStep();
        if (r > l) {
            this.code.toggleHighlight("check", "determineMid");
            this.incrementNrComparisons();
            this.lang.nextStep();
            int m = (l + r) / 2;
            this.code.toggleHighlight("determineMid", "sortLeftside");
            this.incrementNrAssignments();
            this.lang.nextStep();
            this.code.unhighlight("sortLeftside");
            this.array.unhighlightCell(l, r, null, null);
            this.mergeSort(l, m, depth + 1);
            this.code.highlight("sortRightside");
            this.lang.nextStep();
            this.code.unhighlight("sortRightside");
            this.mergeSort(m + 1, r, depth + 1);
            this.code.highlight("copyLeftside");
            this.array.highlightCell(l, r, null, null);
            this.lang.nextStep(this.createMergeLabel(l, r, depth));
            this.incrementNrAssignments();
            this.incrementNrComparisons(2);
            int i = l;
            while (i <= m && i < this.array.getLength()) {
                this.bArray.put(i - l, this.array.getData(i), null, null);
                this.incrementNrAssignments();
                this.bArray.unhighlightElem(i - l, null, null);
                this.incrementNrAssignments();
                this.incrementNrComparisons(2);
                ++i;
            }
            this.code.toggleHighlight("copyLeftside", "copyRightside");
            this.lang.nextStep();
            this.incrementNrAssignments();
            this.incrementNrComparisons();
            int j = m + 1;
            while (j <= r) {
                this.bArray.put(r + m + 1 - j - l, this.array.getData(j), null, null);
                this.incrementNrAssignments();
                this.bArray.unhighlightElem(r + m + 1 - j - l, null, null);
                this.incrementNrAssignments();
                this.incrementNrComparisons();
                ++j;
            }
            this.code.toggleHighlight("copyRightside", "loop");
            this.lang.nextStep();
            this.incrementNrAssignments(3);
            this.incrementNrComparisons(2);
            int k = l;
            i = 0;
            j = r - l;
            while (k <= r && k < this.array.getLength()) {
                if (this.iMarker == null) {
                    this.iMarker = this.installArrayMarker("iMarker", this.bArray, i);
                } else {
                    this.iMarker.move(i, null, null);
                }
                if (this.jMarker == null) {
                    this.jMarker = this.installArrayMarker("jMarker", this.bArray, j);
                } else {
                    this.jMarker.move(j, null, null);
                }
                if (this.kMarker == null) {
                    this.kMarker = this.installArrayMarker("kMarker", this.array, k);
                } else {
                    this.kMarker.move(k, null, null);
                }
                this.code.toggleHighlight("loop", "merge");
                this.lang.nextStep();
                this.array.put(k, this.bArray.getData(i) < this.bArray.getData(j) ? this.bArray.getData(i++) : this.bArray.getData(j--), null, null);
                this.incrementNrAssignments(3);
                this.incrementNrComparisons(1);
                this.code.toggleHighlight("merge", "loop");
                this.lang.nextStep();
                this.incrementNrAssignments();
                this.incrementNrComparisons(2);
                ++k;
            }
            this.code.unhighlight("loop");
        } else {
            this.code.unhighlight("check");
        }
        this.array.unhighlightCell(l, r, null, null);
    }

    protected IntArray installIntArray(String key, int x, int y) {
        int[] arrayData = (int[])this.primitives.get(key);
        if (arrayData == null) {
            arrayData = new int[this.array.getLength()];
        }
        ArrayProperties iap = new ArrayProperties();
        iap.set("color", this.animationProperties.get(key, "color"));
        iap.set("fillColor", this.animationProperties.get(key, "fillColor"));
        iap.set("filled", Boolean.TRUE);
        iap.set("elementColor", this.animationProperties.get(key, "elementColor"));
        iap.set("elemHighlight", this.animationProperties.get(key, "elemHighlight"));
        iap.set("cellHighlight", this.animationProperties.get(key, "cellHighlight"));
        IntArray intArray = this.lang.newIntArray(new Coordinates(x, y), arrayData, "array", null, iap);
        return intArray;
    }

    @Override
    public Primitive installAdditionalComponents(String arrayKey, String codeKey, String codeName, int dx, int dy) {
        String bArrayKey = "bArray";
        this.array = this.installIntArray(arrayKey, 30, 150);
        this.bArray = this.installIntArray(bArrayKey, 30, 250);
        this.code = this.installCodeBlock(codeKey, codeName, new Offset(dx, dy, this.bArray, "SW"));
        return this.array;
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> prims) {
        this.setUpDefaultElements(props, prims, "array", "code", "code", 0, 20);
        this.sort();
        if (this.swapPerf != null) {
            this.swapPerf.hide();
        }
        if (this.swapLabel != null) {
            this.swapLabel.hide();
        }
        this.wrapUpAnimation();
        return this.lang.toString();
    }

    @Override
    public String getAlgorithmName() {
        return "Merge Sort";
    }

    @Override
    public String getAnimationAuthor() {
        return "Krasimir Markov";
    }

    @Override
    public Locale getContentLocale() {
        return this.contentLocale;
    }
}

