/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.sorting;

import algoanim.primitives.ArrayMarker;
import algoanim.primitives.IntArray;
import algoanim.primitives.Text;
import algoanim.properties.TextProperties;
import algoanim.util.Offset;
import algoanim.util.Timing;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.helpers.AnimatedIntArrayAlgorithm;
import java.util.Hashtable;
import java.util.Locale;
import translator.Translator;

public class DelphiAnnotatedQuickSort2
extends AnimatedIntArrayAlgorithm
implements Generator {
    protected Text iLoLabel;
    protected Text iHiLabel;
    protected Text midLabel;
    protected Text tLabel;
    protected Text iLoValue;
    protected Text iHiValue;
    protected Text midValue;
    protected Text tValue;
    protected Locale contentLocale = null;
    String resourceName;
    Locale locale;

    public DelphiAnnotatedQuickSort2() {
        this("resources/DelphiQuickSort", Locale.GERMANY);
    }

    public DelphiAnnotatedQuickSort2(String aResourceName, Locale aLocale) {
        this.resourceName = aResourceName;
        this.locale = aLocale;
        this.init();
    }

    @Override
    public void init() {
        this.translator = new Translator(this.resourceName, this.locale);
        this.primitiveProps = new Hashtable(59);
        this.localType = new GeneratorType(1);
        this.contentLocale = this.locale;
    }

    @Override
    protected void hideNrStepsArrayCode() {
        super.hideNrStepsArrayCode();
        if (this.array != null) {
            this.array.hide();
        }
    }

    public void sort() {
        this.iLoLabel = this.lang.newText(new Offset(0, 10, this.nrCompLabel, "SW"), "iLo =", "iLoLabel", null, (TextProperties)this.primitiveProps.get("title"));
        this.iLoValue = this.lang.newText(new Offset(10, 0, this.iLoLabel, "baseline end"), "", "iLoValue", null, (TextProperties)this.primitiveProps.get("title"));
        this.iHiLabel = this.lang.newText(new Offset(0, 10, this.iLoLabel, "SW"), "iHi =", "iHiLabel", null, (TextProperties)this.primitiveProps.get("title"));
        this.iHiValue = this.lang.newText(new Offset(10, 0, this.iHiLabel, "baseline end"), "", "iHiValue", null, (TextProperties)this.primitiveProps.get("title"));
        this.tLabel = this.lang.newText(new Offset(100, 0, this.iLoLabel, "baseline end"), "T =", "tLabel", null, (TextProperties)this.primitiveProps.get("title"));
        this.tValue = this.lang.newText(new Offset(10, 0, this.tLabel, "baseline end"), "", "tValue", null, (TextProperties)this.primitiveProps.get("title"));
        this.midLabel = this.lang.newText(new Offset(100, 0, this.iHiLabel, "baseline end"), "Mid =", "midLabel", null, (TextProperties)this.primitiveProps.get("title"));
        this.midValue = this.lang.newText(new Offset(10, 0, this.midLabel, "baseline end"), "", "midValue", null, (TextProperties)this.primitiveProps.get("title"));
        this.quickSort(0, this.array.getLength() - 1, 0);
    }

    private String makeLabel(int l, int r, int depth) {
        StringBuilder sb = new StringBuilder(32);
        int i = 0;
        while (i < depth) {
            sb.append(' ');
            ++i;
        }
        sb.append("quicksort(").append(l).append(", ").append(r);
        sb.append(")");
        return sb.toString();
    }

    public void quickSort(int iLo, int iHi, int depth) {
        ArrayMarker loMarker = null;
        ArrayMarker hiMarker = null;
        int t = 0;
        boolean done = false;
        this.code.highlight("header");
        this.array.unhighlightCell(0, this.array.getLength() - 1, null, null);
        this.array.highlightCell(iLo, iHi, null, null);
        this.iLoValue.setText(String.valueOf(iLo), null, null);
        this.iHiValue.setText(String.valueOf(iHi), null, null);
        this.lang.nextStep(this.makeLabel(iLo, iHi, depth));
        this.code.toggleHighlight("header", "variables");
        this.lang.nextStep();
        this.code.toggleHighlight("variables", "setLo");
        int lo = iLo;
        if (loMarker != null) {
            System.err.println(loMarker.getPosition());
        }
        if (loMarker == null) {
            loMarker = this.installArrayMarker("Lo", this.array, lo);
        } else {
            loMarker.move(lo, null, null);
        }
        this.incrementNrAssignments();
        this.lang.nextStep();
        this.code.toggleHighlight("setLo", "setHi");
        int hi = iHi;
        if (hiMarker == null) {
            hiMarker = this.installArrayMarker("Hi", this.array, hi);
        } else {
            hiMarker.move(hi, null, null);
        }
        this.incrementNrAssignments();
        this.lang.nextStep();
        this.code.toggleHighlight("setHi", "setMid");
        int mid = this.array.getData((lo + hi) / 2);
        this.midValue.setText(String.valueOf(mid), null, null);
        this.array.highlightCell(mid, null, null);
        this.incrementNrAssignments();
        this.lang.nextStep();
        this.code.unhighlight("setMid");
        do {
            this.code.highlight("repeat");
            this.lang.nextStep();
            this.code.toggleHighlight("repeat", "incLo");
            this.array.highlightElem(lo, null, null);
            this.incrementNrComparisons();
            this.lang.nextStep();
            while (this.array.getData(lo) < mid) {
                this.incrementNrAssignments();
                this.updateMarker(loMarker, ++lo, DEFAULT_TIMING);
                this.array.unhighlightElem(lo - 1, null, null);
                this.array.highlightElem(lo, null, null);
                this.lang.nextStep();
                this.incrementNrComparisons();
            }
            this.code.toggleHighlight("incLo", "decHi");
            this.array.highlightElem(hi, null, null);
            while (this.array.getData(hi) > mid) {
                this.incrementNrComparisons();
                this.lang.nextStep();
                this.updateMarker(hiMarker, --hi, DEFAULT_TIMING);
                this.incrementNrAssignments();
                this.array.unhighlightElem(hi + 1, null, null);
                this.array.highlightElem(hi, null, null);
            }
            this.incrementNrComparisons();
            this.lang.nextStep();
            this.code.toggleHighlight("decHi", "testLoHi");
            this.incrementNrComparisons();
            this.lang.nextStep();
            this.code.unhighlight("testLoHi");
            if (lo <= hi) {
                this.code.highlight("copyLo");
                t = this.array.getData(lo);
                this.incrementNrAssignments();
                this.tValue.setText(String.valueOf(t), null, null);
                this.lang.nextStep();
                this.code.toggleHighlight("copyLo", "replicateHi");
                this.array.put(lo, this.array.getData(hi), null, DEFAULT_TIMING);
                this.incrementNrAssignments();
                this.lang.nextStep();
                this.code.toggleHighlight("replicateHi", "insertLo");
                this.array.put(hi, t, null, DEFAULT_TIMING);
                this.incrementNrAssignments();
                this.lang.nextStep();
                this.code.toggleHighlight("insertLo", "incLo2");
                this.updateMarker(loMarker, ++lo, DEFAULT_TIMING);
                this.incrementNrAssignments();
                this.lang.nextStep();
                this.code.toggleHighlight("incLo2", "decHi2");
                this.updateMarker(hiMarker, --hi, DEFAULT_TIMING);
                this.incrementNrAssignments();
                this.lang.nextStep();
                this.code.unhighlight("decHi2");
            }
            this.code.highlight("until");
            this.lang.nextStep();
            this.code.unhighlight("until");
        } while (lo <= hi);
        this.code.highlight("checkHiiLo");
        this.incrementNrComparisons();
        this.lang.nextStep();
        if (hi > iLo) {
            this.code.toggleHighlight("checkHiiLo", "rightRec");
            this.lang.nextStep();
            this.code.unhighlight("rightRec");
            loMarker.hide();
            hiMarker.hide();
            this.midValue.setText("", null, null);
            this.quickSort(iLo, hi, depth + 1);
            this.code.highlight("rightRec");
            loMarker.show();
            hiMarker.show();
            this.midValue.setText(String.valueOf(mid), null, null);
            this.tValue.setText(String.valueOf(t), null, null);
            this.array.highlightCell(iLo, iHi, null, null);
            this.lang.nextStep();
            this.code.unhighlight("rightRec");
        } else {
            this.code.unhighlight("checkHiiLo");
        }
        this.code.highlight("checkLoiHi");
        this.incrementNrComparisons();
        this.lang.nextStep();
        if (lo < iHi) {
            this.code.toggleHighlight("checkLoiHi", "leftRec");
            this.lang.nextStep();
            this.code.unhighlight("leftRec");
            loMarker.hide();
            hiMarker.hide();
            this.midValue.setText("", null, null);
            this.quickSort(lo, iHi, depth + 1);
            this.code.highlight("leftRec");
            loMarker.show();
            hiMarker.show();
            this.midValue.setText(String.valueOf(mid), null, null);
            this.tValue.setText(String.valueOf(t), null, null);
            this.array.highlightCell(iLo, iHi, null, null);
            this.lang.nextStep();
            this.code.unhighlight("leftRec");
        } else {
            this.code.unhighlight("checkLoiHi");
        }
        this.code.highlight("checkDone");
        done = this.terminated(this.array);
        this.lang.nextStep();
        this.code.unhighlight("checkDone");
        this.array.unhighlightCell(iLo, iHi, null, null);
        loMarker.hide();
        hiMarker.hide();
    }

    private boolean terminated(IntArray theArray) {
        int i = 0;
        while (i < this.array.getLength() - 1) {
            if (this.array.getData(i) > this.array.getData(i + 1)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void updateMarker(ArrayMarker marker, int pos, Timing duration) {
        if (marker != null && pos >= 0 && pos < this.array.getLength()) {
            marker.move(pos, null, duration);
        } else if (pos < 0) {
            marker.moveBeforeStart(null, duration);
        } else {
            marker.moveOutside(null, duration);
        }
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> prims) {
        this.setUpDefaultElements(props, prims, "array", "code", "code", 0, 20);
        this.sort();
        this.hideText(this.iLoLabel);
        this.hideText(this.iLoValue);
        this.hideText(this.iHiLabel);
        this.hideText(this.iHiValue);
        this.hideText(this.tLabel);
        this.hideText(this.tValue);
        this.hideText(this.midLabel);
        this.hideText(this.midValue);
        this.wrapUpAnimation();
        this.lang.finalizeGeneration();
        return this.lang.toString();
    }

    private void hideText(Text textObject) {
        if (textObject != null) {
            textObject.hide();
        }
    }

    @Override
    public String getAlgorithmName() {
        return "Quicksort";
    }

    @Override
    public String getAnimationAuthor() {
        return "Krasimir Markov";
    }

    @Override
    public Locale getContentLocale() {
        return this.contentLocale;
    }
}

