/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.sorting;

import algoanim.animalscript.AnimalScript;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.IntArray;
import algoanim.primitives.Rect;
import algoanim.primitives.SourceCode;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.properties.ArrayProperties;
import algoanim.properties.RectProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import algoanim.util.TicksTiming;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Random;

public class CombSort2
implements Generator {
    private ArrayMarker marker;
    private SourceCode intro;
    private Text gapSizeTxt;
    private Text swappedTxt;
    private SourceCode source;
    private static final String DESCRIPTION = "Comb Sort is a relatively simplistic sorting algorithm originally designed by Wlodek Dobosiewicz in 1980 and later rediscovered and popularised by Stephen Lacey and Richard Box, who described it in Byte Magazine in April 1991. Comb sort improves on bubble sort, and rivals in speed more complex algorithms like Quicksort. The basic idea is to eliminate turtles, or small values near the end of the list, since in a bubble sort these slow the sorting down tremendously. Large values around the beginning of the list, do not pose a problem in bubble sort.).\nThe basic idea of comb sort is that the gap between two elements, that are compared and swapped, when not in the right order, can be much more than one - like in bubble sort. Tests showed that this gap should be decreased by a factor of ~1.3 each round to make the algortihm as fast as possible. When the gapsize reaches 9 or 10, it should be set to 11, because then the ordering is done faster. \nComb Sort has the same worst case complexity as Bubble sort - O(n\u2264) in Landau notation, but is slightly faster in most cases. (extended/taken from wikipedia)";
    private static final String CODE = "static void shakerSort(int[] array) {\n  int gap = array.length;\n  boolean swapped;\n  do {\n    swapped = false;\n    gap = gap * 10 / 13;\n    if (gap == 9 || gap == 10)\n      gap = 11;\n    if (gap < 1)\n      gap = 1;\n    for (int i = 0; i < array.length - gap; i++) \n      if (array[i] > array[i + gap]) \n        swapped = true;\n        swap(array[i],array[i+gap]);\n  } while (gap > 1 || swapped);\n}";

    public static void main(String[] args) {
        int number = 12;
        String outname = "C:\\Test.asu";
        CombSort2 my = new CombSort2();
        AnimationPropertiesContainer props = new AnimationPropertiesContainer();
        Hashtable<String, Object> primitives = new Hashtable<String, Object>();
        int[] array = new int[12];
        Random rand = new Random();
        int i = 0;
        while (i < array.length) {
            array[i] = rand.nextInt(99);
            ++i;
        }
        primitives.put("Input Data", array);
        ArrayProperties aprops = new ArrayProperties();
        aprops.setName("Array");
        aprops.set("fillColor", Color.LIGHT_GRAY);
        aprops.set("elemHighlight", Color.RED);
        aprops.set("cellHighlight", Color.GRAY);
        props.add(aprops);
        ArrayMarkerProperties mprops = new ArrayMarkerProperties();
        mprops.setName("Marker");
        mprops.set("color", Color.BLUE);
        mprops.set("label", "i");
        props.add(mprops);
        SourceCodeProperties sprops = new SourceCodeProperties();
        sprops.setName("Source Code");
        sprops.set("highlightColor", Color.RED);
        props.add(sprops);
        sprops = new SourceCodeProperties();
        sprops.setName("Intro Text");
        sprops.set("font", new Font("SansSerif", 1, 15));
        props.add(sprops);
        String script = my.generate(props, primitives);
        System.out.print(script);
        try {
            FileWriter fileWriter = new FileWriter("C:\\Test.asu");
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.append(script);
            bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sort(Language lang, IntArray array) {
        array.hide();
        this.gapSizeTxt.hide();
        this.swappedTxt.hide();
        this.intro.addCodeLine("Comb Sort is a relatively simplistic sorting algorithm originally designed by ", null, 0, null);
        this.intro.addCodeLine("Wlodek Dobosiewicz in 1980 and later rediscovered and popularised by Stephen ", null, 0, null);
        this.intro.addCodeLine("Lacey and Richard Box, who described it in Byte Magazine in April 1991. Comb ", null, 0, null);
        this.intro.addCodeLine("sort improves on bubble sort, and rivals in speed more complex algorithms like ", null, 0, null);
        this.intro.addCodeLine("Quicksort. The basic idea is to eliminate turtles, or small values near the end ", null, 0, null);
        this.intro.addCodeLine("of the list, since in a bubble sort these slow the sorting down tremendously. ", null, 0, null);
        this.intro.addCodeLine("Large values around the beginning of the list, do not pose a problem ", null, 0, null);
        this.intro.addCodeLine("in bubble sort.).", null, 0, null);
        this.intro.addCodeLine("", null, 0, null);
        this.intro.addCodeLine("The basic idea of comb sort is that the gap between two elements, that are ", null, 0, null);
        this.intro.addCodeLine("compared and swapped, when not in the right order, can be much more than ", null, 0, null);
        this.intro.addCodeLine("one - like in bubble sort. Tests showed, that this gap should be decreased by ", null, 0, null);
        this.intro.addCodeLine("factor ~1.3 each round to make the algortihm as fast as possible. When the gapsize ", null, 0, null);
        this.intro.addCodeLine("reaches 9 or 10, it should be set to 11, beuause then, the ordering is done ", null, 0, null);
        this.intro.addCodeLine("faster. Comb Sort has the same worst case complexity as Bubble sort - O(n\u2264) in ", null, 0, null);
        this.intro.addCodeLine("Landau notation, but is slightly faster in most cases.", null, 0, null);
        this.intro.addCodeLine("(extended/taken from wikipedia)", null, 0, null);
        lang.nextStep();
        array.show();
        this.marker.hide();
        this.intro.hide();
        this.source.addCodeLine("static void shakerSort(int[] array) {", null, 0, null);
        this.source.addCodeLine("int gap = array.length;", null, 1, null);
        this.source.addCodeLine("boolean swapped;", null, 1, null);
        this.source.addCodeLine("do {", null, 1, null);
        this.source.addCodeLine("swapped = false;", null, 2, null);
        this.source.addCodeLine("gap = gap * 10 / 13;", null, 2, null);
        this.source.addCodeLine("if (gap == 9 || gap == 10)", null, 2, null);
        this.source.addCodeLine("gap = 11;", null, 3, null);
        this.source.addCodeLine("if (gap < 1)", null, 2, null);
        this.source.addCodeLine("gap = 1;", null, 3, null);
        this.source.addCodeLine("for (int i = 0; i < array.length - gap; i++) ", null, 2, null);
        this.source.addCodeLine("if (array[i] > array[i + gap]) ", null, 3, null);
        this.source.addCodeLine("swapped = true;", null, 4, null);
        this.source.addCodeLine("swap(array[i],array[i+gap]);", null, 4, null);
        this.source.addCodeLine("} while (gap > 1 || swapped);", null, 1, null);
        this.source.addCodeLine("}", null, 0, null);
        this.combSort(lang, array);
    }

    private void combSort(Language lang, IntArray array) {
        boolean swapped;
        TicksTiming defaultTiming = new TicksTiming(15);
        this.source.highlight(0);
        lang.nextStep();
        this.source.unhighlight(0);
        this.source.highlight(1);
        int gap = array.getLength();
        this.gapSizeTxt.show();
        this.gapSizeTxt.setText("Current gap size: " + gap, defaultTiming, defaultTiming);
        this.gapSizeTxt.changeColor(null, Color.RED, defaultTiming, defaultTiming);
        lang.nextStep();
        this.gapSizeTxt.changeColor(null, Color.BLACK, defaultTiming, defaultTiming);
        this.source.unhighlight(1);
        this.source.highlight(2);
        this.swappedTxt.show();
        this.swappedTxt.setText("swapped: ", defaultTiming, defaultTiming);
        this.swappedTxt.changeColor(null, Color.RED, defaultTiming, defaultTiming);
        lang.nextStep();
        this.swappedTxt.changeColor(null, Color.BLACK, defaultTiming, defaultTiming);
        this.source.unhighlight(2);
        do {
            this.source.highlight(3);
            lang.nextStep();
            this.source.unhighlight(3);
            this.source.highlight(4);
            swapped = false;
            this.swappedTxt.setText("swapped: " + String.valueOf(swapped), defaultTiming, defaultTiming);
            this.swappedTxt.changeColor(null, Color.RED, defaultTiming, defaultTiming);
            lang.nextStep();
            this.swappedTxt.changeColor(null, Color.BLACK, defaultTiming, defaultTiming);
            this.source.unhighlight(4);
            this.source.highlight(5);
            gap = gap * 10 / 13;
            this.gapSizeTxt.setText("Current gap size: " + gap, defaultTiming, defaultTiming);
            this.gapSizeTxt.changeColor(null, Color.RED, defaultTiming, defaultTiming);
            lang.nextStep();
            this.gapSizeTxt.changeColor(null, Color.BLACK, defaultTiming, defaultTiming);
            this.source.unhighlight(5);
            this.source.highlight(6);
            this.gapSizeTxt.setText("Current gap size: " + gap, defaultTiming, defaultTiming);
            this.gapSizeTxt.changeColor(null, Color.RED, defaultTiming, defaultTiming);
            lang.nextStep();
            this.gapSizeTxt.changeColor(null, Color.BLACK, defaultTiming, defaultTiming);
            this.source.unhighlight(6);
            if (gap == 9 || gap == 10) {
                this.source.highlight(7);
                gap = 11;
                this.gapSizeTxt.setText("Current gap size: " + gap, defaultTiming, defaultTiming);
                this.gapSizeTxt.changeColor(null, Color.RED, defaultTiming, defaultTiming);
                lang.nextStep();
                this.gapSizeTxt.changeColor(null, Color.BLACK, defaultTiming, defaultTiming);
                this.source.unhighlight(7);
            }
            this.source.highlight(8);
            this.gapSizeTxt.setText("Current gap size: " + gap, defaultTiming, defaultTiming);
            this.gapSizeTxt.changeColor(null, Color.RED, defaultTiming, defaultTiming);
            lang.nextStep();
            this.gapSizeTxt.changeColor(null, Color.BLACK, defaultTiming, defaultTiming);
            this.source.unhighlight(8);
            if (gap < 1) {
                this.source.highlight(9);
                gap = 1;
                this.gapSizeTxt.setText("Current gap size: " + gap, defaultTiming, defaultTiming);
                this.gapSizeTxt.changeColor(null, Color.RED, defaultTiming, defaultTiming);
                lang.nextStep();
                this.gapSizeTxt.changeColor(null, Color.BLACK, defaultTiming, defaultTiming);
                this.source.unhighlight(9);
            }
            this.source.highlight(10);
            lang.nextStep();
            this.source.unhighlight(10);
            this.marker.show();
            this.marker.move(0, null, null);
            while (this.marker.getPosition() < array.getLength() - gap) {
                this.source.highlight(10);
                lang.nextStep();
                this.source.unhighlight(10);
                this.source.highlight(11);
                array.highlightElem(this.marker.getPosition(), null, defaultTiming);
                array.highlightElem(this.marker.getPosition() + gap, null, defaultTiming);
                array.highlightCell(this.marker.getPosition(), this.marker.getPosition() + gap, null, null);
                lang.nextStep();
                this.source.unhighlight(11);
                if (array.getData(this.marker.getPosition()) > array.getData(this.marker.getPosition() + gap)) {
                    this.source.highlight(12);
                    swapped = true;
                    this.swappedTxt.setText("swapped: " + String.valueOf(swapped), defaultTiming, defaultTiming);
                    this.swappedTxt.changeColor(null, Color.RED, defaultTiming, defaultTiming);
                    lang.nextStep();
                    this.swappedTxt.changeColor(null, Color.BLACK, defaultTiming, defaultTiming);
                    this.source.unhighlight(12);
                    this.source.highlight(13);
                    array.swap(this.marker.getPosition(), this.marker.getPosition() + gap, null, defaultTiming);
                    lang.nextStep();
                    this.source.unhighlight(13);
                }
                lang.nextStep();
                array.unhighlightCell(this.marker.getPosition(), this.marker.getPosition() + gap, null, null);
                array.unhighlightElem(this.marker.getPosition(), null, defaultTiming);
                array.unhighlightElem(this.marker.getPosition() + gap, null, defaultTiming);
                this.marker.increment(null, null);
            }
            this.source.highlight(14);
            this.marker.hide();
            this.marker.hide();
            this.gapSizeTxt.changeColor(null, Color.RED, defaultTiming, defaultTiming);
            this.swappedTxt.changeColor(null, Color.RED, defaultTiming, defaultTiming);
            lang.nextStep();
            this.gapSizeTxt.changeColor(null, Color.BLACK, defaultTiming, defaultTiming);
            this.swappedTxt.changeColor(null, Color.BLACK, defaultTiming, defaultTiming);
            this.source.unhighlight(14);
        } while (gap > 1 || swapped);
        lang.nextStep();
        this.source.highlight(15);
        lang.nextStep();
        this.source.unhighlight(15);
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        AnimalScript lang = new AnimalScript("CombSort Animation", "trickSoft", 640, 480);
        ((Language)lang).setStepMode(true);
        RectProperties rectProps = new RectProperties();
        rectProps.set("fillColor", Color.LIGHT_GRAY);
        rectProps.set("filled", true);
        Rect textBox = ((Language)lang).newRect(new Coordinates(60, 10), new Coordinates(230, 55), "Box", null, rectProps);
        TextProperties textProps = new TextProperties();
        textProps.set("font", new Font("SansSerif", 1, 24));
        Text nameText = ((Language)lang).newText(new Coordinates(86, 28), "CombSort", "nameLabelOnTop", null, textProps);
        int[] arrayData = (int[])primitives.get("Input Data");
        IntArray array = ((Language)lang).newIntArray(new Coordinates(60, 130), arrayData, "array", null, (ArrayProperties)props.getPropertiesByName("Array"));
        this.gapSizeTxt = lang.newText(new Coordinates(100, 170), "Current gap size: ", "actual gapsize: ", null);
        this.swappedTxt = lang.newText(new Coordinates(100, 190), "swappped: ", "swapped: ", null);
        this.source = ((Language)lang).newSourceCode(new Coordinates(60, 210), "sourceCode", null, (SourceCodeProperties)props.getPropertiesByName("Source Code"));
        this.intro = ((Language)lang).newSourceCode(new Coordinates(60, 90), "Intro Text", null, (SourceCodeProperties)props.getPropertiesByName("Intro Text"));
        this.marker = ((Language)lang).newArrayMarker(array, 0, "i", null, (ArrayMarkerProperties)props.getPropertiesByName("Marker"));
        this.sort(lang, array);
        return ((Object)lang).toString();
    }

    @Override
    public String getAlgorithmName() {
        return "CombSort";
    }

    @Override
    public String getCodeExample() {
        return CODE;
    }

    @Override
    public Locale getContentLocale() {
        return Locale.US;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(1);
    }

    @Override
    public String getName() {
        return "CombSort";
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public String getAnimationAuthor() {
        return "Daniel Trick, Jonathan R\u00f6mer, Florian Jung";
    }

    @Override
    public void init() {
    }
}

