/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.searching;

import algorithm.animalTranslator.AnimalTranslator;
import algorithm.fileHandler.FileHandler;
import algorithm.stringSearch.BMStringSearch;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.util.Hashtable;
import java.util.Locale;

public class BoyerMooreStringSearchWrapper
implements Generator {
    private static final String DESCRIPTION = "Dieser Algorithmus zur Suche einer Suchmaske in einem Text beruht darauf, dass man zun\u2030chst die letzte Stelle des Suchpatterns betrachtet und im Falle eines Mismatches, das Suchpattern soweit nach hinten verschiebt, bis das erste Zeichen von hinten gesehen wieder passt.";
    private static final String SOURCE_CODE = "fehlt noch";
    private GeneratorType myType = new GeneratorType(2);

    @Override
    public GeneratorType getGeneratorType() {
        return this.myType;
    }

    @Override
    public String getName() {
        return "Boyer/Moore-Suche in Strings";
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        String fullText = (String)primitives.get("text");
        String toSearch = (String)primitives.get("searchFor");
        FileHandler handler = new FileHandler("demo.asu");
        AnimalTranslator animalTrans = new AnimalTranslator(handler);
        BMStringSearch boyerMooreSearch = new BMStringSearch(animalTrans);
        boyerMooreSearch.initialize(fullText, toSearch);
        try {
            boyerMooreSearch.generateAnimation();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return handler.getAnimationCode();
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public String getAlgorithmName() {
        return "Boyer-Moore";
    }

    @Override
    public String getAnimationAuthor() {
        return "Michael Maur";
    }

    @Override
    public void init() {
    }
}

