/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.misc;

import algoanim.animalscript.AnimalScript;
import algoanim.exceptions.IllegalDirectionException;
import algoanim.primitives.Group;
import algoanim.primitives.IntMatrix;
import algoanim.primitives.Polyline;
import algoanim.primitives.Primitive;
import algoanim.primitives.Rect;
import algoanim.primitives.SourceCode;
import algoanim.primitives.StringMatrix;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.MatrixProperties;
import algoanim.properties.PolylineProperties;
import algoanim.properties.RectProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import algoanim.util.Node;
import algoanim.util.Offset;
import algoanim.util.TicksTiming;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.awt.Font;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Locale;
import java.util.StringTokenizer;

public class MatrixMult
implements Generator {
    private Language lang = new AnimalScript("Matrix multiplication", "Tijani, Niko, Arif", 640, 480);
    private IntMatrix mA;
    private IntMatrix mB;
    private StringMatrix mC;
    private int[][] a;
    private int[][] b;
    private int[][] axb;
    private SourceCode sc;
    private ArrayList<Text> sc2;
    private boolean flag1 = true;
    private boolean flag2 = true;
    private MatrixProperties matrixPropAB;
    private MatrixProperties matrixPropC;
    private PolylineProperties lineProps;
    private TextProperties textProp;
    private RectProperties rectProp;
    private SourceCodeProperties sCProp;

    public MatrixMult() {
        this.lang.setStepMode(true);
    }

    public void init(int[][] a, int[][] b) {
        this.description();
        this.check(a, b);
        if (this.flag1 && this.flag2) {
            this.a = a;
            this.b = b;
            this.axb = this.mult(a, b);
            this.lang.nextStep();
            this.showSourceCode1();
            this.sc.highlight(0);
            this.mA = this.lang.newIntMatrix(new Offset(200, 0, this.sc, "NE"), a, "a", null, this.matrixPropAB);
            this.lang.newText(new Offset(-30, 0, this.mA, "W"), "A = ", "textA", null, this.textProp);
            this.drawBracket(this.mA);
            this.mB = this.lang.newIntMatrix(new Offset(100, 0, this.mA, "NE"), b, "b", null, this.matrixPropAB);
            this.lang.newText(new Offset(-30, 0, this.mB, "W"), "B = ", "textB", null, this.textProp);
            this.drawBracket(this.mB);
            this.lang.nextStep();
            this.sc.unhighlight(0);
            this.lang.nextStep();
            String label = "Zur Berechnung der Produktmatrix A x B = C ist es sinnvoll, die Matrizen h\u02c6henversetzt nebeneinander zu schreiben (Falksches Schema) ";
            Text labelAB = this.lang.newText(new Offset(0, 50, this.sc, "SW"), label, "text1", new TicksTiming(5), this.textProp);
            this.lang.nextStep();
            this.mA = this.lang.newIntMatrix(new Offset(50, 50, labelAB, "SW"), a, "mA", null, this.matrixPropAB);
            this.mB = this.lang.newIntMatrix(new Offset(50, 0, this.mA, "NE"), b, "mB", null, this.matrixPropAB);
            Node[] nodes = new Offset[]{new Offset(0, 0, this.mB, "NW"), new Offset(0, 20, this.mB, "SW")};
            Polyline viaLine = this.lang.newPolyline(nodes, "viaLine", null);
            viaLine.hide();
            this.lang.nextStep();
            try {
                this.mA.moveVia("N", null, viaLine, new TicksTiming(20), new TicksTiming(20));
            }
            catch (IllegalDirectionException e) {
                e.printStackTrace();
            }
            this.lang.nextStep();
            Text AxB = this.lang.newText(new Offset(50, 50, labelAB, "SW"), "A x B", "text2", new TicksTiming(15), this.textProp);
            Offset[] nodes1 = new Offset[]{new Offset(2, 0, AxB, "SW"), new Offset(2, 40, AxB, "SW")};
            Offset[] nodes2 = new Offset[]{new Offset(2, 0, AxB, "E"), new Offset(42, 0, AxB, "E")};
            this.lineProps.set("fwArrow", true);
            this.drawLines(nodes1, nodes2, "l1", "l2", false);
            nodes1 = new Offset[]{new Offset(-25, 0, this.mB, "NW"), new Offset(-25, this.getY(a.length, b.length), this.mB, "NW")};
            nodes2 = this.getNodes(a, b, this.mA, this.mB);
            this.lineProps.set("fwArrow", false);
            this.drawLines(nodes1, nodes2, "l3", "l4", true);
            this.lang.nextStep();
            Offset offsetC = new Offset(0, 15, this.mB, "SW");
            this.mC = this.drawMatrixC(new String[a.length][b[0].length], offsetC, this.matrixPropC);
            this.lang.nextStep();
            this.sc.unhighlight(1);
            this.lang.nextStep();
            this.sc2 = this.showSourceCode2();
        }
    }

    private void check(int[][] matrixA, int[][] matrixB) {
        if (this.flag2) {
            TextProperties textProp = new TextProperties();
            textProp.set("color", Color.RED);
            textProp.set("font", new Font("Bold", 0, 18));
            if (matrixA[0].length != matrixB.length) {
                this.flag1 = false;
                this.lang.newText(new Coordinates(50, 200), "Die Multiplikation kann nicht ausgefuehrt werden, da die Anzahl der Spalten von Matrix A ungleich die Anzahl der Zeilen in Matrix B", "text", null, textProp);
            }
        }
    }

    public void inciteMult() {
        if (this.flag1 && this.flag2) {
            int index = 0;
            Text oldText = null;
            int i = 0;
            while (i < this.axb.length) {
                this.highlightLine(2, i, false, false);
                int j = 0;
                while (j < this.axb[0].length) {
                    this.highlightLine(3, j, false, true);
                    this.highlightLine(4, 0, true, false);
                    this.mC.highlightElem(i, j, new TicksTiming(20), new TicksTiming(20));
                    this.lang.nextStep();
                    this.sc2.get(index).show();
                    this.lang.nextStep();
                    this.sc.highlight(5);
                    this.lang.nextStep();
                    String newText = String.valueOf(Integer.toString(this.mA.getElement(i, 0))) + "*" + Integer.toString(this.mB.getElement(0, j));
                    oldText = this.highlight(i, j, 0, this.sc2.get(index), this.textProp, newText);
                    this.sc.unhighlight(5);
                    this.lang.nextStep();
                    int k = 1;
                    while (k < this.b.length) {
                        this.highlightLine(4, k, true, false);
                        this.sc.highlight(5);
                        this.lang.nextStep();
                        newText = "+" + Integer.toString(this.mA.getElement(i, k)) + "*" + Integer.toString(this.mB.getElement(k, j));
                        oldText = this.highlight(i, j, k, oldText, this.textProp, newText);
                        this.sc.unhighlight(5);
                        this.lang.nextStep();
                        ++k;
                    }
                    newText = "=" + Integer.toString(this.axb[i][j]);
                    oldText = this.lang.newText(new Offset(0, 0, oldText, "NE"), newText, "=", null, this.textProp);
                    this.mC.unhighlightElem(i, j, new TicksTiming(20), new TicksTiming(20));
                    ++index;
                    this.lang.nextStep();
                    ++j;
                }
                ++i;
            }
            this.sc.highlight(9);
            this.lang.nextStep();
            this.transform();
            this.sc.unhighlight(9);
            this.lang.nextStep();
            this.lang.newRect(new Offset(-10, -10, this.sc2.get(0), "NW"), new Offset(10, 10, oldText, "SE"), "rect", null, this.rectProp);
            this.lang.newRect(new Offset(-8, -8, this.sc2.get(0), "NW"), new Offset(12, 12, oldText, "SE"), "rect", null, this.rectProp);
            this.lang.newRect(new Offset(-6, -6, this.sc2.get(0), "NW"), new Offset(14, 14, oldText, "SE"), "rect", null, this.rectProp);
        }
    }

    private void transform() {
        int i = 0;
        while (i < this.axb.length) {
            int j = 0;
            while (j < this.axb[0].length) {
                this.mC.put(i, j, Integer.toString(this.axb[i][j]), new TicksTiming(20), new TicksTiming(20));
                ++j;
            }
            ++i;
        }
    }

    private void showSourceCode1() {
        this.sc = this.lang.newSourceCode(new Coordinates(40, 40), "sourceCode", null, this.sCProp);
        this.sc.addCodeLine("public  int[][] mult(int[][] a, int[][] b){", null, 0, null);
        this.sc.addCodeLine("int[][] c = new int[a.length][b[0].length];", null, 1, null);
        this.sc.addCodeLine("for (int i = 0; i < a.length; i++) {", null, 1, null);
        this.sc.addCodeLine("for (int j = 0; j < b[0].length; j++) {", null, 2, null);
        this.sc.addCodeLine("for (int k = 0; k < b.length; k++) {", null, 3, null);
        this.sc.addCodeLine("c[i][j]+=a[i][k]*b[k][j]", null, 4, null);
        this.sc.addCodeLine("}", null, 3, null);
        this.sc.addCodeLine("}", null, 2, null);
        this.sc.addCodeLine("}", null, 1, null);
        this.sc.addCodeLine("return c;", null, 1, null);
        this.sc.addCodeLine("}", null, 0, null);
        this.lang.newRect(new Offset(-10, -10, this.sc, "NW"), new Offset(10, 10, this.sc, "SE"), "rect", null, this.rectProp);
        this.lang.newRect(new Offset(-8, -8, this.sc, "NW"), new Offset(12, 12, this.sc, "SE"), "rect", null, this.rectProp);
        this.lang.newRect(new Offset(-6, -6, this.sc, "NW"), new Offset(14, 14, this.sc, "SE"), "rect", null, this.rectProp);
        this.lang.nextStep();
    }

    public ArrayList<Text> showSourceCode2() {
        this.textProp.set("hidden", true);
        String s = null;
        String name = null;
        ArrayList<Text> sc2 = new ArrayList<Text>();
        int y = 0;
        int i = 1;
        while (i <= this.a.length) {
            int j = 1;
            while (j <= this.b[0].length) {
                s = "C" + Integer.toString(i) + Integer.toString(j) + "= ";
                name = String.valueOf(Integer.toString(i)) + Integer.toString(j);
                Text t = this.lang.newText(new Offset(200, y, this.mB, "NE"), s, name, null, this.textProp);
                sc2.add(t);
                y += 20;
                ++j;
            }
            ++i;
        }
        this.textProp.set("hidden", false);
        return sc2;
    }

    private void highlightLine(int i, int index, boolean b1, boolean b2) {
        this.sc.highlight(i);
        this.lang.nextStep();
        if (!b1 && !b2) {
            this.mA.highlightCellColumnRange(index, 0, this.mA.getNrCols() - 1, new TicksTiming(20), new TicksTiming(20));
            this.lang.nextStep();
            this.mA.unhighlightCellColumnRange(index, 0, this.mA.getNrCols() - 1, new TicksTiming(20), new TicksTiming(20));
        } else if (!b1 && b2) {
            this.mB.highlightCellRowRange(0, this.mB.getNrRows() - 1, index, new TicksTiming(20), new TicksTiming(20));
            this.lang.nextStep();
            this.mB.unhighlightCellRowRange(0, this.mB.getNrRows() - 1, index, new TicksTiming(20), new TicksTiming(20));
        }
        this.sc.unhighlight(i);
        this.lang.nextStep();
    }

    public Text highlight(int i, int j, int k, Text oldText, TextProperties scProps, String newText) {
        this.mA.highlightElem(i, k, new TicksTiming(40), new TicksTiming(20));
        this.mB.highlightElem(k, j, new TicksTiming(40), new TicksTiming(20));
        this.lang.nextStep();
        oldText = this.lang.newText(new Offset(0, 0, oldText, "NE"), newText, Integer.toString(k), null, scProps);
        this.lang.nextStep();
        this.mA.unhighlightElem(i, k, new TicksTiming(20), new TicksTiming(20));
        this.mB.unhighlightElem(k, j, new TicksTiming(20), new TicksTiming(20));
        this.lang.nextStep();
        return oldText;
    }

    private Offset[] getNodes(int[][] a, int[][] b, IntMatrix ma, IntMatrix mb) {
        int x = (2 * a[0].length - 1 + (2 * b[0].length - 1)) * 20 + 50;
        if (b.length < a.length) {
            return new Offset[]{new Offset(0, 0, ma, "SW"), new Offset(x, 0, ma, "SW")};
        }
        return new Offset[]{new Offset(20, 0, mb, "SE"), new Offset(-x, 0, mb, "SE")};
    }

    private int getY(int l1, int l2) {
        return (2 * l1 - 1 + (2 * l2 - 1)) * 20;
    }

    private StringMatrix drawMatrixC(String[][] cString, Offset offsetC, MatrixProperties propForMc2) {
        this.sc.highlight(1);
        int i = 1;
        while (i <= cString.length) {
            int j = 1;
            while (j <= cString[0].length) {
                cString[i - 1][j - 1] = "C" + Integer.toString(i) + Integer.toString(j);
                ++j;
            }
            ++i;
        }
        return this.lang.newStringMatrix(offsetC, cString, "C", null, this.matrixPropC);
    }

    private void drawLines(Offset[] ns1, Offset[] ns2, String name1, String name2, boolean b) {
        Polyline l1 = this.lang.newPolyline(ns1, name1, null, this.lineProps);
        Polyline l2 = this.lang.newPolyline(ns2, name2, null, this.lineProps);
        if (b) {
            ns1 = new Offset[]{new Offset(-2, 0, l1, "NE"), new Offset(-2, 0, l1, "SE")};
            ns2 = new Offset[]{new Offset(0, -2, l2, "NE"), new Offset(0, -2, l2, "NW")};
            this.lang.newPolyline(ns1, "l1_2", null, this.lineProps);
            this.lang.newPolyline(ns2, "l2_2", null, this.lineProps);
        }
    }

    private void drawBracket(IntMatrix m) {
        Node[] nodes = new Offset[]{new Offset(0, 0, m, "NW"), new Offset(0, 10, m, "SW")};
        Polyline lLeft = this.lang.newPolyline(nodes, "line1", null, this.lineProps);
        nodes = new Offset[]{new Offset(-5, 0, m, "NE"), new Offset(-5, 10, m, "SE")};
        Polyline lRight = this.lang.newPolyline(nodes, "line2", null, this.lineProps);
        nodes = new Offset[]{new Offset(0, 0, lLeft, "NW"), new Offset(3, 0, lLeft, "NW")};
        this.lang.newPolyline(nodes, "line1", null, this.lineProps);
        nodes = new Offset[]{new Offset(0, 0, lRight, "NW"), new Offset(-3, 0, lRight, "NW")};
        this.lang.newPolyline(nodes, "line1", null, this.lineProps);
        nodes = new Offset[]{new Offset(0, 0, lLeft, "SW"), new Offset(3, 0, lLeft, "SW")};
        this.lang.newPolyline(nodes, "line1", null, this.lineProps);
        nodes = new Offset[]{new Offset(0, 0, lRight, "SW"), new Offset(-3, 0, lRight, "SW")};
        this.lang.newPolyline(nodes, "line1", null, this.lineProps);
    }

    public int[][] mult(int[][] a, int[][] b) {
        int[][] c = new int[a.length][b[0].length];
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < b[0].length) {
                int k = 0;
                while (k < b.length) {
                    int[] nArray = c[i];
                    int n = j;
                    nArray[n] = nArray[n] + a[i][k] * b[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return c;
    }

    public static void main(String[] args) throws IllegalDirectionException {
        int[][] a = new int[][]{{1, 2, 3}, {4, 5, 6}};
        int[][] b = new int[][]{{1, 2}, {3, 4}, {5, 6}};
        MatrixMult t = new MatrixMult();
        t.matrixPropAB = new MatrixProperties();
        t.matrixPropAB.set("fillColor", Color.WHITE);
        t.matrixPropC = new MatrixProperties();
        t.matrixPropC.set("fillColor", Color.WHITE);
        t.textProp = new TextProperties();
        t.lineProps = new PolylineProperties();
        t.rectProp = new RectProperties();
        t.sCProp = new SourceCodeProperties();
        t.init(a, b);
        t.inciteMult();
        try {
            FileOutputStream out = new FileOutputStream("C:/firstPart.asu");
            PrintStream p = new PrintStream(out);
            p.println(t.lang);
            out = new FileOutputStream("Test.asu");
            p = new PrintStream(out);
            p.println(t.lang);
            p.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println("Error writing to file");
        }
        System.out.println("done");
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        int zA = (Integer)primitives.get("row_number_Of _MatrixA");
        int sA = (Integer)primitives.get("col_number_Of _MatrixA");
        int zB = (Integer)primitives.get("row_number_Of _MatrixB");
        int sB = (Integer)primitives.get("col_number_Of _MatrixB");
        int[][] a = this.parse((String)primitives.get("MatrixA"), zA, sA);
        int[][] b = this.parse((String)primitives.get("MatrixB"), zB, sB);
        this.matrixPropAB = (MatrixProperties)props.get(0);
        this.matrixPropC = (MatrixProperties)props.get(1);
        this.textProp = (TextProperties)props.get(2);
        this.lineProps = (PolylineProperties)props.get(3);
        this.rectProp = (RectProperties)props.get(4);
        this.sCProp = (SourceCodeProperties)props.get(5);
        this.init(a, b);
        this.inciteMult();
        return this.lang.toString();
    }

    private void description() {
        TextProperties textProp = new TextProperties();
        textProp.set("color", Color.RED);
        textProp.set("font", new Font("Bold", 1, 18));
        this.lang.newText(new Coordinates(400, 10), "Multiplikation zweier Matrizen", "titel", null, textProp);
        this.lang.nextStep();
        SourceCodeProperties scProps = new SourceCodeProperties();
        scProps.set("font", new Font("Monospaced", 0, 18));
        this.lang.nextStep();
        scProps.set("color", Color.BLACK);
        SourceCode sc = this.lang.newSourceCode(new Coordinates(10, 40), "discription", null, scProps);
        sc.addCodeLine("Das Produkt zweier Matrizen A und B ist nur dann definiert, wenn die Anzahl der Spalten der ersten Matrix", null, 0, null);
        this.lang.nextStep();
        sc.addCodeLine("gleich der Anzahl der Zeilen der zweiten Matrix ist.", null, 0, null);
        this.lang.nextStep();
        sc.addCodeLine("D.h., wenn A eine n x m-Matrix ist, so mu\ufb02 B eine m x k-Matrix sein. ", null, 0, null);
        this.lang.nextStep();
        sc.addCodeLine("Die Produktmatrix C=A.B ist dann eine n x k-Matrix.", null, 0, null);
        this.lang.nextStep();
        sc.addCodeLine("Zur Berechnung des Elements Cij der Produktmatrix wird die i-te Zeile der ersten Matrix mit der j-ten Spalte", null, 0, null);
        this.lang.nextStep();
        sc.addCodeLine("der zweiten Matrix multipliziert (im Sinne eines Skalarprodukts):", null, 0, null);
        this.lang.nextStep();
        this.blub(sc);
        this.lang.nextStep();
        sc.hide();
    }

    private void blub(SourceCode sc) {
        LinkedList<Primitive> list = new LinkedList<Primitive>();
        TextProperties textProp = new TextProperties();
        textProp.set("color", Color.BLACK);
        PolylineProperties pl = new PolylineProperties();
        pl.set("color", Color.BLACK);
        list.add(this.lang.newText(new Offset(-30, 45, sc, "S"), "Cij =", "t1", null, textProp));
        Node[] nodes = new Offset[]{new Offset(0, 50, sc, "S"), new Offset(20, 50, sc, "S")};
        list.add(this.lang.newPolyline(nodes, "l1", null, pl));
        nodes = new Offset[]{new Offset(0, 50, sc, "S"), new Offset(10, 60, sc, "S")};
        list.add(this.lang.newPolyline(nodes, "l2", null, pl));
        nodes = new Offset[]{new Offset(10, 60, sc, "S"), new Offset(0, 70, sc, "S")};
        list.add(this.lang.newPolyline(nodes, "l3", null, pl));
        nodes = new Offset[]{new Offset(0, 70, sc, "S"), new Offset(25, 70, sc, "S")};
        list.add(this.lang.newPolyline(nodes, "l4", null, pl));
        list.add(this.lang.newText(new Offset(-5, -20, (Primitive)list.get(1), "N"), "m", "t2", null, textProp));
        list.add(this.lang.newText(new Offset(-5, -20, (Primitive)list.get(1), "N"), "m", "t2", null, textProp));
        list.add(this.lang.newText(new Offset(-7, 0, (Primitive)list.get(4), "S"), "s=1", "t3", null, textProp));
        list.add(this.lang.newText(new Offset(40, 49, sc, "S"), "Ais*Bsj", "t4", null, textProp));
        Rect rect = this.lang.newRect(new Offset(-5, -30, (Primitive)list.get(0), "NW"), new Offset(5, 30, (Primitive)list.getLast(), "SE"), "rect", null);
        list.add(rect);
        Group g = this.lang.newGroup(list, "list");
        this.lang.nextStep();
        g.hide();
        this.lang.nextStep();
    }

    private int[][] parse(String m, int z, int s) {
        boolean b = true;
        int[][] matrix = new int[z][s];
        StringTokenizer st = new StringTokenizer(m, "; ");
        int counter = 0;
        while (st.hasMoreTokens() && b && counter < z) {
            if (!this.flag2) break;
            try {
                b = this.add(matrix[counter], new StringTokenizer(st.nextToken(), "{}, "));
            }
            catch (Exception e) {
                String text = "Die Elemente der Matrizen sollen alle von typ Integer sein ;-)";
                TextProperties textProp = new TextProperties();
                textProp.set("color", Color.RED);
                textProp.set("font", new Font("Bold", 0, 18));
                this.lang.newText(new Coordinates(50, 200), text, "text1", null, textProp);
                this.flag2 = false;
                break;
            }
            ++counter;
        }
        return matrix;
    }

    private boolean add(int[] elem, StringTokenizer sT) {
        boolean b = true;
        try {
            if (elem.length < sT.countTokens()) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            b = false;
            TextProperties textProp = new TextProperties();
            textProp.set("color", Color.RED);
            textProp.set("font", new Font("Bold", 0, 18));
            String text = "Die Zeilen der Matrix haben nicht die selbe L\u2030nge";
            this.lang.newText(new Coordinates(50, 200), text, "text2", null, textProp);
            this.flag2 = false;
            this.lang.nextStep();
        }
        if (b) {
            int i = 0;
            while (i < elem.length && sT.hasMoreTokens()) {
                elem[i] = Integer.parseInt(sT.nextToken());
                ++i;
            }
        }
        return b;
    }

    @Override
    public String getAlgorithmName() {
        return "Matrix multiplication";
    }

    @Override
    public String getAnimationAuthor() {
        return "Tijani Ahmedou, Arif Sami, Nikola Dyundev";
    }

    @Override
    public String getCodeExample() {
        return "public  int[][] mult(int[][] a, int[][] b){\n   int[][] c = new int[a.length][b[0].length];\n   for (int i = 0; i < a.length; i++) {\n      for (int j = 0; j < b[0].length; j++) {\n         for (int k = 0; k < b.length; k++) {\n            c[i][j]+=a[i][k]*b[k][j];\n         }\n      }\n   }\n   return c;\n}\n";
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }

    @Override
    public String getDescription() {
        return "Animates matrix multiplication with Source Code + Highlighting";
    }

    @Override
    public String getFileExtension() {
        return ".asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(0x40000000);
    }

    @Override
    public String getName() {
        return "matrix multiplication";
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public void init() {
    }
}

