/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.graph;

import algoanim.animalscript.AnimalScript;
import algoanim.primitives.Graph;
import algoanim.primitives.IntMatrix;
import algoanim.primitives.SourceCode;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.CircleProperties;
import algoanim.properties.GraphProperties;
import algoanim.properties.MatrixProperties;
import algoanim.properties.PolylineProperties;
import algoanim.properties.RectProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import algoanim.util.DisplayOptions;
import algoanim.util.Node;
import algoanim.util.TicksTiming;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.awt.Font;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class Dijkstra2
implements Generator {
    protected Language lang;
    Node node;
    MatrixProperties matrixProps;
    RectProperties rectProps;
    GraphProperties graphProps;
    CircleProperties circleProps;
    PolylineProperties arcProps;
    TextProperties textProps;
    IntMatrix matrix;
    String name;
    int[][] graphAdjacencyMatrix;
    static Node[] graphNodes;
    static String[] labels;
    DisplayOptions display;
    public SourceCode sc;
    public SourceCode labelNode;
    public SourceCode distanceNode;
    public Graph gr;
    public int[] nodeIndices;
    public AnimationPropertiesContainer animationProperties;
    Node start;
    Node target;
    int[] distance;
    Node[] predecessor;
    boolean[] visited;
    int indexTarget;
    int indexStart;
    int size;
    public int inc = 0;
    SourceCodeProperties scProps = new SourceCodeProperties();

    public void showGraph(Graph graph) {
        int size = graph.getSize();
        graphNodes = new Node[size];
        labels = new String[size];
        int i = 0;
        while (i < graph.getSize()) {
            Dijkstra2.graphNodes[i] = graph.getNode(i);
            Dijkstra2.labels[i] = graph.getNodeLabel(i);
            ++i;
        }
        this.graphProps = (GraphProperties)this.animationProperties.getPropertiesByName("graph");
        this.gr = this.lang.newGraph(graph.getName(), graph.getAdjacencyMatrix(), graphNodes, labels, graph.getDisplayOptions(), this.graphProps);
    }

    public int dij(Node start, Node tarjet, Graph gra) {
        this.showGraph(gra);
        this.showSourceCode();
        Text text5 = this.lang.newText(new Coordinates(600, 400), "", "text", this.display, this.textProps);
        TicksTiming timing = new TicksTiming(30);
        this.size = gra.getSize();
        graphNodes = new Node[this.size];
        labels = new String[this.size];
        this.distance = new int[this.size];
        this.predecessor = new Node[this.size];
        this.visited = new boolean[this.size];
        Vector<Node> Set2 = new Vector<Node>();
        this.sc.highlight(0);
        int i = 0;
        while (i < gra.getSize()) {
            this.distance[i] = 5000;
            this.visited[i] = false;
            this.predecessor[i] = null;
            ++i;
        }
        this.lang.nextStep();
        this.sc.toggleHighlight(0, 1);
        i = 0;
        while (i < this.gr.getSize()) {
            this.distanceNode = this.lang.newSourceCode(new Coordinates(80, 500 + this.inc), "distancenode" + i, null, this.scProps);
            this.distanceNode.addCodeLine("Distance", null, 0, null);
            this.distanceNode.addCodeLine(this.gr.getNodeLabel(i), null, 6 + 3 * i, null);
            Dijkstra2.graphNodes[i] = this.gr.getNode(i);
            Dijkstra2.labels[i] = this.gr.getNodeLabel(i);
            if (start == this.gr.getNode(i)) {
                this.distanceNode = this.lang.newSourceCode(new Coordinates(80, 545 + this.inc), "distancenode" + i, null, this.scProps);
                this.distanceNode.addCodeLine("0", null, 6 + 3 * i, null);
                this.distance[i] = 0;
                text5.setText("der start Knoten mit eine Distanz null initializiert", null, null);
                this.predecessor[i] = null;
                this.indexStart = i;
                this.lang.nextStep();
                this.sc.toggleHighlight(1, 2);
                text5.setText("Danach wird in die Menge der abzuarbeitenden Knoten eingef\u00b8gt", null, null);
                Set2.add(start);
            }
            if (i != this.indexStart) {
                this.distanceNode = this.lang.newSourceCode(new Coordinates(80, 545 + this.inc), "distancenode" + i, null, this.scProps);
                this.distanceNode.addCodeLine("*", null, 6 + 3 * i, null);
            }
            if (tarjet == this.gr.getNode(i)) {
                this.indexTarget = i;
            }
            if (tarjet == start) {
                text5.setText("start und ziel Knoten sind gleich" + this.gr.getNodeLabel(this.indexStart) + this.gr.getNodeLabel(this.indexTarget), null, null);
                return -1;
            }
            ++i;
        }
        this.lang.nextStep();
        text5.setText("", null, null);
        this.sc.toggleHighlight(2, 3);
        while (!Set2.isEmpty()) {
            this.lang.nextStep();
            this.sc.toggleHighlight(3, 4);
            text5.setText("Die n\u2030chste noch nicht besucht Knoten wird aus dem set geholt", null, null);
            Node n = this.getNeighbour(Set2);
            int y = this.getByName(n);
            this.gr.highlightNode(y, null, null);
            this.lang.nextStep();
            this.sc.toggleHighlight(4, 5);
            text5.setText("Es wird \u00b8berpr\u00b8ft ob der aktuelle Knoten der Zielknoten ist", null, null);
            if (n == tarjet) {
                this.lang.nextStep();
                this.sc.toggleHighlight(5, 6);
                text5.setText("k\u00b8rzste weg von start knoten  " + this.gr.getNodeLabel(this.indexStart) + "  zum ziel Knoten  " + gra.getNodeLabel(this.indexTarget) + "  ist " + this.distance[this.indexTarget], timing, timing);
                this.gr.highlightNode(this.indexTarget, null, null);
                Node vorgaengerziel = this.getvorgaenger(n);
                y = this.getByName(vorgaengerziel);
                this.gr.highlightNode(y, null, null);
                this.gr.highlightEdge(this.indexTarget, y, null, null);
                while (vorgaengerziel != start) {
                    int x = this.getByName(vorgaengerziel);
                    vorgaengerziel = this.getvorgaenger(vorgaengerziel);
                    y = this.getByName(vorgaengerziel);
                    this.gr.highlightEdge(y, x, null, null);
                    this.gr.highlightNode(y, null, null);
                }
                return this.distance[this.indexTarget];
            }
            this.lang.nextStep();
            text5.setText("", null, null);
            this.sc.toggleHighlight(5, 8);
            int[] Edge2 = this.gr.getEdgesForNode(y);
            this.lang.nextStep();
            this.sc.toggleHighlight(8, 9);
            text5.setText("Alle Knoten auf die Kanten der aktuellen Knoten verweise,werde \u00b8berpr\u00b8ft", null, null);
            this.gr.highlightNode(y, null, null);
            this.lang.nextStep();
            text5.setText("", null, null);
            this.labelNode = this.lang.newSourceCode(new Coordinates(50, 578 + this.inc), "labelnode", null, this.scProps);
            this.labelNode.addCodeLine(this.gr.getNodeLabel(y), null, 0, null);
            this.labelNode = this.lang.newSourceCode(new Coordinates(50, 578 + this.inc), "labelnode", null, this.scProps);
            this.labelNode.addCodeLine("|", null, 4, null);
            int j = 0;
            while (j < Edge2.length) {
                if (this.gr.getEdgeWeight(y, j) != 0) {
                    this.sc.toggleHighlight(9, 10);
                    this.gr.highlightEdge(y, j, null, null);
                    this.gr.highlightNode(j, null, null);
                    text5.setText("\u2039berpr\u00b8fen von Knoten  " + this.gr.getNodeLabel(j), null, null);
                    if (!Set2.contains(this.gr.getNode(j))) {
                        text5.setText("Knoten " + this.gr.getNodeLabel(j) + " wird nocht nicht besucht", null, null);
                        this.lang.nextStep();
                        this.sc.toggleHighlight(10, 11);
                        this.distance[j] = this.distance[y] + this.gr.getEdgeWeight(y, j);
                        this.predecessor[j] = this.gr.getNode(y);
                        this.lang.nextStep();
                        this.sc.toggleHighlight(11, 12);
                        text5.setText("Der Knoten wird in die Menge eingef\u00b8gt", null, null);
                        Set2.add(gra.getNode(j));
                        this.lang.nextStep();
                        this.sc.unhighlight(12);
                    } else {
                        this.lang.nextStep();
                        this.sc.unhighlight(10);
                        this.sc.toggleHighlight(12, 13);
                        text5.setText("Knoten " + this.gr.getNodeLabel(j) + " ist sch\u02c6n in die Menge set eingef\u00b8gt .Es wird \u00b8berpr\u00b8ft ob der aktuelle weg k\u00b8rzer ist", null, null);
                        if (this.distance[j] > this.distance[y] + this.gr.getEdgeWeight(y, j) && !this.visited[j] && this.gr.getEdgeWeight(y, j) != 0) {
                            this.lang.nextStep();
                            this.sc.toggleHighlight(13, 14);
                            this.distance[j] = this.distance[y] + this.gr.getEdgeWeight(y, j);
                            this.predecessor[j] = this.gr.getNode(y);
                        }
                    }
                    this.lang.addLine("*************************");
                    this.lang.nextStep();
                    this.sc.unhighlight(10);
                    this.sc.unhighlight(12);
                    this.sc.unhighlight(13);
                    this.sc.unhighlight(14);
                    this.gr.unhighlightNode(j, null, null);
                    this.gr.unhighlightEdge(y, j, null, null);
                    text5.setText("", null, null);
                }
                this.distanceNode = this.lang.newSourceCode(new Coordinates(80, 580 + this.inc), "distancenode" + j, null, this.scProps);
                if (this.distance[j] < 5000) {
                    this.distanceNode.addCodeLine("" + this.distance[j], null, 6 + j * 3, null);
                } else {
                    this.distanceNode.addCodeLine("*", null, 6 + j * 3, null);
                }
                ++j;
            }
            this.visited[y] = true;
            this.gr.unhighlightNode(y, null, null);
            this.inc += 20;
        }
        return 0;
    }

    public Node getNeighbour(Vector<Node> t) {
        int kleinsteGewicht = 90000;
        Node nodemitKleinsteGewicht = null;
        Enumeration<Node> u = t.elements();
        while (u.hasMoreElements()) {
            Node m = u.nextElement();
            int x = this.getByName(m);
            if (this.visited[x] || this.distance[x] >= kleinsteGewicht) continue;
            kleinsteGewicht = this.distance[x];
            nodemitKleinsteGewicht = m;
        }
        return nodemitKleinsteGewicht;
    }

    public int getByName(Node node) {
        int i = 0;
        while (i < this.gr.getSize()) {
            if (node == this.gr.getNode(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Node getvorgaenger(Node node) {
        int x = this.getByName(node);
        return this.predecessor[x];
    }

    @Override
    public void init() {
        this.lang = new AnimalScript("Dijkstra Animation", "Madieha + Bouchra", 620, 480);
        this.lang.setStepMode(true);
        this.matrixProps = new MatrixProperties();
        this.textProps = new TextProperties();
        this.rectProps = new RectProperties();
        this.arcProps = new PolylineProperties();
        this.circleProps = new CircleProperties();
        this.circleProps.set("depth", 1);
        this.circleProps.set("filled", true);
        this.circleProps.set("fillColor", Color.WHITE);
        this.arcProps.set("depth", 5);
        this.matrixProps.set("elementColor", Color.BLACK);
        this.matrixProps.set("elemHighlight", Color.red);
        this.matrixProps.set("filled", true);
        this.matrixProps.set("fillColor", Color.pink);
        this.matrixProps.set("cellHighlight", Color.MAGENTA);
        this.matrixProps.set("depth", 1);
        this.textProps.set("color", Color.blue);
        this.textProps.set("font", new Font("Monospaced", 1, 14));
        this.rectProps.set("filled", true);
        this.rectProps.set("fillColor", Color.orange);
        this.rectProps.set("depth", 10);
    }

    public void showSourceCode() {
        this.scProps.set("contextColor", Color.CYAN);
        this.scProps.set("font", new Font("Monospaced", 1, 16));
        this.scProps.set("highlightColor", Color.red);
        this.scProps.set("color", Color.BLACK);
        this.sc = this.lang.newSourceCode(new Coordinates(40, 100), "sourceCode", null, this.scProps);
        this.labelNode = this.lang.newSourceCode(new Coordinates(50, 530), "labelnode", null, this.scProps);
        this.distanceNode = this.lang.newSourceCode(new Coordinates(55, 600), "distancenode", null, this.scProps);
        this.sc.addCodeLine("public int Dijkstra(Node start, Node tarjet,) {", null, 0, null);
        this.sc.addCodeLine("start.distance = 0;", null, 1, null);
        this.sc.addCodeLine("set.add(start);", null, 1, null);
        this.sc.addCodeLine("while(!set.isEmpty(){", null, 1, null);
        this.sc.addCodeLine("Node n = set.getNextNeighbour();", null, 1, null);
        this.sc.addCodeLine("if (n==tarjet){", null, 1, null);
        this.sc.addCodeLine("return n.distance;", null, 2, null);
        this.sc.addCodeLine("}", null, 1, null);
        this.sc.addCodeLine("for(Edge e:n.getEdges()){", null, 1, null);
        this.sc.addCodeLine("v = e.getDestinations();", null, 2, null);
        this.sc.addCodeLine("if (!set.contains(v)){", null, 2, null);
        this.sc.addCodeLine("v.distance = n.distance + e.weight ;", null, 3, null);
        this.sc.addCodeLine("set.add(v);", null, 3, null);
        this.sc.addCodeLine("} else if (v.distance > n.distance + e.weight){", null, 2, null);
        this.sc.addCodeLine("v.distance = n.distance + e.weight ;", null, 3, null);
        this.sc.addCodeLine("}", null, 2, null);
        this.sc.addCodeLine("}", null, 1, null);
        this.sc.addCodeLine("}", null, 0, null);
        this.sc.addCodeLine("", null, 0, null);
        this.labelNode.addCodeLine("----------------------------------------", null, 0, null);
        this.labelNode.addCodeLine("|", null, 4, null);
    }

    @Override
    public String getCodeExample() {
        return "Straight forward Warshall Algorithm";
    }

    @Override
    public Locale getContentLocale() {
        return Locale.US;
    }

    @Override
    public String getDescription() {
        return "Animates Warshall with Source Code + Highlighting";
    }

    @Override
    public String getFileExtension() {
        return ".asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(8);
    }

    @Override
    public String getName() {
        return "Dijkstra";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        this.init();
        Enumeration<String> iter = primitives.keys();
        while (iter.hasMoreElements()) {
            String element = iter.nextElement();
            if (!element.contains("graph")) continue;
            this.gr = (Graph)primitives.get(element);
        }
        this.animationProperties = props;
        this.dij(this.gr.getStartKnoten(), this.gr.getZielKnoten(), this.gr);
        return this.lang.toString();
    }

    @Override
    public String getAlgorithmName() {
        return "Dijkstra";
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public String getAnimationAuthor() {
        return "Madieha Taddbier, Bouchra Elfakir";
    }
}

