/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.compression;

import algoanim.exceptions.LineNotExistsException;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.Primitive;
import algoanim.primitives.Text;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.properties.PolylineProperties;
import algoanim.util.Coordinates;
import algoanim.util.Offset;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.helpers.AnimatedCompressionAlgorithm;
import java.awt.Color;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;

public class LZW2
extends AnimatedCompressionAlgorithm {
    private static final int MAX_INPUT_LENGTH = 24;
    private HashMap<String, Text> internalMap;

    public LZW2() {
        this("resources/LZW_Java", Locale.US);
    }

    public LZW2(String aResourceName, Locale aLocale) {
        super(aResourceName, aLocale);
        this.init();
    }

    @Override
    public void init() {
        super.init();
        this.internalMap = new HashMap(61);
    }

    public void compress(String[] text) throws LineNotExistsException {
        String ein = "";
        String[] t = new String[Math.min(text.length, 24)];
        int i = 0;
        while (i < t.length) {
            t[i] = text[i];
            ein = String.valueOf(ein) + text[i];
            ++i;
        }
        Text algoinWords = this.lang.newText(new Coordinates(20, 100), this.translator.translateMessage("inWords"), "inWords", null, tpwords);
        this.lang.nextStep();
        Text step0 = this.lang.newText(new Offset(0, 100, this.header, "SW"), this.translator.translateMessage("step00"), "line0", null, tpsteps);
        Text step01 = this.lang.newText(new Offset(0, 20, step0, "SW"), this.translator.translateMessage("step01"), "line0", null, tpsteps);
        Text step02 = this.lang.newText(new Offset(0, 20, step01, "SW"), this.translator.translateMessage("step02"), "line0", null, tpsteps);
        this.lang.nextStep();
        Text step1 = this.lang.newText(new Offset(0, 40, step02, "SW"), this.translator.translateMessage("step1"), "line1", null, tpsteps);
        this.lang.nextStep();
        Text step2 = this.lang.newText(new Offset(0, 40, step1, "SW"), this.translator.translateMessage("step2"), "line2", null, tpsteps);
        this.lang.nextStep();
        Text step3 = this.lang.newText(new Offset(0, 40, step2, "SW"), this.translator.translateMessage("step3"), "line3", null, tpsteps);
        Text step31 = this.lang.newText(new Offset(0, 20, step3, "SW"), this.translator.translateMessage("step31"), "line31", null, tpsteps);
        this.lang.nextStep();
        Text step4 = this.lang.newText(new Offset(0, 40, step31, "SW"), this.translator.translateMessage("step4"), "line4", null, tpsteps);
        Text step41 = this.lang.newText(new Offset(0, 20, step4, "SW"), this.translator.translateMessage("step41"), "line41", null, tpsteps);
        this.lang.nextStep();
        algoinWords.hide();
        step0.hide();
        step01.hide();
        step02.hide();
        step1.hide();
        step2.hide();
        step3.hide();
        step31.hide();
        step4.hide();
        step41.hide();
        this.array = this.lang.newStringArray(new Offset(0, 100, this.header, "SW"), text, "stringArray", null, ap);
        this.code = this.installCodeBlock("code", "code", new Offset(0, 50, this.array, "SW"));
        this.lang.nextStep();
        ArrayMarkerProperties amp = new ArrayMarkerProperties();
        amp.set("label", "i");
        amp.set("color", Color.BLACK);
        this.code.highlight("header");
        this.lang.nextStep();
        this.code.toggleHighlight("header", "declare");
        String w = "";
        String k = "";
        String result = "";
        this.lang.nextStep();
        this.code.toggleHighlight("declare", "cnt=256");
        this.lang.nextStep();
        this.code.toggleHighlight("cnt=256", "hashtable");
        int cnt = 256;
        this.lang.nextStep();
        this.code.toggleHighlight("hashtable", "for-init");
        this.code.highlight("initHT");
        this.code.highlight("end-for-init");
        Hashtable<String, Integer> dict = new Hashtable<String, Integer>();
        int i2 = 0;
        while (i2 < 256) {
            dict.put(String.valueOf((char)i2), i2);
            ++i2;
        }
        String[][] dictData = new String[24][2];
        int i3 = 0;
        while (i3 < 24) {
            dictData[i3][0] = "" + i3;
            dictData[i3][1] = "1" + i3;
            ++i3;
        }
        int matrixCount = 0;
        Text dictText = null;
        Text dictValue = null;
        ArrayMarker am = this.lang.newArrayMarker(this.array, 0, "arrayMarker", null, amp);
        Text wLabel = this.lang.newText(new Offset(0, 50, this.code, "SW"), "w: ", "w", null, tpsteps);
        Text kLabel = this.lang.newText(new Offset(0, 20, wLabel, "SW"), "k: ", "k", null, tpsteps);
        Text outputLabel = this.lang.newText(new Offset(0, 30, kLabel, "SW"), this.translator.translateMessage("output"), "output", null, tpsteps);
        Text output = this.lang.newText(new Offset(15, -5, outputLabel, "SE"), "", "output", null, tpsteps);
        int highlightCounter = 0;
        output.changeColor(null, Color.BLUE, null, null);
        PolylineProperties ptrP = new PolylineProperties();
        ptrP.set("fwArrow", true);
        this.code.unhighlight("end-for-init");
        this.code.unhighlight("initHT");
        this.code.unhighlight("for-init");
        int i4 = 0;
        while (i4 < text.length) {
            am.move(i4, null, null);
            this.code.highlight("for-i");
            this.lang.nextStep();
            this.code.toggleHighlight("for-i", "set-k");
            k = text[i4];
            kLabel.setText("k:  " + k, null, null);
            this.lang.nextStep();
            this.code.toggleHighlight("set-k", "contains?");
            if (dict.containsKey(String.valueOf(w) + k)) {
                Text currentValue;
                Text currentText = this.internalMap.get(String.valueOf(w) + k);
                if (currentText != null) {
                    currentText.changeColor("color", Color.RED, null, null);
                }
                if ((currentValue = this.internalMap.get(String.valueOf(w) + k + "_v")) != null) {
                    currentValue.changeColor("color", Color.RED, null, null);
                }
                this.lang.nextStep();
                if (currentText != null) {
                    currentText.changeColor("color", Color.BLACK, null, null);
                }
                if (currentValue != null) {
                    currentValue.changeColor("color", Color.BLACK, null, null);
                }
                this.code.toggleHighlight("contains?", "w+k");
                w = String.valueOf(w) + k;
                wLabel.setText("w: " + w, null, null);
                this.lang.nextStep();
                this.code.unhighlight("w+k");
            } else {
                this.lang.nextStep();
                this.code.toggleHighlight("contains?", "else");
                this.lang.nextStep();
                this.code.highlight("result");
                result = String.valueOf(result) + dict.get(w) + " ";
                output.setText(result, null, null);
                this.lang.nextStep();
                this.code.toggleHighlight("result", "dict.put");
                String key = String.valueOf(w) + k;
                dict.put(key, cnt);
                if (dictText == null) {
                    dictText = this.lang.newText(new Offset(40, -200, this.code, "NE"), key, "dictText" + cnt, null, tpsteps);
                    dictValue = this.lang.newText(new Offset(70, 0, dictText, "baseline start"), String.valueOf(cnt), "dictVal" + cnt, null, tpsteps);
                } else {
                    dictText = this.lang.newText(new Offset(0, 20, dictText, "SW"), key, "dictText" + cnt, null, tpsteps);
                    dictValue = this.lang.newText(new Offset(0, 20, dictValue, "SW"), String.valueOf(cnt), "dictVal" + cnt, null, tpsteps);
                }
                this.internalMap.put(key, dictText);
                this.internalMap.put(String.valueOf(key) + "_v", dictValue);
                ++highlightCounter;
                ++matrixCount;
                this.lang.nextStep();
                this.code.toggleHighlight("dict.put", "cnt++");
                ++cnt;
                this.lang.nextStep();
                this.code.toggleHighlight("cnt++", "w=k");
                w = k;
                wLabel.setText("w: " + w, null, null);
                this.lang.nextStep();
                this.code.unhighlight("w=k");
                this.code.unhighlight("else");
            }
            ++i4;
        }
        Text fazit1 = this.lang.newText(new Offset(0, 90, outputLabel, "SW"), this.translator.translateMessage("noDict"), "name", null, tpsteps);
        Text fazit2 = this.lang.newText(new Offset(0, 20, fazit1, "SW"), this.translator.translateMessage("finish"), "fazit", null, tpsteps);
        this.lang.nextStep();
        fazit1.hide();
        fazit2.hide();
        wLabel.hide();
        outputLabel.hide();
        output.hide();
        kLabel.hide();
    }

    @Override
    protected void hideNrStepsArrayCode() {
        super.hideNrStepsArrayCode();
        for (Text t : this.internalMap.values()) {
            t.hide();
        }
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> prims) {
        this.setUpDefaultElements(props, prims, "stringArray", "code", "code", 0, 20);
        String[] strArray = (String[])this.primitives.get("stringArray");
        try {
            this.compress(strArray);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
        this.wrapUpAnimation();
        this.lang.finalizeGeneration();
        return this.lang.getAnimationCode();
    }

    @Override
    public Primitive installAdditionalComponents(String arrayKey, String codeKey, String codeName, int dx, int dy) {
        return null;
    }

    @Override
    public Locale getContentLocale() {
        return this.contentLocale;
    }
}

