/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.compression;

import algoanim.animalscript.AnimalScript;
import algoanim.primitives.IntMatrix;
import algoanim.primitives.StringMatrix;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import algoanim.util.Offset;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.compression.CompressionAlgorithm;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Vector;

public class BurrowsWheelerReTransformation
extends CompressionAlgorithm
implements Generator {
    public static int index;
    private static final int inputLimit = 20;
    private static final String DESCRIPTION = "Die Burrows Wheeler Retransformation ist die Umkehrung der gleichnamigen Transformation. Die Transformation dient als eine Vorbereitung f\u00b8r andere Kompressionsverfahren. Es handelt sich um eine Transformation, da die Daten nicht verringert, sondern nur anders angeordnet werden.";
    private static final String SOURCE_CODE = "Der Algorithmus wird in einer Animation demonstriert. Um die grafische Animation in voller Gr\u02c6\ufb02e darstellen zu k\u02c6nnen, wird die Eingabe auf 20 Buchstaben begrenzt. Es handelt sich hier um einen Dekodierungsalgorithmus. Ihre Eingabe wird zun\u2030chst durch die entsprechende Kodierung kodiert. Erst diese Daten werden dekodiert.";

    public BurrowsWheelerReTransformation() {
        this(new AnimalScript("Burrows Wheeler Retransformation", "Florian Lindner", 800, 600));
    }

    public BurrowsWheelerReTransformation(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public void transform(String[] text) {
        String ein = "";
        String[] t = new String[Math.min(text.length, 20)];
        int i = 0;
        while (i < t.length) {
            t[i] = text[i];
            ein = String.valueOf(ein) + text[i];
            ++i;
        }
        text = t;
        Text topic = this.lang.newText(new Coordinates(20, 50), "Burrows Wheeler Retransformation", "Topic", null, tptopic);
        this.lang.newRect(new Offset(-5, -5, topic, "NW"), new Offset(5, 5, topic, "SE"), "topicRect", null, rctp);
        this.lang.nextStep();
        Text algoinWords = this.lang.newText(new Coordinates(20, 100), "Der Algorithmus in Worten", "inWords", null, tpwords);
        this.lang.nextStep();
        Text step1 = this.lang.newText(new Offset(0, 100, topic, "SW"), "1) Bilde einen Vektor L, der genau die Eingabebuchstaben beinhaltet.", "line1", null, tpsteps);
        this.lang.nextStep();
        Text step2 = this.lang.newText(new Offset(0, 30, step1, "SW"), "2) Bilde einen Vektor F, der die Eingabebuchstaben in alphabetisch", "line2", null, tpsteps);
        Text step21 = this.lang.newText(new Offset(0, 30, step2, "SW"), "      geordneter Reihenfolge beinhaltet.", "line21", null, tpsteps);
        this.lang.nextStep();
        Text step3 = this.lang.newText(new Offset(0, 30, step21, "SW"), "3) Erstelle den Transformationsvektor T, welcher L auf F abbildet.", "line3", null, tpsteps);
        this.lang.nextStep();
        Text step4 = this.lang.newText(new Offset(0, 30, step3, "SW"), "4) Berechne die Vorg\u2030ngerbuchstaben jedes Buchstabens in L. Beginne", "line4", null, tpsteps);
        Text step41 = this.lang.newText(new Offset(0, 20, step4, "SW"), "      hierf\u00b8r an der Indexstelle, welche bei der Transformation", "line32", null, tpsteps);
        Text step42 = this.lang.newText(new Offset(0, 20, step41, "SW"), "      \u00b8bergeben wurde. F\u00b8r den Vorg\u2030ngerbuchstaben gilt:", "line32", null, tpsteps);
        Text step43 = this.lang.newText(new Offset(0, 20, step42, "SW"), "      Pr\u2030fix von L[i] = L[T[i]]", "line32", null, tpsteps);
        this.lang.nextStep();
        algoinWords.hide();
        step1.hide();
        step2.hide();
        step21.hide();
        step3.hide();
        step4.hide();
        step41.hide();
        step42.hide();
        step43.hide();
        tpwords.set("font", new Font("SansSerif", 0, 16));
        String input = "";
        int i2 = 0;
        while (i2 < text.length) {
            input = String.valueOf(input) + text[i2];
            ++i2;
        }
        algoinWords.setText("Eingabe:  " + input, null, null);
        algoinWords.show();
        this.lang.nextStep();
        input = BurrowsWheelerReTransformation.encode(text);
        this.lang.newText(new Offset(0, 20, algoinWords, "SW"), "Durch die Burrows Wheeler Transformation erhalten wir: " + BurrowsWheelerReTransformation.encode(text) + " sowie die Indexstelle " + index, "text", null, tpwords);
        this.lang.nextStep();
        TextProperties tplabel = new TextProperties();
        tplabel.set("font", new Font("Serif", 1, 22));
        tplabel.set("color", Color.BLUE);
        int[][] indexContent = new int[input.length()][1];
        int i3 = 0;
        while (i3 < input.length()) {
            indexContent[i3][0] = i3;
            ++i3;
        }
        Text labelIndex = this.lang.newText(new Offset(0, 74, step1, "SW"), "Index", "lable", null, tplabel);
        IntMatrix matrixInd = this.lang.newIntMatrix(new Offset(-5, 15, labelIndex, "S"), indexContent, "matrixInd", null, mp);
        this.lang.nextStep();
        step1.changeColor(null, Color.RED, null, null);
        step1.show();
        String[] L = new String[input.length()];
        int i4 = 0;
        while (i4 < input.length()) {
            L[i4] = "" + input.charAt(i4);
            ++i4;
        }
        String[][] contentL = new String[L.length][1];
        int i5 = 0;
        while (i5 < L.length) {
            contentL[i5][0] = L[i5];
            ++i5;
        }
        this.lang.nextStep();
        Text labelL = this.lang.newText(new Offset(70, 74, step1, "SW"), "L", "lable", null, tplabel);
        StringMatrix matrixL = this.lang.newStringMatrix(new Offset(-5, 15, labelL, "S"), contentL, "matrixL", null, mp);
        this.lang.nextStep();
        step1.setText(step2.getText(), null, null);
        step2.changeColor(null, Color.RED, null, null);
        step2.setText(step21.getText(), null, null);
        step2.show();
        this.lang.nextStep();
        String[] F = new String[input.length()];
        String tmpS = input;
        char tmp = '\u00ff';
        int i6 = 0;
        while (i6 < input.length()) {
            tmp = '\u00ff';
            int j = 0;
            while (j < tmpS.length()) {
                if (tmpS.charAt(j) < tmp) {
                    tmp = tmpS.charAt(j);
                }
                ++j;
            }
            F[i6] = "" + tmp;
            tmpS = tmpS.replaceFirst("" + tmp, "");
            ++i6;
        }
        String[][] contentF = new String[F.length][1];
        int i7 = 0;
        while (i7 < F.length) {
            contentF[i7][0] = F[i7];
            ++i7;
        }
        Text labelF = this.lang.newText(new Offset(160, 74, step1, "SW"), "F", "lable", null, tplabel);
        this.lang.newStringMatrix(new Offset(-5, 15, labelF, "S"), contentF, "matrixF", null, mp);
        this.lang.nextStep();
        step2.hide();
        step1.setText(step3.getText(), null, null);
        this.lang.nextStep();
        int[] T = new int[input.length()];
        boolean[] done = new boolean[input.length()];
        int i8 = 0;
        while (i8 < L.length) {
            int j = 0;
            while (j < F.length) {
                if (L[i8].equals(F[j]) && !done[j]) {
                    T[i8] = j;
                    done[j] = true;
                    break;
                }
                ++j;
            }
            ++i8;
        }
        int[][] contentT = new int[T.length][1];
        int i9 = 0;
        while (i9 < T.length) {
            contentT[i9][0] = T[i9];
            ++i9;
        }
        Text labelT = this.lang.newText(new Offset(250, 74, step1, "SW"), "T", "lable", null, tplabel);
        IntMatrix matrixT = this.lang.newIntMatrix(new Offset(-5, 15, labelT, "S"), contentT, "matrixT", null, mp);
        this.lang.nextStep();
        step1.changeColor(null, Color.BLACK, null, null);
        Text iterate = this.lang.newText(new Offset(0, 50, matrixInd, "SW"), "Wir berechnen die Vorbuchstaben jedes Buchstaben der Ausgabe durch: Pr\u2030fix von L[i] = L[T[i]]", "iter", null, tpsteps);
        Text iterate2 = this.lang.newText(new Offset(0, 15, iterate, "SW"), "und beginnen in L an der errechneten Indexstelle ", "iter", null, tpsteps);
        Text iterate3 = this.lang.newText(new Offset(15, -4, iterate2, "SE"), "" + index, "iter", null, tpsteps);
        iterate.changeColor(null, Color.RED, null, null);
        iterate2.changeColor(null, Color.RED, null, null);
        iterate3.changeColor(null, Color.BLUE, null, null);
        this.lang.nextStep();
        String result = L[index];
        while (result.length() < input.length()) {
            Text fin = this.lang.newText(new Offset(0, 50, iterate2, "SW"), "Das Pr\u2030fix von " + L[index] + " ist " + L[T[index]], "fin", null, tpsteps);
            result = String.valueOf(L[T[index]]) + result;
            matrixL.highlightCell(index, 0, null, null);
            matrixL.highlightCell(T[index], 0, null, null);
            matrixT.highlightCell(index, 0, null, null);
            Text fin2 = this.lang.newText(new Offset(0, 15, fin, "SW"), "Kombiniert ergibt das f\u00b8r die Ausgabe:   " + result, "fin", null, tpsteps);
            this.lang.nextStep();
            matrixL.unhighlightCell(index, 0, null, null);
            matrixL.unhighlightCell(T[index], 0, null, null);
            matrixT.unhighlightCell(index, 0, null, null);
            index = T[index];
            fin.hide();
            fin2.hide();
        }
        this.lang.nextStep();
        Text fazit1 = this.lang.newText(new Offset(0, 50, iterate2, "SW"), "Daraus ergibt sich die Ausgabe:  ", "fazit", null, tpsteps);
        tpsteps.set("color", Color.BLUE);
        this.lang.newText(new Offset(15, 8, fazit1, "E"), result, "fazit1", null, tpsteps);
        tpsteps.set("color", Color.BLACK);
    }

    private static String encode(String[] text) {
        int i;
        Vector<String[]> rotations = new Vector<String[]>(0, 1);
        String[] tmp = text;
        int i2 = 0;
        while (i2 < text.length) {
            rotations.add(BurrowsWheelerReTransformation.rotateLeft(tmp));
            tmp = BurrowsWheelerReTransformation.rotateLeft(tmp);
            ++i2;
        }
        Vector<String[]> sorted = new Vector<String[]>(0, 1);
        String[] early = (String[])rotations.elementAt(0);
        while (!rotations.isEmpty()) {
            i = 0;
            while (i < rotations.size()) {
                if (BurrowsWheelerReTransformation.isEarlier((String[])rotations.elementAt(i), early)) {
                    early = (String[])rotations.elementAt(i);
                    index = 1;
                }
                ++i;
            }
            sorted.add(early);
            rotations.removeElement(early);
            index = 0;
            if (rotations.isEmpty()) continue;
            early = (String[])rotations.elementAt(0);
        }
        i = 0;
        while (i < sorted.size()) {
            boolean equal = true;
            int j = 0;
            while (j < text.length) {
                if (text[j] != ((String[])sorted.elementAt(i))[j]) {
                    equal = false;
                    break;
                }
                ++j;
            }
            if (equal) {
                index = i;
                break;
            }
            ++i;
        }
        String result = "";
        int i3 = 0;
        while (i3 < sorted.size()) {
            result = String.valueOf(result) + ((String[])sorted.elementAt(i3))[((String[])sorted.elementAt(i3)).length - 1];
            ++i3;
        }
        return result;
    }

    public static String[] rotateLeft(String[] text) {
        String[] tmp = new String[text.length];
        int i = 0;
        while (i < text.length - 1) {
            tmp[i] = text[i + 1];
            ++i;
        }
        tmp[text.length - 1] = text[0];
        return tmp;
    }

    public static boolean isEarlier(String[] text1, String[] text2) {
        int i = 0;
        while (i < text1.length) {
            int first = new Integer(text1[i].charAt(0));
            int second = new Integer(text2[i].charAt(0));
            if (text1[i].equals(".")) {
                first = Integer.MAX_VALUE;
            }
            if (text2[i].equals(".")) {
                second = Integer.MAX_VALUE;
            }
            if (first < second) {
                return true;
            }
            if (first > second) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public static String getDESCRIPTION() {
        return DESCRIPTION;
    }

    public static String getSOURCE_CODE() {
        return SOURCE_CODE;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getName() {
        return "Burrows Wheeler Retransformation";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        String[] strArray = (String[])primitives.get("stringArray");
        this.transform(strArray);
        this.lang.finalizeGeneration();
        return this.lang.getAnimationCode();
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(64);
    }

    @Override
    public String getAlgorithmName() {
        return "Burrows-Wheeler Transformation";
    }

    @Override
    public void init() {
    }
}

