/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import algoanim.animalscript.AnimalScript;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.IntArray;
import algoanim.primitives.SourceCode;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.properties.ArrayProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import algoanim.util.TicksTiming;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.helpers.AnimatedIntArrayAlgorithm;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Locale;

public class ShakerSortAnimation
extends AnimatedIntArrayAlgorithm
implements Generator {
    private int textCounter = 0;
    private Language language;
    private static ArrayProperties arrProp;
    private static ArrayMarkerProperties links_zeiger;
    private static ArrayMarkerProperties rechts_zeiger;
    private static ArrayMarkerProperties i_zeiger;
    private static ArrayMarkerProperties j_zeiger;
    private static SourceCodeProperties sc_prop;
    private static TextProperties tp1;
    private static TextProperties tp2;
    private static TextProperties tp3;
    private static TextProperties tp4;
    private SourceCode sc;
    private static final String CODE_BESCHREIBUNG = "public <T extends Comparable <T>> void BubleSort (T [] liste)\n{\nint links = 0;\nint rechts = liste.length - 1;\nboolean vertauscht = true;\nwhile(vertauscht)\n{\nvertauscht = false;\nfor(int i = links; i < rechts; i++)\n{\nif (liste[i].compareTo(liste[i+1]) > 0)\n{\nvertauscht = true;\nswap(liste, liste[i], liste[i+1]);\n}\n}\nrechts--\nfor(int j = rechts; j < links; j--)\n{\nif (liste[j].compareTo(liste[j-1]) < 0)\n{\nvertauscht = true;\nswap(liste, liste[j], liste[j-1]);\n}\n}\nlinks++\n}\n}";
    public static final String ALGO_BESCHREIBUNG = "SHAKERSORT\nBeschreibung des Algorithmus\n1. Die zu sortierende Liste wird abwechselnd vom Beginn bzw. vom Ende her durchlaufen\n2. Vom Beginn her vergleicht man immer zwei benachbarte Elemente\n3. Sind diese Elemente falsch sortiert, dann vertauscht man sie\n4. Nach dem ersten Durchlauf ist das gr\u02c6\ufb02te Element an seiner richtigen Position\n5. Danach geht man vom Ende her und vergleicht wiederum immer zwei benachbarte Elemente\n6. Sind diese falsch sortiert, dann vertauscht man sie\n7. Nach dem zweiten Durchlauf ist das kleinste Elemente an seiner richtigen Position\n8. Die Schritte 2 bis 7 wiederholt man bis alle Elemente sortiert sind.";

    public void sort(int[] liste) {
        Text t0 = this.language.newText(new Coordinates(150, 20), "SHAKERSORT", "f1" + this.textCounter, null, tp1);
        ++this.textCounter;
        this.language.nextStep();
        Text t1 = this.language.newText(new Coordinates(150, 60), "Beschreibung des Algorithmus", "f1" + this.textCounter, null, tp2);
        ++this.textCounter;
        this.language.nextStep();
        Text t2 = this.language.newText(new Coordinates(20, 120), "1. Die zu sortierende Liste wird abwechselnd vom Beginn bzw. vom Ende her durchlaufen", "f1" + this.textCounter, null, tp3);
        ++this.textCounter;
        this.language.nextStep();
        Text t3 = this.language.newText(new Coordinates(20, 160), "2. Vom Beginn her vergleicht man immer zwei benachbarte Elemente ", "f1" + this.textCounter, null, tp3);
        ++this.textCounter;
        this.language.nextStep();
        Text t4 = this.language.newText(new Coordinates(20, 200), "3. Sind diese Elemente falsch sortiert, dann vertauscht man die", "f1" + this.textCounter, null, tp3);
        ++this.textCounter;
        this.language.nextStep();
        Text t5 = this.language.newText(new Coordinates(20, 240), "4. Nach dem ersten Durchlauf ist das gr\u02c6\ufb02te Element an seiner richtigen Position", "f1" + this.textCounter, null, tp3);
        ++this.textCounter;
        this.language.nextStep();
        Text t6 = this.language.newText(new Coordinates(20, 280), "5. Danach geht man vom Ende her und vergleicht wiederum immer zwei benachbarte Elemente", "f1" + this.textCounter, null, tp3);
        ++this.textCounter;
        this.language.nextStep();
        Text t7 = this.language.newText(new Coordinates(20, 320), "6. Sind diese falsch sortiert, dann vertauscht man die", "f1" + this.textCounter, null, tp3);
        ++this.textCounter;
        this.language.nextStep();
        Text t8 = this.language.newText(new Coordinates(20, 360), "7. Nach dem zweiten Durchlauf, ist das kleinste Elemente an seiner richtigen Position", "f1" + this.textCounter, null, tp3);
        ++this.textCounter;
        this.language.nextStep();
        Text t9 = this.language.newText(new Coordinates(20, 400), "8. Die Schritte 2 bis 7 wiederholt man bis alle Elemente sortiert sind.", "f1" + this.textCounter, null, tp3);
        ++this.textCounter;
        this.language.nextStep();
        t0.hide();
        t1.hide();
        t2.hide();
        t3.hide();
        t4.hide();
        t5.hide();
        t6.hide();
        t7.hide();
        t8.hide();
        t9.hide();
        this.language.nextStep();
        this.language.newText(new Coordinates(150, 20), "ShakerSort Animationsbeispiel", "f1" + this.textCounter, null, tp4);
        IntArray array = this.language.newIntArray(new Coordinates(20, 100), liste, "array", null, arrProp);
        this.sc = this.language.newSourceCode(new Coordinates(20, 150), "code", null, sc_prop);
        this.sc.addCodeLine("public <T extends Comparable <T>> void BubleSort (T [] liste)", null, 0, null);
        this.sc.addCodeLine("{", null, 0, null);
        this.sc.addCodeLine("int links = 0;", null, 1, null);
        this.sc.addCodeLine("int rechts = liste.length - 1;", null, 1, null);
        this.sc.addCodeLine("boolean vertauscht = true;", null, 1, null);
        this.sc.addCodeLine("while(vertauscht)", null, 1, null);
        this.sc.addCodeLine("{", null, 1, null);
        this.sc.addCodeLine("vertauscht = false;", null, 2, null);
        this.sc.addCodeLine("for(int i = links; i < rechts; i++)", null, 2, null);
        this.sc.addCodeLine("{", null, 2, null);
        this.sc.addCodeLine("if (liste[i].compareTo(liste[i+1]) > 0)", null, 3, null);
        this.sc.addCodeLine("{", null, 3, null);
        this.sc.addCodeLine("vertauscht = true;", null, 4, null);
        this.sc.addCodeLine("swap(liste, liste[i], liste[i+1])", null, 4, null);
        this.sc.addCodeLine("}", null, 3, null);
        this.sc.addCodeLine("}", null, 2, null);
        this.sc.addCodeLine("rechts--", null, 2, null);
        this.sc.addCodeLine("for(int j = rechts; j < links; j--)", null, 2, null);
        this.sc.addCodeLine("{", null, 2, null);
        this.sc.addCodeLine("if (liste[j].compareTo(liste[j-1]) < 0)", null, 3, null);
        this.sc.addCodeLine("{", null, 3, null);
        this.sc.addCodeLine("vertauscht = true;", null, 4, null);
        this.sc.addCodeLine("swap(liste, liste[j], liste[j-1])", null, 4, null);
        this.sc.addCodeLine("}", null, 3, null);
        this.sc.addCodeLine("}", null, 2, null);
        this.sc.addCodeLine("links++", null, 2, null);
        this.sc.addCodeLine("}", null, 1, null);
        this.sc.addCodeLine("}", null, 0, null);
        this.language.nextStep();
        this.shakerSort(array, this.sc);
    }

    public void shakerSort(IntArray array, SourceCode sourceCode) {
        int links = 0;
        int rechts = array.getLength() - 1;
        boolean vertauscht = true;
        int i = 0;
        int j = 0;
        sourceCode.highlight(0);
        this.language.nextStep();
        sourceCode.toggleHighlight(0, 0, false, 2, 0);
        ArrayMarker links_Pointer = this.language.newArrayMarker(array, 0, "links", null, links_zeiger);
        this.language.nextStep();
        sourceCode.toggleHighlight(2, 0, false, 3, 0);
        ArrayMarker rechts_Pointer = this.language.newArrayMarker(array, rechts, "rechts", null, rechts_zeiger);
        this.language.nextStep();
        sourceCode.toggleHighlight(3, 0, false, 4, 0);
        this.language.nextStep();
        sourceCode.toggleHighlight(4, 0, false, 5, 0);
        while (vertauscht) {
            vertauscht = false;
            this.language.nextStep();
            sourceCode.toggleHighlight(5, 0, false, 7, 0);
            this.language.nextStep();
            sourceCode.toggleHighlight(7, 0, false, 8, 0);
            ArrayMarker i_Pointer = this.language.newArrayMarker(array, links, "i", null, i_zeiger);
            i = links;
            while (i < rechts) {
                this.language.nextStep();
                sourceCode.toggleHighlight(8, 0, false, 10, 0);
                array.highlightElem(i, i + 1, null, null);
                if (array.getData(i) > array.getData(i + 1)) {
                    vertauscht = true;
                    this.language.nextStep();
                    sourceCode.toggleHighlight(10, 0, false, 12, 0);
                    this.language.nextStep();
                    sourceCode.toggleHighlight(12, 0, false, 13, 0);
                    this.language.nextStep();
                    array.swap(i, i + 1, new TicksTiming(0), new TicksTiming(50));
                    this.language.nextStep();
                    sourceCode.toggleHighlight(13, 0, false, 8, 0);
                    i_Pointer.move(i, new TicksTiming(0), new TicksTiming(50));
                } else {
                    this.language.nextStep();
                    sourceCode.toggleHighlight(10, 0, false, 8, 0);
                    i_Pointer.move(i + 1, new TicksTiming(0), new TicksTiming(50));
                }
                array.unhighlightElem(i, i + 1, null, null);
                ++i;
            }
            this.language.nextStep();
            array.highlightCell(i, null, null);
            this.language.nextStep();
            sourceCode.toggleHighlight(8, 0, false, 16, 0);
            rechts_Pointer.move(--rechts, new TicksTiming(0), new TicksTiming(50));
            this.language.nextStep();
            sourceCode.toggleHighlight(16, 0, false, 17, 0);
            ArrayMarker j_Pointer = this.language.newArrayMarker(array, rechts, "j", null, j_zeiger);
            j = rechts;
            while (j > links) {
                this.language.nextStep();
                sourceCode.toggleHighlight(17, 0, false, 19, 0);
                array.highlightElem(j - 1, j, null, null);
                if (array.getData(j) < array.getData(j - 1)) {
                    this.language.nextStep();
                    sourceCode.toggleHighlight(19, 0, false, 21, 0);
                    vertauscht = true;
                    this.language.nextStep();
                    sourceCode.toggleHighlight(21, 0, false, 22, 0);
                    this.language.nextStep();
                    array.swap(j - 1, j, new TicksTiming(0), new TicksTiming(50));
                    this.language.nextStep();
                    sourceCode.toggleHighlight(22, 0, false, 17, 0);
                    j_Pointer.move(j, new TicksTiming(0), new TicksTiming(50));
                } else {
                    this.language.nextStep();
                    sourceCode.toggleHighlight(19, 0, false, 17, 0);
                    j_Pointer.move(j - 1, new TicksTiming(0), new TicksTiming(50));
                }
                array.unhighlightElem(j - 1, j, null, null);
                --j;
            }
            this.language.nextStep();
            array.highlightCell(j, null, null);
            this.language.nextStep();
            sourceCode.toggleHighlight(17, 0, false, 25, 0);
            links_Pointer.move(++links, new TicksTiming(0), new TicksTiming(50));
            this.language.nextStep();
            i_Pointer.hide();
            j_Pointer.hide();
            this.language.nextStep();
            sourceCode.toggleHighlight(25, 0, false, 5, 0);
        }
        this.language.nextStep();
        sourceCode.unhighlight(5);
        this.language.nextStep();
        array.highlightCell(0, array.getLength() - 1, null, null);
        this.language.nextStep();
        links_Pointer.hide();
        rechts_Pointer.hide();
        this.language.nextStep();
        sourceCode.hide();
        TextProperties tp = new TextProperties();
        tp.set("color", Color.black);
        tp.set("font", new Font("Serif", 1, 40));
        this.language.newText(new Coordinates(150, 300), "FERTIG !", "f2", null, tp);
    }

    public static void main(String[] args) {
        ShakerSortAnimation shakerSort = new ShakerSortAnimation();
        shakerSort.init();
        int[] myArray = new int[]{7, 3, 2, 4, 1, 13, 52, 13, 5, 1};
        shakerSort.sort(myArray);
        System.out.println(shakerSort.language.toString());
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        this.init();
        int[] arrayData = (int[])primitives.get("array");
        arrProp.set("color", props.get("array", "color"));
        this.sort(arrayData);
        return this.language.toString();
    }

    @Override
    public void init() {
        this.language = new AnimalScript("ShakerSort", "Paulin Nguimdoh", 640, 480);
        this.language.setStepMode(true);
        arrProp = new ArrayProperties();
        arrProp.set("color", Color.black);
        arrProp.set("fillColor", Color.gray);
        arrProp.set("elementColor", Color.black);
        arrProp.set("elemHighlight", Color.white);
        arrProp.set("cellHighlight", Color.green);
        i_zeiger = new ArrayMarkerProperties();
        i_zeiger.set("label", "i");
        i_zeiger.set("color", Color.blue);
        j_zeiger = new ArrayMarkerProperties();
        j_zeiger.set("label", "j");
        j_zeiger.set("color", Color.blue);
        links_zeiger = new ArrayMarkerProperties();
        links_zeiger.set("label", "links");
        links_zeiger.set("color", Color.pink);
        rechts_zeiger = new ArrayMarkerProperties();
        rechts_zeiger.set("label", "rechts");
        rechts_zeiger.set("color", Color.pink);
        tp1 = new TextProperties();
        tp1.set("color", Color.blue);
        tp1.set("font", new Font("Serif", 1, 35));
        tp2 = new TextProperties();
        tp2.set("color", Color.black);
        tp2.set("font", new Font("Serif", 1, 24));
        tp3 = new TextProperties();
        tp3.set("color", Color.black);
        tp3.set("font", new Font("Serif", 0, 20));
        tp4 = new TextProperties();
        tp4.set("color", Color.black);
        tp4.set("font", new Font("Serif", 1, 35));
        sc_prop = new SourceCodeProperties();
        sc_prop.set("color", Color.black);
        sc_prop.set("highlightColor", Color.red);
        sc_prop.set("contextColor", Color.cyan);
        sc_prop.set("font", new Font("Monospaced", 1, 14));
    }

    @Override
    public String getAnimationAuthor() {
        return "Paulin Nguimdoh";
    }

    @Override
    public String getAlgorithmName() {
        return "Shakersort";
    }

    @Override
    public String getCodeExample() {
        return CODE_BESCHREIBUNG;
    }

    @Override
    public Locale getContentLocale() {
        return Locale.US;
    }

    @Override
    public String getDescription() {
        return ALGO_BESCHREIBUNG;
    }

    @Override
    public String getFileExtension() {
        return ".asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(1);
    }

    @Override
    public String getName() {
        return "ShakerSortAnimation";
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }
}

