/*
 * Decompiled with CFR 0.152.
 */
package de.ahrgr.animal.kohnert.generatorgui;

import components.ColorChooserComboBox;
import components.FontChooserComboBox;
import de.ahrgr.animal.kohnert.asugen.Font;
import de.ahrgr.animal.kohnert.asugen.property.FormatedTextProperty;
import de.ahrgr.animal.kohnert.asugen.property.Property;
import de.ahrgr.animal.kohnert.generatorgui.PropertyEdit;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FormatedTextPropertyEdit
extends PropertyEdit {
    private static final long serialVersionUID = -6371618650311318498L;
    protected FormatedTextProperty property;
    protected JTextField textField;
    protected FontChooserComboBox fontCombo;
    protected ColorChooserComboBox colorCombo;
    protected JComboBox sizeCombo;
    protected JCheckBox boldCheckBox;
    protected JCheckBox italicCheckBox;

    public FormatedTextPropertyEdit() {
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(10, 1));
        p.add((Component)new JLabel("text line:"), 0);
        this.textField = new JTextField();
        p.add((Component)this.textField, 1);
        p.add((Component)new JLabel("font:"), 2);
        this.fontCombo = new FontChooserComboBox();
        p.add((Component)this.fontCombo, 3);
        p.add((Component)new JLabel("font size:"), 4);
        String[] sizes = new String[]{"0", "6", "8", "12", "16", "20", "22"};
        this.sizeCombo = new JComboBox<String>(sizes);
        p.add((Component)this.sizeCombo, 5);
        this.boldCheckBox = new JCheckBox("bold");
        p.add((Component)this.boldCheckBox, 6);
        this.italicCheckBox = new JCheckBox("italic");
        p.add((Component)this.italicCheckBox, 7);
        p.add((Component)new JLabel("font color:"), 8);
        this.colorCombo = new ColorChooserComboBox();
        p.add((Component)this.colorCombo, 9);
        this.add((Component)p, "North");
        p.validate();
        this.validate();
    }

    public void setProperty(FormatedTextProperty p) {
        this.property = p;
        this.textField.setText(p.getText());
        Font f = p.getFont();
        this.fontCombo.setFontSelected(p.getFont().toString());
        this.boldCheckBox.setSelected(f.getIsBold());
        this.italicCheckBox.setSelected(f.getIsItalic());
        this.sizeCombo.setSelectedItem("" + f.getSize());
        this.colorCombo.setColorSelected(p.getColor().toString());
    }

    @Override
    public Property getProperty() {
        return this.property;
    }

    @Override
    public void writeProperty() {
        this.property.setText(this.textField.getText());
        Font f = Font.createFromString(this.fontCombo.getFontSelectedAsString());
        f = f.deriveBold(this.boldCheckBox.isSelected());
        f = f.deriveItalic(this.italicCheckBox.isSelected());
        int size = Integer.parseInt((String)this.sizeCombo.getSelectedItem());
        f = f.deriveSize(size);
        this.property.setFont(f);
        this.property.setColor(this.colorCombo.getColorSelectedAsString());
    }

    @Override
    public void reloadProperty() {
        this.setProperty(this.property);
    }
}

